<?php
/**
 * The template for displaying pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Automatic
 * @since Automatic 1.0
 */

get_header();
$automatic_sidebar_position = 'none';
$padding_top = 'padding-top-40';
$padding_bottom = 'padding-bottom-40';
$automatic_class_sidebar = '';
$page_show_breadcrumb = '';
if(get_post_meta(get_the_ID(), 'sidebar_position', true)){
    $automatic_sidebar_position = get_post_meta(get_the_ID(), 'sidebar_position', true);
}
if(get_post_meta(get_the_ID(), 'sidebar', true)){
    $automatic_sidebars = get_post_meta(get_the_ID(), 'sidebar', true);
}
$automatic_config = automatic_settings();

if(isset($automatic_config['page_sidebar_position']) && $automatic_sidebar_position == 'default'){
	$automatic_sidebar_position = $automatic_config['page_sidebar_position'];
}
if(isset($automatic_config['page_sidebar_ct']) && $automatic_config['page_sidebar_ct']!='' && $automatic_sidebars == 'default'){
	$automatic_sidebars = $automatic_config['page_sidebar_ct'];
	if(!is_active_sidebar($automatic_sidebars)){
		$automatic_sidebar_position = 'none'; 
	}
}
if ( get_post_meta(get_the_ID(), 'no_padding_top', true) != ''){
	$padding_top = get_post_meta(get_the_ID(), 'no_padding_top', true);
}
if ( get_post_meta(get_the_ID(), 'no_padding_bottom', true) != ''){
	$padding_bottom = get_post_meta(get_the_ID(), 'no_padding_bottom', true);
}
$show_title = 'hide';
if(isset($automatic_config['page_title']) && $automatic_config['page_title']!=''){
	$show_title = $automatic_config['page_title'];
} 
if ( get_post_meta(get_the_ID(), 'show_title_page', true) != '' && get_post_meta(get_the_ID(), 'show_title_page', true) != 'default'){
	$show_title = get_post_meta(get_the_ID(), 'show_title_page', true);
}

if($automatic_sidebar_position == 'left-sidebar' ){
	$automatic_class_sidebar = "sidebar_left";
	$automatic_wrap_content = 'col-xs-12 col-sm-12 col-md-9 right';
}else if( $automatic_sidebar_position == 'right-sidebar' ){
	$automatic_class_sidebar = "sidebar_right";
	$automatic_wrap_content = 'col-xs-12 col-sm-12 col-md-9';
}else{
	$automatic_wrap_content='col-xs-12 col-sm-12 col-md-12';
}
$page_show_breadcrumb = 'hide'; 
if(isset($automatic_config['page_bread_crumb']) && $automatic_config['page_bread_crumb']!=''){
	$page_show_breadcrumb = $automatic_config['page_bread_crumb'];
} 
if ( get_post_meta(get_the_ID(), 'show_breadcrumb', true) != '' && get_post_meta(get_the_ID(), 'show_breadcrumb', true) != 'default'){
	$page_show_breadcrumb = get_post_meta(get_the_ID(), 'show_breadcrumb', true);
}
?>

<div id="primary" class="content-area">
	<main id="main" class="site-main">
		<?php
		if (automatic_layout_page() == 'type1') echo '<div class="container '.$padding_top.' '.$padding_bottom.'">';
		elseif (automatic_layout_page() == 'type2') echo '<div class="container-fluid automatic_inbox_wrap '.$padding_top.' '.$padding_bottom.'">' ?>
			<?php if ( $page_show_breadcrumb == 'show' ) { ?>
			<div class="bread-crumb">
				<?php echo automatic_breadcrumbs(); ?>
			</div> 
			<?php } ?>
			<?php if($show_title == 'show'){ ?>
			<div class="text-center page-title"><h2><?php the_title(); ?></h2></div>
			<?php } ?>
			<div class="row">
				<div class="<?php echo ($automatic_wrap_content); ?>">
					<?php
					// Start the loop.
					while ( have_posts() ) : the_post();
						// Include the page content template.
						get_template_part( 'template-parts/content', 'page' );
					// End of the loop.
					endwhile;
					?>
	            </div>
				<?php
				if( $automatic_sidebar_position != 'none' && $automatic_sidebar_position != '' ){ ?>
					<div class="col-md-3 col-xs-12 col-sm-12 <?php echo ( $automatic_class_sidebar ); ?>">
						<div class="sidebar sidebarArea">
							<?php dynamic_sidebar($automatic_sidebars ); ?>
						</div>
					</div>
				<?php
					}
				?>
			</div>
		</div>
	</main><!-- .site-main -->
</div><!-- .content-area -->
<?php get_footer(); ?>
