<?php
/**
 * Testimonial widget
 * @package automatic
 */

class WP_Automatic_Widget_Testimonial extends WP_Widget {

    public function __construct() {
        $widget_ops = array( 'classname' => 'automatic_widget_testimonial', 'description' => esc_html__( "Display Testimonial Slide", "automatic") );
        parent::__construct( 'automatic-testimonial', esc_html__( '[Automatic] Testimonial', 'automatic' ), $widget_ops );
        $this->alt_option_name = 'automatic_widget_testimonial';
    }
    public function widget( $args,  $instance ) {
        echo $args['before_widget'];
        $argas = array(
            'post_type' => 'testimonial',
            'post_status' => 'publish',
            'posts_per_page' => 3,

        );
        $rquery = New Wp_Query( $argas );
        if ( $rquery -> have_posts() ) :?>
            <?php
                 if ( $instance['title'] ) {
                    echo '<h2 class="widget-title-category">'.esc_html($instance['title']) . '</h2>';
                }
            ?>
            <div class="automatic-widget automatic-testi">
                <div class="beans-stepslider" data-rotate="true">
                    <div class="beans-mask">
                        <div class="beans-slideset">
                            <?php
                                while ( $rquery -> have_posts() ) : $rquery -> the_post();
                            ?>
                                <div class="beans-slide">
                                    <img class="icon-testi" src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/img_tes.png" alt="" />
                                    <div class="txt">
                                        <?php the_content(); ?>
                                    </div>
                                    <div class="testiImg">
                                        <?php the_post_thumbnail( 'full' );?>
                                        <div class="info">
                                            <h3><?php the_title(); ?></h3>
                                        </div>
                                    </div>
                                </div>
                            <?php
                                endwhile;
                                wp_reset_postdata();
                            ?>
                        </div>
                    </div>
                    <div class="beans-pagination">
                        <!-- pagination generated here -->
                    </div>
                </div>
            </div>
            <?php
        endif;
        echo $args['after_widget'];
    }
     /*Update data widget*/
    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = $new_instance['title'];
        return $instance;
    }

    /*Layout admin widget*/
    public function form( $instance ) {
        $title = isset( $instance['title'] ) ? wp_kses($instance['title'],array('span'=>array('class'=>array()))) : '';
        ?>
        <p><label for="<?php echo  esc_html($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:','automatic' ); ?></label>
        <input class="widefat" id="<?php echo  esc_html($this->get_field_id( 'title' )); ?>" name="<?php echo  esc_html($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo  esc_html($title); ?>" /></p>
    <?php
    }

}
