<?php
/**
 * Special product
 */

class WP_Automatic_Widget_Contact extends WP_Widget
{

    function __construct()
    {
        $widget_ops = array( 'classname' => 'automatic_widget_contact', 'description' => esc_html__( "Automatic Contact option.", "automatic") );
        parent::__construct( 'automatic-contact', esc_html__( '[Automatic] Contact', 'automatic' ), $widget_ops );
        $this->alt_option_name = 'automatic_widget_contact';
    }
    public function widget( $args, $instance ){
		$automatic_config = automatic_settings();

		echo $args['before_widget'];
        if ( $instance['title'] ) {
            echo $args['before_title'] . esc_html($instance['title']) . $args['after_title'];
        }
	?>
		<div class="footer-info-v1">
			<div class="links">
				<ul>
					<?php if ( $instance['address']=='show' && isset($automatic_config['automatic_address']) && $automatic_config['automatic_address']!='' ): ?>
					<li>
						<em class="automaticicon-home"></em>
						<span class="text"><?php echo wp_kses_post($automatic_config['automatic_address'])?></span>
					</li>
					<?php endif; ?>
					<?php if ( $instance['phone']=='show' && isset($automatic_config['automatic_phone']) && $automatic_config['automatic_phone']!='' ): ?>
					<li>
						<em class="automaticicon-phone"></em>
						<a href="tel:<?php echo wp_kses($automatic_config['automatic_phone'],array())?>"><?php  esc_html_e( 'Tel','automatic' ); ?>. <span class="text"><?php echo wp_kses($automatic_config['automatic_phone'],array())?></span></a>
					</li>
					<?php endif; ?>
					<?php if ( $instance['email']=='show' && isset($automatic_config['automatic_mail']) && $automatic_config['automatic_mail']!='' ): ?>
					<li>
						<em class="automaticicon-mail"></em>
						<a href="mailto:<?php echo wp_kses($automatic_config['automatic_mail'],array())?>"><?php  esc_html_e( 'Mail','automatic' ); ?>. <span class="text"><?php echo wp_kses($automatic_config['automatic_mail'],array())?></span></a>
					</li>
					<?php endif; ?>
				</ul>
			</div>
		</div>
	<?php
		echo $args['after_widget'];
    }
    public function update( $new_instance, $old_instance){
        $instance = $old_instance;
        $instance['title'] = $new_instance['title'];
        $instance['address'] = $new_instance['address'];
        $instance['phone'] = $new_instance['phone'];
        $instance['email'] = $new_instance['email'];

        return $instance;
    }
    public function form( $instance){
        $show_address  = isset( $instance['address'] ) ? esc_attr( $instance['address'] ) : '';
        $show_phone  = isset( $instance['phone'] ) ? esc_attr( $instance['phone'] ) : '';
        $show_email  = isset( $instance['email'] ) ? esc_attr( $instance['email'] ) : '';
        $title   = isset( $instance['title'] ) ? esc_html($instance['title']) : esc_html__('Connect Us','automatic');
        ?>
        <p><label for="<?php echo  esc_html($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:','automatic' ); ?></label>
        <input class="widefat" id="<?php echo  esc_html($this->get_field_id( 'title' )); ?>" name="<?php echo  esc_html($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo  esc_html($title); ?>" /></p>
        <p>
			<input type="checkbox" class="widefat" id="<?php echo ($this->get_field_id( 'address' )); ?>" name="<?php echo ($this->get_field_name( 'address' )); ?>" value="show" <?php checked( $show_address, 'show' ); ?>/>
			<label for="<?php echo ($this->get_field_id( 'show_address' )); ?>"><?php  esc_html_e( 'Show Address','automatic' ); ?></label>
		</p>
        <p>
			<input type="checkbox" class="widefat" id="<?php echo ($this->get_field_id( 'email' )); ?>" name="<?php echo ($this->get_field_name( 'email' )); ?>" value="show" <?php checked( $show_email, 'show' ); ?>/>
			<label for="<?php echo ($this->get_field_id( 'email' )); ?>"><?php  esc_html_e( 'Show Email','automatic' ); ?></label>
		</p>
        <p>
			<input type="checkbox" class="widefat" id="<?php echo ($this->get_field_id( 'phone' )); ?>" name="<?php echo ($this->get_field_name( 'phone' )); ?>" value="show" <?php checked( $show_phone, 'show' ); ?>/>
			<label for="<?php echo ($this->get_field_id( 'phone' )); ?>"><?php  esc_html_e( 'Show Phone','automatic' ); ?></label>
		</p>
        <?php
    }
}