<?php
function automatic_show_page_header_footer_option() {
    global $post;
    $automatic_header_layouts = array('Header Layout 1'=>'header_1', 'Header Layout 2'=>'header_2', 'Header Layout 3'=>'header_3',);
    $automatic_footer_layouts = array('Footer Layout 1'=>'footer_1', 'Footer Layout 2'=>'footer_2', 'Footer Layout 3'=>'footer_3');
    ?>
    <div class="automatic_header_layout">
        <label><strong><?php esc_html_e( 'Header layout', 'automatic');?></strong></label>
        <div>
            <select name="header_layout">
                <?php if(get_post_meta($post->ID, 'header_layout', true))
                    $automatic_selected = get_post_meta($post->ID, 'header_layout', true);
                    else $automatic_selected='';
                ?>
                <option value="default" <?php selected( $automatic_selected, 'default');?>>
                    <?php esc_html_e( 'Header Layout Default', 'automatic' );?>
                </option>
                <?php foreach ($automatic_header_layouts as $automatic_header_layout => $value){ ?>
                <option value="<?php echo esc_attr($value); ?>" <?php selected( $automatic_selected, $value);?>><?php echo esc_attr($automatic_header_layout); ?></option>
                <?php } ?>
            </select>
            <p class="description"><label></label><?php esc_html_e( 'Choose header layout', 'automatic');?></p>
        </div>
    </div>


    <?php // Layout footer ?>
    <div class="automatic_footer_layout">
        <label><strong><?php esc_html_e( 'Footer layout', 'automatic');?></strong></label>
        <div>
            <select name="footer_layout">
                <?php if(get_post_meta($post->ID, 'footer_layout', true))
                    $automatic_selected = get_post_meta($post->ID, 'footer_layout', true);
                    else $automatic_selected='';
                ?>
                <option value="default" <?php selected( $automatic_selected, 'default');?>>
                    <?php esc_html_e( 'Footer Layout Default', 'automatic' );?>
                </option>
                <?php foreach ($automatic_footer_layouts as $automatic_footer_layout => $value){ ?>
                <option value="<?php echo esc_attr($value); ?>" <?php selected( $automatic_selected, $value);?>><?php echo esc_attr($automatic_footer_layout); ?></option>
                <?php } ?>
            </select>
            <p class="description"><?php esc_html_e( 'Choose footer layout', 'automatic');?></p>
        </div>
    </div>
    <?php
}
function automatic_show_page_meta_option() {
    $meta_box = automatic_default_meta_data();
    automatic_show_meta_box($meta_box);
}

function automatic_save_page_meta_option($post_id) {
    $meta_box_default = automatic_default_meta_data();
    $meta_box_header_footer = automatic_header_footer_meta_data();
    $meta_box = array_merge($meta_box_default,$meta_box_header_footer);
    return automatic_save_meta_data($post_id, $meta_box);
}

function automatic_add_page_metaboxes() {
    if (function_exists('add_meta_box')) {
        add_meta_box('view-meta-boxes', esc_html__('Layout Options', 'automatic'), 'automatic_show_page_meta_option', 'page', 'side', 'low');
        add_meta_box('view-header-boxes', esc_html__('Header Options', 'automatic'), 'automatic_show_page_header_footer_option', 'page', 'normal', 'low');
    }
}
function automatic_meta_page_assets(){
	if ( isset( $GLOBALS['post_type'] ) && in_array( $GLOBALS['post_type'], array('page') ) ) {
		wp_enqueue_script( 'jquery-ui-core', get_template_directory_uri() . '/inc/functions/metaboxes/js/jquery-ui.min.js', array( 'jquery' ), '', true );
		wp_enqueue_script( 'automatic-metabox', get_template_directory_uri() . '/inc/functions/metaboxes/js/metabox.js', array( 'jquery' ), '1.0');
		wp_enqueue_script( 'automatic-page-metabox', get_template_directory_uri() . '/inc/functions/metaboxes/js/page.metabox.js', array( 'jquery' ), '1.0');
		wp_enqueue_style("automatic-page-metabox-style",get_template_directory_uri().'/inc/functions/metaboxes/css/metabox.css', array(), '1.0');
		wp_enqueue_script( 'jquery-iris', get_template_directory_uri() . '/inc/functions/metaboxes/js/iris.min.js', array( 'jquery' ), '', true );
	}
}
add_action('add_meta_boxes', 'automatic_add_page_metaboxes');
add_action('save_post', 'automatic_save_page_meta_option');
add_action('admin_enqueue_scripts', 'automatic_meta_page_assets' );

