<?php
require_once(automatic_functions . '/layout.php');
require_once(automatic_functions . '/ajax.php');
require_once(automatic_functions . '/metabox.php');
if (class_exists('Woocommerce')) {
    require_once(automatic_functions . '/woocommerce.php');
}
function automatic_check_theme_options() {
    // check default options
	global $automatic_settings;
		ob_start();
		if(is_file(automatic_plugins . '/importer/data_import/options_automatic.json')){
			include(automatic_plugins . '/importer/data_import/options_automatic.json');
			$options = ob_get_clean();
			$automatic_default_settings = json_decode($options, true);

			foreach ($automatic_default_settings as $key => $value) {
				if (is_array($value)) {
					foreach ($value as $key1 => $value1) {
						if (!isset($automatic_settings[$key][$key1]) || !$automatic_settings[$key][$key1]) {
							 $automatic_settings[$key][$key1] = $automatic_default_settings[$key][$key1];
					   }
					}
				 } else {
					if (!isset($automatic_settings[$key])) {
						$automatic_settings[$key] = $automatic_default_settings[$key];
					}
			   }
			}
    } 
	return $automatic_settings;
}
if(!class_exists('ReduxFramework')) {
     automatic_check_theme_options();
}
if (!isset($content_width)) {
    $content_width = 1140;
}
if (!function_exists('automatic_setup')) {
	function automatic_setup() {
		load_theme_textdomain('automatic', get_template_directory() . '/languages');
		add_editor_style(array('styles.css'));
		add_theme_support( 'post-formats', array(
				 'aside',  'image', 'video', 'audio', 'quote', 'link', 'gallery',
		) );
		add_theme_support('automatic-feed-links');
		register_nav_menu('primary', esc_html__('Primary Menu', 'automatic'));
		register_nav_menu( 'quickly', esc_html__( 'Quickly Menu', 'automatic' ) );

		add_theme_support( 'custom-header' );
		add_theme_support( 'custom-background' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support('woocommerce');
		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );
	}
}
add_action('after_setup_theme', 'automatic_setup');
//search filter
if ( !is_admin() ) {
    function automatic_searchfilter($query) {
			if ($query->is_search && !is_admin() && $query->get( 'post_type' ) != 'product') {
				$query->set('post_type',array('post'));
			}
			return $query;
    }
    add_filter('pre_get_posts','automatic_searchfilter');
}
function automatic_page_id(){
	if(is_page() || is_home() || (class_exists( 'WooCommerce' ) && is_shop())){
		if(is_page()){
			$post_id = get_the_ID();
		}elseif(is_home()){
			if(get_option('page_for_posts')){
				$post_id = get_option( 'page_for_posts');
			}else{
				return false;
			}
		}else{
			if(get_option( 'woocommerce_shop_page_id' ))
				$post_id = get_option( 'woocommerce_shop_page_id' );
			else return false;
		}
	}else{
		return false;
	}
	return $post_id;
}
function automatic_header_fixed(){
	$return ='';
	if(automatic_page_id()){
		$post_id = automatic_page_id();
		if(get_post_meta($post_id, 'header_fixed', true)){
			$return.= ' header_fixed';
		}
	}else{
		$automatic_config = automatic_settings();
		if(isset($automatic_config['header_fixed']) && $automatic_config['header_fixed'] == 'true') $return.= ' header_fixed';
	}
	return $return;
}
if ( class_exists( 'Automatic_Sublevel_Walker' ) ) {
	$menus = get_terms('nav_menu');
	if(count( $menus)>0){
		add_filter( 'wp_nav_menu_args' , 'automatic_menu_mega' );
		function automatic_menu_mega( $args ) {
			$args['walker'] = new Automatic_Sublevel_Walker;
			return $args;
		}
	}
}
function automatic_header_search(){
	$automatic_config = automatic_settings();
	if (!class_exists('Woocommerce')){
		if(get_option('seach_text')){
			$au_seach_text = get_option('seach_text');
		}elseif($automatic_config['seach_text'] !=''){
			$au_seach_text =$automatic_config['seach_text'];
		}else{
			$au_seach_text = esc_html__('Search ...','automatic');
		}
	?>
		<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
			<i class="automaticicon-search"></i>
			<input type="search" autocomplete="off" class="search-field search_default" placeholder="<?php echo $au_seach_text; ?>" value="" name="s" title="<?php esc_html_e('Enter your keywords','automatic')?>">
			<div class="search-submit">
				<button type="submit"><span><?php esc_html_e('Search','automatic')?></span></button>
			</div> 
		</form>
	<?php }else{
		$automatic_terms = get_terms( 'product_cat');
		if(get_option('seach_product_text')){
			$au_seach_product_text = get_option('seach_product_text');
		}elseif($automatic_config['seach_product_text'] !=''){
			$au_seach_product_text =$automatic_config['seach_product_text'];
		}else{
			$au_seach_product_text = esc_html__('Search for best deals ...','automatic');
		}
	?>
		<form role="search" method="get" class="woocommerce-product-search" action="<?php echo esc_url( home_url( '/' ) ); ?>">
			<i class="automaticicon-search"></i>
			<input type="search" autocomplete="off" id="woocommerce-product-search-field" class="search-field" placeholder="<?php echo $au_seach_product_text; ?>" value="" name="s" title="<?php esc_html_e('Enter your keywords','automatic')?>">
			<div class="search-submit">
			<?php
				if ( ! empty( $automatic_terms ) && ! is_wp_error( $automatic_terms ) ){
					echo '<div class="dropdown category_dropdown">';
					echo '<button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown"><span>'. esc_html__('All Categories','automatic').'</span><i class="fa fa-angle-down"></i></button>';
					echo '<ul class="dropdown-menu">';
						echo '<li class="animate-hover" data-val=all>' . esc_html__('All Categories','automatic') . '</li>';
						foreach ( $automatic_terms as $term ) {
							echo '<li class="animate-hover" data-val='. $term->slug .'>' . $term->name . '</li>';
						}
					echo '</ul>';
					echo '</div>';
				}
			?>
			<button type="submit"><span><?php esc_html_e('Search','automatic')?></span></button>
			</div>
			<input type="hidden" name="post_type" value="product">
			<input type="hidden" name="product_cat" value="">
			<div class="auto_ajax_search"></div>
		</form>
	<?php
	}
}
function automatic_layout_page() {
    if(is_page()){
        if(get_post_meta(get_the_ID(), 'page_fullwidth', true))
            return 'type2';
    }
    return 'type1';
}
function automatic_post_meta(){
    $automatic_config = automatic_settings();
    $comments = get_comments_number();
    if ( $comments == 0 ) {
        $comments = $comments.' '.esc_html__('Comment','automatic');
    }else{
        $comments = $comments.' '.esc_html__('Comments','automatic');
    }
    $archive_month = get_the_time('M');
    $archive_day   = get_the_time('d');
    $archive_year  = get_the_time('Y');
    $archive_month_1 = get_the_time('m');
    //format
    $format = get_post_format();
    $automatic_format = '';
    if ( current_theme_supports( 'post-formats', $format ) ) {
        if ( $format == 'link' ) {
            $class_format = 'fa fa-link';
        } else if ( $format == 'video' ){
            $class_format = 'fa fa-video-camera';
        } else if ( $format == 'audio' ) {
            $class_format = 'fa fa-volume-down';
        } else if ( $format == 'quote' ) {
            $class_format = 'fa fa-quote-left';
        }else if ( $format == 'gallery' ) {
            $class_format = 'fa fa-file-photo';
        }else if ( $format == 'aside' ) {
            $class_format = 'fa fa-file-text';
        }else if ( $format == 'image' ) {
            $class_format = 'fa fa-picture';
        }else{
            $class_format = 'standar';
        }
        $automatic_format = '<i class="'. esc_attr($class_format).'"></i><a class="" href="'. esc_url( get_post_format_link( $format ) ) .'">'. get_post_format_string( $format ) .'</a>';
    }
    // category
    $categories = get_the_category();
    $automatic_cat='';
    $i=1;
    if( ! empty( $categories ) ){
        $automatic_cat='<div class="inline"><i class="fa fa-folder-open"></i>';
        foreach ($categories as $category) {
            if ( $i > 1 ){
                $automatic_cat.=',  <a href="'. esc_url( get_category_link( $category->term_id ) ) .'">'. esc_html($category->name) .'</a>';
            }else{
                $automatic_cat.='<a href="'. esc_url( get_category_link( $category->term_id ) ) .'">'. esc_html($category->name) .'</a>';
            }
            $i++;
        }
        $automatic_cat.='</div>';
    }
    // tags
    $args_tag = get_the_tags();
    $automatic_tags = '';
    if($args_tag){
        $automatic_tags='<div class="inline"><i class="fa fa-tags"></i>';
        $i=1;
        foreach ($args_tag as $key => $value) {
            if ( $i > 1 ){
                $automatic_tags .= ',  <a href="'. get_tag_link($value->term_id) .'">'. esc_attr($value->name) .'</a>';
            }else{
                $automatic_tags .= '<a href="'. get_tag_link($value->term_id) .'">'. esc_attr($value->name) .'</a>';
            }
            $i++;
        }
        $automatic_tags .='</div>';
    }
?>
    <div class="postTitle">
        <div class="post-meta">
					<?php if ( is_sticky() && is_home() && ! is_paged() ) : ?>
						 <div class="inline"><i class="automaticicon-pin"></i><?php esc_html_e( 'Sticky', 'automatic' ); ?></div>
					<?php endif;
					if(!isset($automatic_config['meta_date']) || $automatic_config['meta_date']=='show'):?>
							<div class="inline"><a href="<?php echo get_month_link( $archive_year, $archive_month_1 ); ?> "><i class="icomoon-clock"></i><span><span class="month"><?php echo esc_html($archive_month); ?></span> <?php echo esc_html($archive_day); ?> <span class="year"><?php echo esc_html($archive_year); ?></span></span></a></div>
					<?php endif; ?>
					<?php if(!isset($automatic_config['meta_author']) || $automatic_config['meta_author']=='show'):?>
							<div class="inline"><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><i class="icomoon-user"></i><?php the_author();?></a></div>
					<?php endif; ?>
					<?php
					if(!isset($automatic_config['meta_comment']) || $automatic_config['meta_comment']=='show'):
							if(automatic_post_comment()){ ?>
									<div class="inline"><a href="<?php echo esc_url( get_permalink() ) . '#comments'; ?>" class="color_scheme_hover fw_normal"><i class="icomoon-bubble2"></i><?php echo ( $comments . ' '); ?>
									</a></div>
							<?php }
					 endif;
					if(!isset($automatic_config['meta_cat']) || $automatic_config['meta_cat']=='show') echo ($automatic_cat);
					if(!isset($automatic_config['meta_tag']) || $automatic_config['meta_tag']=='show') echo ($automatic_tags);
					if(!isset($automatic_config['meta_format']) || $automatic_config['meta_format']=='show') echo ($automatic_format);
					?>
        </div>
    </div>
<?php
}
function automatic_theme_comments( $comment, $args, $depth ) {
    $GLOBALS['comment'] = $comment;
    switch( $comment->comment_type ) :
        case 'pingback' :
        case 'trackback' : ?>
            <li <?php comment_class(); ?> id="comment<?php comment_ID(); ?>">
            <div class="back-link"><?php comment_author_link(); ?></div>
            </li>
        <?php break;
        default : ?>
            <li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
                <div class="post-author-box">
                    <div class="img-author">
                        <?php echo get_avatar( $comment, $args['avatar_size'] ); ?>
                    </div>
                    <div class="dsc-author">
                        <div class="info-author"><?php comment_text(); ?></div>
                        <div class="meta-comment">
                            <span class="name-author"><?php comment_author(); ?></span>
                            <div class="f_right">
                                <div class="date-comment" datetime="<?php comment_time( 'c' ); ?>"><?php comment_date('M d, Y');  ?></div>
                                <?php
                                    comment_reply_link( array_merge( $args, array(
                                        'reply_text' => '<span class="txt-over">'.esc_html('Reply','automatic').'</span>',
                                        'before' => '',
                                        'depth' => $depth,
                                    ) ) );
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </li>
        <?php // End the default styling of comment
        break;
    endswitch;
}
function content($limit) {
  $content = explode(' ', get_the_content(), $limit);
  if (count($content)>=$limit) {
    array_pop($content);
    $content = implode(" ",$content).'...';
  } else {
    $content = implode(" ",$content);
  }	
  $content = preg_replace('/\[.+\]/','', $content);
  $content = apply_filters('the_content', $content); 
  $content = str_replace(']]>', ']]&gt;', $content);
  return $content;
}