<?php

/**
 * Automatic Settings Options
 */
if (!class_exists('Framework_Automatic_Settings')) {

    class Framework_Automatic_Settings {

        public $ReduxFramework;

        public function __construct() {

            if (!class_exists('ReduxFramework')) {
                return;
            }

            // This is needed. Bah WordPress bugs.  ;)
            if (true == Redux_Helpers::isTheme(__FILE__)) {
                $this->initSettings();
            } else {
                add_action('plugins_loaded', array($this, 'initSettings'), 10);
            }
        }

        public function initSettings() {
            $this->ReduxFramework = new ReduxFramework($this->automatic_get_setting_sections(), $this->automatic_get_setting_arguments());
        }


        public function automatic_get_setting_sections() {
			global $automatic_social_array;
			$automatic_social_array=array(
				'facebook' 			=>'Facebook',
				'twitter' 			=>'Twitter',
				'google-plus' 		=>'Google Plus',
				'pinterest' 		=>'Pinterest',
				'instagram' 		=>'Instagram',
				'dribbble' 			=>'Dribbble',
				'flickr' 			=>'Flickr',
				'linkedin' 			=>'Linkedin',
				'behance' 			=>'Behance',
			);
			$automatic_social_share_array=array(
				'digg' 				=>'Digg',
				'facebook' 			=>'Facebook',
				'google-plus' 		=>'Google Plus',
				'linkedin' 			=>'Linkedin',
				'pinterest' 		=>'Pinterest',
				'reddit' 			=>'Reddit',
				'stumbleUpon' 		=>'StumbleUpon',
				'tumblr' 			=>'Tumblr',
				'twitter' 			=>'Twitter',
				'vk' 				=>'VK',
			);
			$header_option = array('header_1' => 'Header Layout 1','header_2' => 'Header Layout 2','header_3' => 'Header Layout 3');
			$footer_layout_option = array('footer_1' => 'Footer Layout 1','footer_2' => 'Footer Layout 2','footer_3' => 'Footer Layout 3');
			if ( class_exists('Automatic_import_demo') ){
				$sections[] = array(
					'icon' => 'el-icon-cog',
					'icon_class' => 'icon',
					'title' => esc_html__('Demo', 'automatic'),
					'fields' => array(
						array(
							'id'=>'import-demo',
							'type' => 'info',
							'title' => esc_html__('Import Demo', 'automatic'),
							'desc' => '<br/><strong>'.esc_html__('If import failed, please check your site and click "Import" again.', 'automatic') . '</strong>',
							'notice' => false
						),

						array(
							'id'        => 'import-demo-success',
							'type'      => 'raw',
							'content'   => (isset($_GET['import_options_success'])?'<strong>' . esc_html__('Successfully Imported!', 'automatic') . '</strong><br/><br/>':'').'<a href="#" id="btn_import" class="button button-primary">' . esc_html__('Import', 'automatic') . '</a>'
						),
					)
				);
			}
			$sections[] = array(
				'icon' => 'el-icon-dashboard',
				'icon_class' => 'icon',
				'title' => esc_html__('General', 'automatic'),
				'fields' => array(
					//-- Pre load
					array(
						'id'            => 'automatic_preload',
						'type'          => 'button_set',
						'title'         => esc_html__('Pre load', 'automatic'),
						'options'       => array(
							'show'  => esc_html__( 'Enable Preload', 'automatic' ),
							'hide'  => esc_html__( 'Disable Preload', 'automatic' ),
						),
						'default'       => 'show',
					),
					//-- Body background
					array(
						'id'            => 'basic_background_color',
						'type'          => 'color',
						'title'         => esc_html__('Background Color', 'automatic'),
						'description'   => esc_html__('Set background Color for body', 'automatic'),
						'default'       => '#ffffff',
						'validate' => 'color',
					),
					//-- Logo upload
					array(
						'id'            => 'logo_type',
						'type'          => 'button_set',
						'title'         => esc_html__('Logo', 'automatic'),
						'options'       => array(
							'logo_text'  => esc_html__( 'Logo Text', 'automatic' ),
							'logo_image'  => esc_html__( 'Logo Image', 'automatic' ),
						),
						'default'       => 'logo_image',
					),
					array(
						'id'            => 'logo_image',
						'type'          => 'media',
						'title'         => esc_html__( 'Logo', 'automatic' ),
						'description'   => esc_html__( 'Select an image file for your logo.', 'automatic' ),
						'default'       => array(
							'url' => get_template_directory_uri() . '/inc/admin/settings/images/logo.jpg'
						),
						'required'  =>  array('logo_type','=','logo_image')
					),
					array(
						'id'            => 'logo_image_mobile',
						'type'          => 'media',
						'title'         => esc_html__( 'Logo on mobile', 'automatic' ),
						'description'   => esc_html__( 'Select an image file for your logo.', 'automatic' ),
						'default'       => array(
							'url' => get_template_directory_uri() . '/inc/admin/settings/images/logo.png'
						),
						'required'  =>  array('logo_type','=','logo_image')
					),
					array(
						'id'            => 'logo_text',
						'type'          => 'text',
						'title'         => esc_html__( 'Logo', 'automatic' ),
						'description'   => esc_html__( 'Enter your logo', 'automatic' ),
						'default'       => esc_html('Automatic'),
						'required'  =>  array('logo_type','=','logo_text')
					),
					//-- Favicon upload
					array(
						'id'            => 'favicon_main',
						'type'          => 'media',
						'title'         => esc_html__( 'Favicon', 'automatic' ),
						'description'   => esc_html__( 'Specify a','automatic') .'<a href="'.esc_url('en.wikipedia.org/wiki/Favicon').'" target="_blank">'.esc_html__( ' favicon','automatic').'</a>'.esc_html__( ' for your site. Accepted formats: .ico, .png, .gif.', 'automatic' ),
						'default'       => array(
							'url' => get_template_directory_uri() . '/inc/admin/settings/images/favicon.ico'
						)
					),
					array(
						'id'            => 'automatic_address',
						'type'          => 'text',
						'title'         => esc_html__('Address','automatic'),
						'default'       => 'PO Box 16122 Collins Street, West  Victoria 8007, Australia',
					),
					array(
						'id'            => 'automatic_mail',
						'type'          => 'text',
						'title'         => esc_html__('Mail','automatic'),
						'default'       => 'info@automatic.com'
					),
					array(
						'id'            => 'automatic_phone',
						'type'          => 'text',
						'title'         => esc_html__('Phone','automatic'),
						'default'       => '&#40;+12&#41;123456789',
					),
					array(
						'id'            => 'mapapi',
						'type'          => 'text',
						'title'         => esc_html__('Map API ', 'automatic'),
						'description'   => esc_html__('Enter Map API', 'automatic') .'<a href="'.esc_url('developers.google.com/maps/documentation/javascript/get-api-key').'" target="_blank">'.esc_html__("Get API", "automatic").'</a> ',
						'default'       => 'AIzaSyBSeGIrNJAqHB4bQ8_YQgX4wFYBxXslvR4',
					),
					array(
						'id'=>'topbar_welcome',
						'type' => 'text',
						'title' => esc_html__('Welcome text', 'automatic'),
						'default' => 'Welcome you to International Electronic Store'
					),
					array(
						'id'=>'topbar_help',
						'type' => 'text',
						'title' => esc_html__('Help text', 'automatic'),
						'default' => 'Need Help? Call Us'
					),
					array(
						'id'            => 'menu_quickly_text',
						'type'          => 'text',
						'title'          => 'Quickly Menu Title',
						'default'					=> 'GO QUICKLY TO',
					),
					array(
						'id'       => 'topbar_location_link',
						'type'     => 'text',
						'title'    => esc_html__('Location link', 'automatic'),
						'validate' => 'url',
						'default'  => '#'
					),
					array(
						'id'       => 'topbar_location_text',
						'type'     => 'text',
						'title'    => esc_html__('Location text', 'automatic'),
						'validate' => 'no_html',
						'default'  => 'Store Location'
					),
					array(
						'id'       => 'topbar_shop_link',
						'type'     => 'text',
						'title'    => esc_html__('Shop link', 'automatic'),
						'validate' => 'url',
						'default'  => '#'
					),
					array(
						'id'       => 'topbar_shop_text',
						'type'     => 'text',
						'title'    => esc_html__('Shop text', 'automatic'),
						'validate' => 'no_html',
						'default'  => 'Shop'
					),
					array(
						'id'       => 'topbar_myaccount_link',
						'type'     => 'text',
						'title'    => esc_html__('My Account link', 'automatic'),
						'validate' => 'url',
						'default'  => '#'
					),
					array(
						'id'       => 'topbar_myaccount_text',
						'type'     => 'text',
						'title'    => esc_html__('My Account text', 'automatic'),
						'validate' => 'no_html',
						'default'  => 'My Account'
					),
					array(
						'id'       => 'seach_text',
						'type'     => 'text',
						'title'    => esc_html__('Seach Text', 'automatic'),
						'validate' => 'no_html',
						'default'  => 'Search ...'
					),
					array(
						'id'       => 'seach_product_text',
						'type'     => 'text',
						'title'    => esc_html__('Seach Product Text', 'automatic'),
						'validate' => 'no_html',
						'default'  => 'Search for best deals ...'
					),
					array(
						'id' => 'js-code',
						'type' => 'ace_editor',
						'title' => esc_html__('JS Code', 'automatic'),
						'subtitle' => esc_html__('Paste your JS code here.', 'automatic'),
						'mode' => 'javascript',
						'theme' => 'chrome',
						'default' => "jQuery(document).ready(function(){});"
					)
				)
			);
				/**
				 * 404 Page
				 */
			$sections[] = array(
				'title' => esc_html__('404 page','automatic'),
				'icon' 	=> 'el-icon-website',
				'fields'=> array(
					// Layout 1
					array(
						'id'            => '404_bg',
						'type'          => 'media',
						'title'         => esc_html__( 'Background for 404 page', 'automatic' ),
						'description'   => esc_html__( 'Select an image file for 404 page background image', 'automatic' ),
						'default'       => array(
							'url' => get_template_directory_uri() . '/inc/admin/settings/images/bg-404.jpg'
						),
					),
					array(
						'id'            => '404_title',
						'type'          => 'text',
						'title'         => esc_html__( 'Title for 404 page', 'automatic' ),
						'description'   => esc_html__( 'Enter 404 title here', 'automatic' ),
					),
					array(
						'id'            => '404_txt',
						'type'          => 'textarea',
						'title'         => esc_html__( 'Content for 404 page', 'automatic' ),
						'description'   => esc_html__( 'Enter 404 content here', 'automatic' )
					),
					array(
						'id'            => 'footer_404',
						'type'          => 'select',
						'title'         => esc_html__( 'Footer layout 404', 'automatic' ),
						'subtitle'   	=> esc_html__( 'Select layout footer 404', 'automatic' ),
						'data'			=> 'footer_404-1',
						'options'       => array(
							'footer_0' => esc_html__( 'Footer Default', 'automatic' ),
							'footer_1' => esc_html__( 'Footer Layout 1', 'automatic' ),
							'footer_2' => esc_html__( 'Footer Layout 2', 'automatic' ),
						),
						'default'		=> 'footer_0',

					),
				)
			);
				/**
				 * SOCIAL NETWORK
				 */
			$automatic_arg_socials = array();
			foreach($automatic_social_array as $key => $value){
				$automatic_arg_social=array(array(
										'id'            => 'social_'.$key.'_link',
										'type'          => 'text',
										'title'         => $value,
										'default'       => '#',
									));
				$automatic_arg_socials = array_merge($automatic_arg_socials,$automatic_arg_social);
			}
			$sections[] = array(
				'title'     => esc_html__( 'Social Networks', 'automatic' ),
				'icon'      => 'el-icon-share',
				'fields'    => $automatic_arg_socials
			);
			/**
			 * STYLE OPTION
			 */
            $sections[] = array(
				'icon' => 'el-icon-css',
				'icon_class' => 'icon',
				'title' => esc_html__('Skin', 'automatic'),
				'fields' => array(
					array(
						'id' => 'main_color',
						'type' => 'color',
						'title' => esc_html__('Main Color', 'automatic'),
						'transparent'	=> false,
						'description'   => esc_html__('Set color for main theme', 'automatic'),
						'default'       => '#34b3fb',
					),
					array(
						'id'            => 'primary_font',
						'type'          => 'typography',
						'title'         => esc_html__( 'Primary font', 'automatic' ),
						'description'   => esc_html__( 'Specify the body font properties.', 'automatic' ),
						'font-backup'   => true,
						'all_styles'    => true,
						'text-align'    => false,
						'default'       => array(
							'subsets'		=>'latin',
							'font-family'   => 'Lato',
							'font-backup'   => 'Arial, Helvetica, sans-serif',
							'font-weight'   => '400',
							'font-size'     => '16px',
							'line-height'	=> '26px',
							'color'         => '#666',
						),
					),
					array(
						'id' => 'link_color',
						'type' => 'color',
						'title' => esc_html__('Link Color', 'automatic'),
						'transparent'	=> false,
						'description'   => esc_html__('Set color for tag <a></a> theme', 'automatic'),
						'default'       => '#34b3fb',
					),
				)
			);
			$sections[] = array(
				'icon_class' => 'icon',
				'subsection' => true,
				'title' => esc_html__('Custom', 'automatic'),
				'fields' => array(
					array(
						'id'=>'custom-css-code',
						'type' => 'ace_editor',
						'title' => esc_html__('CSS', 'automatic'),
						'subtitle' => esc_html__('Enter CSS code here.', 'automatic'),
						'mode' => 'css',
						'theme' => 'monokai',
						'default' => ""
					),
				)
			);
			$header_fields=array(
				array(
					'id'            => 'header_selected',
					'type'          => 'select',
					'title'         => esc_html__( 'Select Header', 'automatic' ),
					'subtitle'   	=> esc_html__( 'Select header to default', 'automatic' ),
					'options'		=> $header_option,
					'default'		=> 'header_1',
				),
			);
			$i=0;
			foreach($header_option as $value){
				$i++;
				$header_fields[]= array(
						'id'            => 'header_'.$i.'_img',
						'type'          => 'image_select',
						'title'         => esc_html__( 'Header', 'automatic' ),
						'options'       => array(
							'header_layout_'.$i.'' => get_template_directory_uri() . '/inc/admin/settings/images/header-'.$i.'.jpg'
						),
						'default'       => 'header_layout_'.$i.'',
						'required'      => array(
							array( 'header_selected', '=', 'header_'.$i.'' )
						),
					);
			}
			$sections[] = array(
				'title'         => esc_html__( 'Header', 'automatic' ),
				'fields' =>  $header_fields
			);
		/*
		*	header layout 1
		*/
			$automatic_arg_header1 = array(
				array(
					'id'            => 'header_1_img_option',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Header 1', 'automatic' ),
					'options'       => array(
						'header_1' => get_template_directory_uri() . '/inc/admin/settings/images/header-1.jpg'
					),
					'default'       => 'header_1',
				),
				array(
					'id'            => 'header_1_topbar_show',
					'type'          => 'button_set',
					'class'          => 'option_child',
					'title'          => 'Top bar',
					'options'       => array(
						'show' => esc_html__( 'Show Top bar', 'automatic' ),
						'hide' => esc_html__( 'Hide Top bar', 'automatic' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_1_topbar_left',
					'type'          => 'button_set',
					'class'          => 'option_child',
					'options'       => array(
						'show welcome' => esc_html__( 'Show Welcome', 'automatic' ),
						'show help' => esc_html__( 'Show Help', 'automatic' ),
						'hidden' => esc_html__( 'Hidden', 'automatic' ),
					),
					'default'		=> 'show welcome',
					'required'      => array(
						array( 'header_1_topbar_show', '=', 'show' )
					)
				),
				array(
					'id'            => 'header_1_topbar_location',
					'type'          => 'button_set',
					'class'          => 'option_child',
					'options'       => array(
						'show' => esc_html__( 'Show Location', 'automatic' ),
						'hidden' => esc_html__( 'Hidden Location', 'automatic' ),
					),
					'default'		=> 'show',
					'required'      => array(
						array( 'header_1_topbar_show', '=', 'show' )
					)
				),
				array(
					'id'            => 'header_1_topbar_shop',
					'type'          => 'button_set',
					'class'          => 'option_child',
					'options'       => array(
						'show' => esc_html__( 'Show Shop', 'automatic' ),
						'hidden' => esc_html__( 'Hidden Shop', 'automatic' ),
					),
					'default'		=> 'show',
					'required'      => array(
						array( 'header_1_topbar_show', '=', 'show' )
					)
				),
				array(
					'id'            => 'header_1_topbar_myaccount',
					'type'          => 'button_set',
					'options'       => array(
						'show' => esc_html__( 'Show My account', 'automatic' ),
						'hidden' => esc_html__( 'Hidden My account', 'automatic' ),
					),
					'default'		=> 'show',
					'required'      => array(
						array( 'header_1_topbar_show', '=', 'show' )
					)
				),
				array(
					'id'            => 'header_1_stick1_show',
					'type'          => 'button_set',
					'title'          => 'Stick 1',
					'class'          => 'option_child',
					'options'       => array(
						'show' => esc_html__( 'Show Stick 1', 'automatic' ),
						'hidden' => esc_html__( 'Hidden Stick 1', 'automatic' ),
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_1_stick1',
					'type'          => 'text',
					'default'		=> 'Free shipping on Orders over $100',
					'required'      => array(
						array( 'header_1_stick1_show', '=', 'show' )
					)
				),
				array(
					'id'            => 'header_1_stick2_show',
					'type'          => 'button_set',
					'title'          => 'Stick 2',
					'class'          => 'option_child',
					'options'       => array(
						'show' => esc_html__( 'Show Stick 2', 'automatic' ),
						'hidden' => esc_html__( 'Hidden Stick 2', 'automatic' ),
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_1_stick2',
					'type'          => 'text',
					'default'		=> '20% Members discount on Monday',
					'required'      => array(
						array( 'header_1_stick2_show', '=', 'show' )
					)
				),
				array(
					'id'            => 'header_1_menu_department_text',
					'type'          => 'text',
					'title'          => 'Departments option',
					'class'          => 'option_child',
					'default'		=> 'Departments',
				),
				array(
					'id'            => 'header_1_menu_department',
					'type'          => 'select',
					'default'		=> 11,
					'data'		=> 'menus',
				),
				array(
					'id'            => 'header_1_menu',
					'type'          => 'select',
					'default'		=> 26,
					'data'		=> 'menus',
				),

			);
			$sections[] = array(
				'title'         => esc_html__( 'Header 1', 'automatic' ),
				'subsection'    => true,
				'fields'        => $automatic_arg_header1
			);
		/*
		*	header layout 2
		*/
			$automatic_arg_header2 = array(
				array(
					'id'            => 'header_2_img_option',
					'type'          => 'image_select',
					'options'       => array(
						'header_2' => get_template_directory_uri() . '/inc/admin/settings/images/header-2.jpg'
					),
					'default'       => 'header_2',
				),
				 array(
					'id'            => 'header_2_topbar_show',
					'type'          => 'button_set',
					'class'          => 'option_child',
					'title'          => 'Top bar',
					'options'       => array(
						'show' => esc_html__( 'Show Top bar', 'automatic' ),
						'hide' => esc_html__( 'Hide Top bar', 'automatic' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_2_topbar_left',
					'type'          => 'button_set',
					'class'          => 'option_child',
					'options'       => array(
						'show welcome' => esc_html__( 'Show Welcome', 'automatic' ),
						'show help' => esc_html__( 'Show Help', 'automatic' ),
						'hidden' => esc_html__( 'Hidden', 'automatic' ),
					),
					'default'		=> 'show help',
					'required'      => array(
						array( 'header_2_topbar_show', '=', 'show' )
					)
				),
				array(
					'id'            => 'header_2_topbar_location',
					'type'          => 'button_set',
					'class'          => 'option_child',
					'options'       => array(
						'show' => esc_html__( 'Show Location', 'automatic' ),
						'hidden' => esc_html__( 'Hidden Location', 'automatic' ),
					),
					'default'		=> 'show',
					'required'      => array(
						array( 'header_2_topbar_show', '=', 'show' )
					)
				),
				array(
					'id'            => 'header_2_topbar_shop',
					'type'          => 'button_set',
					'class'          => 'option_child',
					'options'       => array(
						'show' => esc_html__( 'Show Shop', 'automatic' ),
						'hidden' => esc_html__( 'Hidden Shop', 'automatic' ),
					),
					'default'		=> 'show',
					'required'      => array(
						array( 'header_2_topbar_show', '=', 'show' )
					)
				),
				array(
					'id'            => 'header_2_topbar_myaccount',
					'type'          => 'button_set',
					'options'       => array(
						'show' => esc_html__( 'Show My account', 'automatic' ),
						'hidden' => esc_html__( 'Hidden My account', 'automatic' ),
					),
					'default'		=> 'show',
					'required'      => array(
						array( 'header_2_topbar_show', '=', 'show' )
					)
				),
				array(
					'id'            => 'header_2_topbar_minicart',
					'type'          => 'button_set',
					'options'       => array(
						'show' => esc_html__( 'Show Mini cart', 'automatic' ),
						'hidden' => esc_html__( 'Hidden Mini cart', 'automatic' ),
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_2_menu',
					'title'          => 'Main Menu',
					'type'          => 'select',
					'default'		=> 52,
					'data'		=> 'menus',
				),
				array(
					'id'            => 'header_2_menu_department_text',
					'type'          => 'text',
					'title'          => 'Departments option',
					'class'          => 'option_child',
					'default'		=> 'Browse Departments',
				),
				array(
					'id'            => 'header_2_menu_department',
					'type'          => 'select',
					'default'		=> 11,
					'data'		=> 'menus',
				),
				array(
					'id'            => 'header_2_menu_quickly',
					'type'          => 'button_set',
					'title'          => 'Quickly',
					'options'       => array(
						'show' => esc_html__( 'Show Quickly Menu', 'automatic' ),
						'hidden' => esc_html__( 'Hidden Quickly Menu', 'automatic' ),
					),
					'default'		=> 'show',
				),
			);
			$sections[] = array(
				'title'         => esc_html__( 'Header 2', 'automatic' ),
				'subsection'    => true,
				'fields'        => $automatic_arg_header2
			);
		/* <-- end header layout 2 */
		/*
		*	header layout 3
		*/
			$automatic_arg_header3 = array(
				array(
					'id'            => 'header_3_img_option',
					'type'          => 'image_select',
					'options'       => array(
						'header_3' => get_template_directory_uri() . '/inc/admin/settings/images/header-3.jpg'
					),
					'default'       => 'header_3',
				),
				 array(
					'id'            => 'header_3_topbar_show',
					'type'          => 'button_set',
					'class'          => 'option_child',
					'title'          => 'Top bar',
					'options'       => array(
						'show' => esc_html__( 'Show Top bar', 'automatic' ),
						'hide' => esc_html__( 'Hide Top bar', 'automatic' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_3_topbar_left',
					'type'          => 'button_set',
					'class'          => 'option_child',
					'options'       => array(
						'show welcome' => esc_html__( 'Show Welcome', 'automatic' ),
						'show help' => esc_html__( 'Show Help', 'automatic' ),
						'hidden' => esc_html__( 'Hidden', 'automatic' ),
					),
					'default'		=> 'show help',
					'required'      => array(
						array( 'header_3_topbar_show', '=', 'show' )
					)
				),
				array(
					'id'            => 'header_3_topbar_location',
					'type'          => 'button_set',
					'class'          => 'option_child',
					'options'       => array(
						'show' => esc_html__( 'Show Location', 'automatic' ),
						'hidden' => esc_html__( 'Hidden Location', 'automatic' ),
					),
					'default'		=> 'show',
					'required'      => array(
						array( 'header_3_topbar_show', '=', 'show' )
					)
				),
				array(
					'id'            => 'header_3_topbar_shop',
					'type'          => 'button_set',
					'class'          => 'option_child',
					'options'       => array(
						'show' => esc_html__( 'Show Shop', 'automatic' ),
						'hidden' => esc_html__( 'Hidden Shop', 'automatic' ),
					),
					'default'		=> 'show',
					'required'      => array(
						array( 'header_3_topbar_show', '=', 'show' )
					)
				),
				array(
					'id'            => 'header_3_topbar_myaccount',
					'type'          => 'button_set',
					'options'       => array(
						'show' => esc_html__( 'Show My account', 'automatic' ),
						'hidden' => esc_html__( 'Hidden My account', 'automatic' ),
					),
					'default'		=> 'show',
					'required'      => array(
						array( 'header_3_topbar_show', '=', 'show' )
					)
				),
				array(
					'id'            => 'header_3_topbar_minicart',
					'type'          => 'button_set',
					'options'       => array(
						'show' => esc_html__( 'Show Mini cart', 'automatic' ),
						'hidden' => esc_html__( 'Hidden Mini cart', 'automatic' ),
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_3_menu_department_text',
					'type'          => 'text',
					'title'          => 'Departments option',
					'class'          => 'option_child',
					'default'		=> 'Departments',
				),
				array(
					'id'            => 'header_3_menu_department',
					'type'          => 'select',
					'default'		=> 11,
					'data'		=> 'menus',
				),
			);

			$sections[] = array(
				'title'         => esc_html__( 'Header 3', 'automatic' ),
				'subsection'    => true,
				'fields'        => $automatic_arg_header3
			);
		/* <-- end header layout 3 */

		/**
		* FOOTER SETTINGS
		*/
			$footer_fields=array(
				array(
					'id'            => 'footer_selected',
					'type'          => 'select',
					'title'         => esc_html__( 'Select Footer', 'automatic' ),
					'subtitle'   	=> esc_html__( 'Select Footer to default', 'automatic' ),
					'options'		=> $footer_layout_option,
					'default'		=> 'footer_1',
				)
			);
			$i=0;
			foreach($footer_layout_option as $value){
				$i++;
				$footer_fields[]= array(
						'id'            => 'footer_'.$i.'_img',
						'type'          => 'image_select',
						'title'         => esc_html__( 'Footer', 'automatic' ),
						'options'       => array(
							'footer_layout_'.$i.'' => get_template_directory_uri() . '/inc/admin/settings/images/footer-'.$i.'.jpg'
						),
						'default'       => 'footer_layout_'.$i.'',
						'required'      => array(
							array( 'footer_selected', '=', 'footer_'.$i.'' )
						),
					);
			}
			$sections[] = array(
				'title'         => esc_html__( 'Footer', 'automatic' ),
				'fields' =>  $footer_fields
			);
			$automatic_arg_footer1 = array(
				array(
					'id'            => 'footer_layout_1_img',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Footer Layout', 'automatic' ),
					'options'       => array(
						'footer_layout_1_img' => get_template_directory_uri() . '/inc/admin/settings/images/footer-1.jpg'
					),
					'default'		=> 'footer_layout_1_img', 
				),
				array(
					'id'            => 'footer_1_top',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer Top', 'automatic' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer Top', 'automatic' ),
						'hide' => esc_html__( 'Hide Footer Top', 'automatic' )
					),
					'default'		=> 'show', 
				),
				array(
					'id'            => 'footer_1_center',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer center', 'automatic' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer center', 'automatic' ),
						'hide' => esc_html__( 'Hide Footer center', 'automatic' )
					),
					'default'		=> 'show', 
				),
				array(
					'id'            => 'footer_1_bottom',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer Bottom', 'automatic' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer Bottom', 'automatic' ),
						'hide' => esc_html__( 'Hide Footer Bottom', 'automatic' )
					),
					'default'		=> 'show', 
				),
			);
			$sections[] = array(
				'title'         => esc_html__( 'Footer 1', 'automatic' ),
				'subsection'    => true,
				'fields'        => $automatic_arg_footer1
			);
			// Footer 2
			$automatic_arg_footer2 = array(
				array(
					'id'            => 'footer_layout_2_img',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Footer Layout', 'automatic' ),
					'options'       => array(
						'footer_layout_2_img' => get_template_directory_uri() . '/inc/admin/settings/images/footer-2.jpg'
					),
					'default'		=> 'footer_layout_2_img', 
				),
				array(
					'id'            => 'footer_2_top',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer Top', 'automatic' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer Top', 'automatic' ),
						'hide' => esc_html__( 'Hide Footer Top', 'automatic' )
					),
					'default'		=> 'hide', 
				),
				array(
					'id'            => 'footer_2_center',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer center', 'automatic' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer center', 'automatic' ),
						'hide' => esc_html__( 'Hide Footer center', 'automatic' )
					),
					'default'		=> 'hide', 
				),
				array(
					'id'            => 'footer_2_bottom',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer Bottom', 'automatic' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer Bottom', 'automatic' ),
						'hide' => esc_html__( 'Hide Footer Bottom', 'automatic' )
					),
					'default'		=> 'show', 
				),
			); 
			$sections[] = array(
				'title'         => esc_html__( 'Footer 2', 'automatic' ),
				'subsection'    => true,
				'fields'        => $automatic_arg_footer2
			);
			/*Footer default*/
			$automatic_arg_footer3 = array(
				array(
					'id'            => 'footer_layout_3_img',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Footer Layout', 'automatic' ),
					'options'       => array(
						'footer_layout_3_img' => get_template_directory_uri() . '/inc/admin/settings/images/footer-3.jpg'
					),
					'default'		=> 'footer_layout_3_img', 
				),
				array(
					'id'            => 'footer_3_center',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer center', 'automatic' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer center', 'automatic' ),
						'hide' => esc_html__( 'Hide Footer center', 'automatic' )
					),
					'default'		=> 'show', 
				),
				array(
					'id'            => 'footer_3_bottom',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer Bottom', 'automatic' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer Bottom', 'automatic' ),
						'hide' => esc_html__( 'Hide Footer Bottom', 'automatic' )
					),
					'default'		=> 'show',
				),
			);
			$sections[] = array(
				'title'         => esc_html__( 'Footer 3', 'automatic' ),
				'subsection'    => true,
				'fields'        => $automatic_arg_footer3
			);
			
			$sections[] = array(
				'title'         => esc_html__( 'Copy Right', 'automatic' ),
				'subsection'    => true,
				'fields'        => array(
						array(
							'id'            => 'footer_coppyright',
							'type'          => 'textarea',
							'title'         => esc_html__( 'Text copyright', 'automatic' ),
							'description'   => esc_html__( 'Enter text content here', 'automatic' ),
							'default'		=> wp_kses_post(__( 'MADE BY <a href="#">THEMESUN</a> &#169; 2017. ALL RIGHTS RESERVED', 'automatic' )),
						),
				)
			);
			$sections[] = array(
				'title'         => esc_html__( 'Logo Bank', 'automatic' ),
				'subsection'    => true,
				'fields'        => array( 
						array(
							'id'            => 'footer_bank',
							'type'          => 'editor',
							'title'         => esc_html__( 'Footer Bank', 'automatic' ),
							'description'   => esc_html__( 'Enter content here', 'automatic' ),
						),
				)
			);
		/*
		*	Page option
		*/
			$sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'icon',
				'title' => esc_html__('Page', 'automatic'),
				'fields' => array(
					array(
						'id'            => 'page_sidebar_position',
						'type'          => 'select',
						'title' 				=> esc_html__('Sidebar', 'automatic'),
						'description'   => esc_html__('Select layout type', 'automatic'),
						'options'          => array(
							'no-sidebar' => esc_html('No sidebar','automatic'),
							'left-sidebar' => esc_html('Left sidebar','automatic'),
							'right-sidebar' => esc_html('Right sidebar','automatic'),
						),
						'default'	=>'no-sidebar',
					),
					array(
						'id'            => 'page_bread_crumb',
						'type'          => 'select',
						'title' 				=> esc_html__('BreadCrumb', 'automatic'),
						'description'   => esc_html__('Select show Breadcrumb', 'automatic'),
						'options'          => array(
							'show' => esc_html('Show breadcrumb','automatic'),
							'hide' => esc_html('Hide breadcrumb','automatic'), 
						),
						'default'	=>'show',
					),
					array(
						'id'            => 'page_title',
						'type'          => 'select',
						'title' 				=> esc_html__('Page Title', 'automatic'),
						'description'   => esc_html__('Select show title', 'automatic'),
						'options'          => array(
							'show' => esc_html('Show Title','automatic'),
							'hide' => esc_html('Hide Title','automatic'), 
						),
						'default'	=>'hide',
					),
					array(
						'id'            => 'page_sidebar_ct',
						'type'          => 'select',
						'description'   => esc_html__('Select layout type', 'automatic'),
						'data'			=> 'sidebar',
						'required'      => array(
							array( 'page_sidebar_position', '!=', 'no-sidebar' ),
						),
					),
				)
			);

            $sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'icon',
				'title' => esc_html__('Blog & Single Post', 'automatic'),
				'fields' => array(
					array(
					'id'=>'blog-title',
					'type' => 'text',
					'title' => esc_html__('Page Title', 'automatic'),
					'default' => 'Blog'
					), 
					array(
						'id'            => 'post_sidebar_position',
						'type'          => 'button_set',
						'title'         => esc_html__( 'Sidebar Position', 'automatic' ),
						'subtitle'   	=> esc_html__( 'Position Sidebar to Blog & Single Post', 'automatic' ),
						'options'       => array(
							'left-sidebar' => esc_html__( 'Left', 'automatic' ),
							'right-sidebar' => esc_html__( 'Right', 'automatic' ),
							'none' => esc_html__( 'None', 'automatic' ),
						),
						'default'		=> 'left-sidebar',
					),
					array(
						'id'            => 'post_sidebar',
						'type'          => 'select',
						'title'         => esc_html__( 'Sidebar', 'automatic' ),
						'subtitle'   	=> esc_html__( 'Select Sidebar to Blog & Single Post', 'automatic' ),
						'data'			=> 'sidebar',
						'default'		=> 'blog-sidebar',
						'required'      => array(
							array( 'post_sidebar_position', '!=', 'none' )
						),
					),
					//archive
					array(
						'id'            => 'archive_blog_banner',
						'type'          => 'button_set',
						'title'         => esc_html__('Breadcrumb', 'automatic' ),
						'options'       => array(
							'show' => esc_html__( 'Show Breadcrumb', 'automatic' ),
							'hide' => esc_html__( 'Hide Breadcrumb', 'automatic' ),
						),
						'default'       => 'show',

					),
					array(
						'id'       => 'post_social_share',
						'type'     => 'select',
						'multi'    => true,
						'title'         => esc_html__('Social Share Post', 'automatic' ),
						'desc'     => esc_html__('Select Social Share', 'automatic'),
						'options'  =>$automatic_social_share_array,
						'default'  => array('facebook','twitter','pinterest'),
						'sortable'    => true
					),
					array(
						'id'            => 'footer_blog',
						'type'          => 'select',
						'title'         => esc_html__( 'Footer Blog Page', 'automatic' ),
						'subtitle'   	=> esc_html__( '', 'automatic' ),
						'data'			=> 'footer_blog-1',
						'options'       => array(
							'footer_1' => esc_html__( 'Footer Layout 1', 'automatic' ),
							'footer_2' => esc_html__( 'Footer Layout 2', 'automatic' ),
							'footer_3' => esc_html__( 'Footer Layout 3', 'automatic' ),
						),
						'default'		=> 'footer_1',

					),
				)
			);
			if ( class_exists( 'WooCommerce' ) ):
				$compare_fields=array();
				if(class_exists( 'YITH_WOOCOMPARE' ) ) {
					$compare_fields[] = array(
							'id'            => 'automatic_compare_page',
							'type'          => 'select',
							'title'         => esc_html__( 'Compare ', 'automatic' ),
							'subtitle'   	=> esc_html__( 'Select page to Compare page', 'automatic' ),
							'data'			=> 'pages',
							'default'		=> '1036', 
						);
				} 
				$sections[] = array(
					'icon' => 'el-icon-file',
					'icon_class' => 'icon',
					'title' => esc_html__('WooCommerce', 'automatic'),
					'fields' => $compare_fields
				);
				$sections[] = array(
					'icon_class' => 'icon',
					'subsection' => true,
					'title' => esc_html__('Product Categories', 'automatic'),
					'fields' => array(
						array(
							'id'=>'product_categories',
							'type' => 'info',
							'title' => esc_html__('Product Categories', 'automatic'),
							'desc' => '<br/><strong>'.esc_html__('Set up for &ldquo;Product Categories&ldquo;', 'automatic') . '</strong>',
							'notice' => false
						),
						array(
							'id'            => 'archive_product_breadcrumb',
							'type'          => 'button_set',
							'title'         => esc_html__('Shop Breadcrumb', 'automatic' ),
							'options'       => array(
								'show' => esc_html__( 'Show breadcrumb', 'automatic' ),
								'hide' => esc_html__( 'Hide breadcrumb', 'automatic' ),
							),
							'default'       => 'show',
						),
						array(
							'id'            => 'shop_layout',
							'type'          => 'select',
							'title'         => esc_html__( 'Layout', 'automatic' ),
							'subtitle'   	=> esc_html__( 'Select layout shop', 'automatic' ),
							'data'			=> 'layout-1',
							'options'       => array(
								'grid' => esc_html__( 'Grid', 'automatic' ),
								'list' => esc_html__( 'List', 'automatic' ),
							),
							'default'		=> 'grid',

						),
						array(
							'id'            => 'column_subcat',
							'type'          => 'select',
							'title'         => esc_html__( 'Column for sub categories', 'automatic' ),
							'subtitle'   	=> esc_html__( 'Select Column layout sub category on category product page. ', 'automatic' ),
							'data'			=> 'column_subcat-1',
							'options'       => array(
								'2' => esc_html__( '2 Column', 'automatic' ),
								'3' => esc_html__( '3 Column', 'automatic' ),
								'4' => esc_html__( '4 Column', 'automatic' ),
								'5' => esc_html__( '5 Column', 'automatic' ),
							),
							'default'		=> '3',

						),
						array(
							'id'            => 'product_categories_sidebar',
							'type'          => 'select',
							'title'         => esc_html__( 'Sidebar', 'automatic' ),
							'subtitle'   	=> esc_html__( 'Select Sidebar to Product Categories', 'automatic' ),
							'data'			=> 'sidebar',
							'default'		=> 'shop-sidebar',
							'required'      => array(
								array( 'product_categories_sidebar_position', '!=', 'none' )
							),
						),
						array(
							'id'            => 'product_categories_sidebar_position',
							'type'          => 'select',
							'title'         => esc_html__('Sidebar Position', 'automatic' ),
							'options'          => array(
								'no-sidebar' => esc_html('No sidebar','automatic'),
								'left-sidebar' => esc_html('Left sidebar','automatic'),
								'right-sidebar' => esc_html('Right sidebar','automatic'),
							),
							'default'	=>'no-sidebar',
						),
						array(
							'id'            => 'column',
							'type'          => 'select',
							'title'         => esc_html__( 'Column', 'automatic' ),
							'subtitle'   	=> esc_html__( 'Select Column to Product Categories', 'automatic' ),
							'data'			=> 'column-1',
							'options'       => array(
								'2' => esc_html__( '2 Column', 'automatic' ),
								'3' => esc_html__( '3 Column', 'automatic' ),
								'4' => esc_html__( '4 Column', 'automatic' ),
								'5' => esc_html__( '5 Column', 'automatic' ),
							),
							'default'		=> '3',

						),
						array(
							'id'            => 'archive_product_num_item_2',
							'type'          => 'spinner',
							'title'         => esc_html__('Number items', 'automatic' ),
							'subtitle'   	=> esc_html__( 'Numbers item product show on shop', 'automatic' ),
							'default'  => '10',
							'min'      => '4',
							'step'     => '1',
							'max'      => '50',
							'required'      => array(
								array( 'column', '=', '2' ),
							),
						),
						array(
							'id'            => 'archive_product_num_item_3',
							'type'          => 'spinner',
							'title'         => esc_html__('Number items', 'automatic' ),
							'subtitle'   	=> esc_html__( 'Numbers item product show on shop', 'automatic' ),
							'default'  => '18',
							'min'      => '6',
							'step'     => '1',
							'max'      => '50',
							'required'      => array(
								array( 'column', '=', '3' ),
							),
						),
						array(
							'id'            => 'archive_product_num_item_4',
							'type'          => 'spinner',
							'title'         => esc_html__('Number items', 'automatic' ),
							'subtitle'   	=> esc_html__( 'Numbers item product show on shop', 'automatic' ),
							'default'  => '12',
							'min'      => '8',
							'step'     => '1',
							'max'      => '50',
							'required'      => array(
								array( 'column', '=', '4' ),
							),
						),
						array(
							'id'            => 'archive_product_num_item_5',
							'type'          => 'spinner',
							'title'         => esc_html__('Number items', 'automatic' ),
							'subtitle'   	=> esc_html__( 'Numbers item product show on shop', 'automatic' ),
							'default'  => '15',
							'min'      => '10',
							'step'     => '1',
							'max'      => '50',
							'required'      => array(
								array( 'column', '=', '5' ),
							),
						),
						array(
							'id'            => 'archive_product_trending',
							'type'          => 'button_set',
							'title'         => esc_html__('Show Trending Product(s)', 'automatic' ),
							'options'       => array(
								'show' => esc_html__( 'Show', 'automatic' ),
								'hide' => esc_html__( 'Hide', 'automatic' ),
							),
							'default'       => 'hide',

						),
						array(
							'id'            => 'footer_category',
							'type'          => 'select',
							'title'         => esc_html__( 'Footer layout Categories', 'automatic' ),
							'subtitle'   	=> esc_html__( 'Select layout footer categories', 'automatic' ),
							'data'			=> 'footer_category-1',
							'options'       => array(
								'footer_1' => esc_html__( 'Footer Layout 1', 'automatic' ),
								'footer_2' => esc_html__( 'Footer Layout 2', 'automatic' ),
								'footer_3' => esc_html__( 'Footer Layout 3', 'automatic' ),
							),
							'default'		=> 'footer_1',

						),
					)
				);

				// Single Product
				$sections[] = array(
					'icon_class' => 'icon',
					'subsection' => true,
					'title' => esc_html__('Product Single', 'automatic'),
					'fields' => array(
						array(
							'id'=>'product_single',
							'type' => 'info',
							'title' => esc_html__('Product Single', 'automatic'),
							'desc' => '<br/><strong>'.esc_html__('Set up for &ldquo;Product Single&ldquo;', 'automatic') . '</strong>',
							'notice' => false
						),
						array(
							'id'            => 'single_product_breadcrumb',
							'type'          => 'button_set',
							'title'         => esc_html__('Single Page Breadcrumb', 'automatic' ),
							'options'       => array(
								'show' => esc_html__( 'Show breadcrumb', 'automatic' ),
								'hide' => esc_html__( 'Hide breadcrumb', 'automatic' ),
							),
							'default'       => 'show',

						),
						array(
							'id'            => 'product_single_sidebar_position',
							'type'          => 'button_set',
							'title'         => esc_html__( 'Sidebar Position', 'automatic' ),
							'subtitle'   	=> esc_html__( 'Position Sidebar to Product Single', 'automatic' ),
							'options'       => array(
								'left-sidebar' => esc_html__( 'Left', 'automatic' ),
								'right-sidebar' => esc_html__( 'Right', 'automatic' ),
								'none' => esc_html__( 'None', 'automatic' ),
							),
							'default'		=> 'left-sidebar',
						),
						array(
							'id'            => 'product_single_sidebar',
							'type'          => 'select',
							'title'         => esc_html__( 'Sidebar', 'automatic' ),
							'subtitle'   	=> esc_html__( 'Select Sidebar to Product Single', 'automatic' ),
							'data'			=> 'sidebar',
							'default'		=> 'single-product-sidebar',
							'required'      => array(
								array( 'product_single_sidebar_position', '!=', 'none' )
							),
						),
					),
				);


			endif; // end of if ( class_exists( 'WooCommerce' ) )
            return $sections;
        }


        public function automatic_get_setting_arguments() {
            $theme = wp_get_theme();
            $args = array(
                // TYPICAL -> Change these values as you need/desire
                'opt_name' => 'automatic_settings',
                'display_name' => $theme->get('Name'),
                'display_version' => $theme->get('Version'),
                'menu_type' => 'menu',
                'allow_sub_menu' => true,
                'menu_title' => 'Automatic',
                'page_title' => 'Automatic',
                'google_api_key' => '',
                'google_update_weekly' => false,
                'async_typography' => true,
                'admin_bar' => true,
                'admin_bar_icon' => 'dashicons-admin-generic',
                'admin_bar_priority' => 50,
                'global_variable' => '',
                'dev_mode' => false,
				'forced_dev_mode_off' => false,
                'update_notice' => false,
                'customizer' => true,
                'page_priority' => null,
                'page_parent' => 'themes.php',
                'page_permissions' => 'manage_options',
                'menu_icon' => '',
                'last_tab' => '',
                'page_icon' => 'icon-themes',
                'page_slug' => '',
                'save_defaults' => true,
                'default_show' => false,
                'default_mark' => '',
                'show_import_export' => true,
                'transient_time' => 60 * MINUTE_IN_SECONDS,
                'output' => true,
                'output_tag' => true,
                'database' => '',
                'use_cdn' => true,
                // HINTS
                'hints' => array(
                    'icon' => 'el el-question-sign',
                    'icon_position' => 'right',
                    'icon_color' => 'lightgray',
                    'icon_size' => 'normal',
                    'tip_style' => array(
                        'color' => 'red',
                        'shadow' => true,
                        'rounded' => false,
                        'style' => '',
                    ),
                    'tip_position' => array(
                        'my' => 'top left',
                        'at' => 'bottom right',
                    ),
                    'tip_effect' => array(
                        'show' => array(
                            'effect' => 'slide',
                            'duration' => '500',
                            'event' => 'mouseover',
                        ),
                        'hide' => array(
                            'effect' => 'slide',
                            'duration' => '500',
                            'event' => 'click mouseleave',
                        ),
                    ),
                )
            );
            return $args;
        }

        protected function automatic_header_types() {
            return array();
        }

        protected function automatic_footer_types() {
            return array();
        }

    }

    global $automaticReduxSettings;
    $automaticReduxSettings = new Framework_Automatic_Settings();
}