<?php
require_once( automatic_admin . '/settings/settings.php' );
require_once( automatic_admin . '/settings/save_settings.php' );
require_once( automatic_admin . '/settings/walker_nav_menu/walker_nav_menu.php' );


function automatic_removeDemoModeLink() {
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks'), null, 2 );
        remove_action('admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );
		$ReduxFrameworkPlugin =array();
		$ReduxFrameworkPlugin ['demo'] ='';
		update_option( 'ReduxFrameworkPlugin',$ReduxFrameworkPlugin  );
    }
}
add_action('init', 'automatic_removeDemoModeLink');

//get theme sidebar position options
function automatic_sidebar_position() {
    return array(
        'default' => esc_html__('Default Position', 'automatic'),
        'left-sidebar' => esc_html__('Left', 'automatic'),
        'right-sidebar' => esc_html__('Right', 'automatic'),
        'none' => esc_html__('None', 'automatic')
    );
}
function automatic_settings() {
    global $automatic_settings;
    return $automatic_settings;
}
/******** logo Functions ***********/
function automatic_logo($mobile = null){
    $config = automatic_settings();
    if(isset($config['logo_type']) && $config['logo_type'] == 'logo_image'){
			if($mobile == 'mobile' && $config['logo_image_mobile']['url']!=''){
				echo '<img src="'. esc_url(str_replace(array('http:', 'https:'), '', $config['logo_image_mobile']['url'])) . '" alt="' . esc_attr(get_bloginfo('name', 'display')) . '">';
			}else{
				echo '<img src="'. esc_url(str_replace(array('http:', 'https:'), '', $config['logo_image']['url'])) . '" alt="' . esc_attr(get_bloginfo('name', 'display')) . '">';
			}
    }else{
        ob_start();
        if ( is_front_page() && is_home() ) : ?>
            <h1 class="site-title"><?php echo esc_html($config['logo_text']); ?></h1>
        <?php else : ?>
            <p class="site-title"><?php echo esc_html($config['logo_text']); ?></p>
        <?php endif;
        echo ob_get_clean();
    }
}
/******** seach Functions **********/
function automatic_search(){
    $config = automatic_settings();
	$template = get_search_form(false);
    if(class_exists( 'WooCommerce' ) && isset($config['search_type']) && $config['search_type']=='product'){
         $template = get_product_search_form(false);
    }
    echo ($template);
}
function automatic_excert($length,$post_id = 0) {
    if ( is_numeric( $post_id ) && $post_id > 0 ) {
        $post_obj = get_post( $post_id );
        $excerpt = $post_obj->post_excerpt;
        $content = strip_tags( apply_filters( 'the_content', $post_obj->post_content ) );
    } else {
        $excerpt = get_the_excerpt();
        $content = strip_tags( apply_filters( 'the_content', do_shortcode( get_the_content('') ) ) );
    }
    if ( mb_strlen( $excerpt ) > $length ) {
        $subex = mb_substr( $excerpt, 0, $length - 5 );
        $indicator = apply_filters( 'excerpt_more', '' );
    } else {
        if ( mb_strlen( $content ) > $length ) {
            $indicator = apply_filters( 'excerpt_more', '' );
            $subex = mb_substr( $content, 0, $length - 5 );
        } else {
            return $content;
        }
    }

    if ( ! strpos( $subex, ' ' ) ) return '';

    $exwords = explode( ' ', $subex );
    $excut = - ( mb_strlen( $exwords[ count( $exwords ) - 1 ] ) );
    if ( $excut < 0 ) {
        return trim( mb_substr( $subex, 0, $excut ) ) . $indicator;
    } else {
        return trim( $subex ) . $indicator;
    }
}
/****** Social Functions *******/
function automatic_social($header_type){
	$automatic_config = automatic_settings();
	$automatic_socials = $automatic_config[$header_type.'_social'];
	if(count($automatic_socials) > 0){
		echo '<ul class="automatic_socials">';
			for($i=0; $i< count($automatic_socials); $i++){
				echo '<li class="social"> <a href="'.esc_url($automatic_config['social_'.$automatic_socials[$i].'_link']).'" target="_blank"><i class="fa fa-'.$automatic_socials[$i].'"></i></a></li>';
			}
		echo '</ul>';
	}
}
function automatic_social_share($social,$link,$des){
	$automatic_config = automatic_settings();
	?>
	<li class="share-buttons">
		<?php
			switch ($social) {
				case 'digg':
					?>
						<a href="http://www.digg.com/submit?url=<?php echo esc_attr($link) ?>" target="_blank">
							 <span><i class="fa fa-digg"></i></span>
						</a>
					<?php
					break;
				case 'facebook':
					?>
						<a href="http://www.facebook.com/sharer.php?u=<?php echo esc_attr($link) ?>&[title]=<?php echo esc_attr($des) ?>" target="_blank">
							<span><i class="fa fa-facebook"></i></span>
						</a>
					<?php
					break;
				case 'google-plus':
					?>
						<!-- Google+ -->
						<a href="https://plus.google.com/share?url=<?php echo esc_attr($link) ?>" target="_blank">
							<span><i class="fa fa-google-plus"></i></span>
						</a>
					<?php
					break;
				case 'linkedin':
					?>
						<!-- LinkedIn -->
						<a href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo esc_attr($link) ?>" target="_blank">
							<span><i class="fa fa-linkedin"></i></span>
						</a>
					<?php
					break;
				case 'pinterest':
					?>
						<!-- Pinterest -->
						<a href="http://pinterest.com/pin/create/button/?url=<?php echo esc_attr($link) ?>&description=<?php  echo esc_attr($des)?>"  target="_blank">
							<span><i class="fa fa-pinterest"></i></span>
						</a>
					<?php
					break;
				case 'reddit':
					?>
						<!-- Reddit -->
						<a href="http://reddit.com/submit?url=<?php echo esc_attr($link) ?>&title=<?php echo esc_attr($des) ?>" target="_blank">
							<span><i class="fa fa-reddit"></i></span>
						</a>
					<?php
					break;
				case 'stumbleUpon':
					?>
						<!-- StumbleUpon-->
						<a href="http://www.stumbleupon.com/submit?url=<?php echo esc_attr($link) ?>&title=<?php echo esc_attr($des) ?>" target="_blank">
							<span><i class="fa fa-stumbleUpon"></i></span>
						</a>
					<?php
					break;
				case 'tumblr':
					?>
					<!-- Tumblr-->
					<a href="http://www.tumblr.com/share/link?url=<?php echo esc_attr($link) ?>&title=<?php echo esc_attr($des) ?>" target="_blank">
						<span><i class="fa fa-tumblr"></i></span>
					</a>
					<?php
					break;
				case 'twitter':
					?>
					<!-- Twitter -->
					<a href="https://twitter.com/share?url=<?php echo esc_attr($link) ?>& =<?php echo esc_attr($des) ?>" target="_blank">
						<span><i class="fa fa-twitter"></i></span>
					</a>
					<?php
					break;
				case 'vk':
					?>
					<!-- VK -->
					<a href="http://vkontakte.ru/share.php?url=<?php echo esc_attr($link) ?>" target="_blank">
						<span><i class="fa fa-vk"></i></span>
					</a>
					<?php
					break;
				default:
					break;
			}
		?>
	</li>
	<?php
}
function automatic_socials_share($link,$des){
	$automatic_config = automatic_settings();
	$automatic_socials = $automatic_config['post_social_share'];
	if(count($automatic_socials) > 0){
		echo '<ul class="post-social list-unstyled f_right">';
			for($i=0; $i< count($automatic_socials); $i++){
				automatic_social_share($automatic_socials[$i],$link,$des);
			}
		echo '</ul>';
	}
}
/******** Breacrumb functions ********/
function automatic_page_title() {
    global $automatic_settings, $post, $wp_query, $author;

    $home = esc_html__('Home', 'automatic');

    $shop_page_id = false;
    $front_page_shop = false;
    if ( defined( 'WOOCOMMERCE_VERSION' ) ) {
        $shop_page_id = wc_get_page_id( 'shop' );
        $front_page_shop = get_option( 'page_on_front' ) == wc_get_page_id( 'shop' );
    }

    if ( ( ! is_home() && ! is_front_page() && ! ( is_post_type_archive() && $front_page_shop ) ) || is_paged() ) {

        if ( is_home() ) {

        } else if ( is_category() ) {

            echo single_cat_title( '', false );

        } elseif ( is_tax('product_cat') || is_tax('portfolio_cat')) {

            $current_term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );

            echo esc_html( $current_term->name );

        } elseif ( is_tax('product_tag') ) {

            $queried_object = $wp_query->get_queried_object();
            echo esc_html__( 'Products tagged &ldquo;', 'automatic' ) . $queried_object->name . '&rdquo;';

        } elseif ( is_day() ) {

            printf( esc_html__( 'Daily Archives: %s', 'automatic' ), get_the_date() );

        } elseif ( is_month() ) {

            printf( esc_html__( 'Monthly Archives: %s', 'automatic' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'automatic' ) ) );

        } elseif ( is_year() ) {

            printf( esc_html__( 'Yearly Archives: %s', 'automatic' ), get_the_date( _x( 'Y', 'yearly archives date format', 'automatic' ) ) );

        } elseif ( is_post_type_archive('product') && get_option('page_on_front') !== $shop_page_id ) {

            $_name = wc_get_page_id( 'shop' ) ? get_the_title( wc_get_page_id( 'shop' ) ) : '';

            if ( ! $_name ) {
                $product_post_type = get_post_type_object( 'product' );
                $_name = $product_post_type->labels->singular_name;
            }

            if ( is_search() ) {

            } elseif ( is_paged() ) {

            } else {

                echo esc_html($_name);

            }

        } elseif ( is_post_type_archive('portfolio') ) {

            $post_type = get_post_type_object( 'portfolio' );
            echo esc_html($post_type->labels->name);

        } else if ( is_post_type_archive() ) {
            sprintf( esc_html__( 'Archives: %s', 'automatic' ), post_type_archive_title( '', false ) );
        } elseif ( is_single() && ! is_attachment() ) {

            if ( 'portfolio' == get_post_type() ) {

                echo get_the_title();

            } else {

                echo get_the_title();

            }

        } elseif ( is_404() ) {

            echo '404';

        } elseif ( ! is_single() && ! is_page() && get_post_type() != 'post' ) {

            $post_type = get_post_type_object( get_post_type() );

            if ( $post_type ) {
                echo esc_html($post_type->labels->singular_name);
            }

        } elseif ( is_attachment() ) {

            echo get_the_title();

        } elseif ( is_page() && !$post->post_parent ) {

            echo get_the_title();

        } elseif ( is_page() && $post->post_parent ) {

            echo get_the_title();

        } elseif ( is_search() ) {

            echo esc_html__( 'Search results for &ldquo;', 'automatic' ) . get_search_query() . '&rdquo;';

        } elseif ( is_tag() ) {

            echo esc_html__( 'Posts tagged &ldquo;', 'automatic' ) . single_tag_title('', false) . '&rdquo;';

        } elseif ( is_author() ) {

            $userdata = get_userdata($author);
            echo esc_html__( 'Author:', 'automatic' ) . ' ' . $userdata->display_name;

        }

        if ( get_query_var( 'paged' ) ) {
            echo ' (' . esc_html__( 'Page', 'automatic' ) . ' ' . get_query_var( 'paged' ) . ')';
        }
    } else {
        if ( is_home() && !is_front_page() ) {
            if ( ! empty( $home ) ) {
                echo force_balance_tags($automatic_settings['blog-title']);
            }
        }
    }
}
function automatic_heading_banner($type) {
    $config = automatic_settings();
    $breadcrumbs_type = automatic_get_meta_value('banner_color', false);
	$class_bg = 'default';
	$automatic_style='';
    ob_start();
    ?>
    <div class="page-banner small">
        <?php
        if( $breadcrumbs_type == 'banner_color' ) {
			if( $config[$type.'_bg_color'] !=''){
				$class_bg = 'bg_color';
				$automatic_style = 'background-color:'. $config[$type.'_bg_color'];
			}else {
				$class_bg = 'default';
			}
		}elseif( $config[$type.'_banner'] =='show' ) {
            if( $config[$type.'_bg'] =='show' ) {
                if( $config[$type.'_bg_image'] !=''){
                    $automatic_style = 'background-image:url('.esc_url( $config[$type.'_bg_image']['url'] ).')';
                    $class_bg = 'bg_image';
                }else{
                    $class_bg = 'default';
                }
            }else{
                if( $config[$type.'_bg_color'] !=''){
                    $class_bg = 'bg_color';
                    $automatic_style = 'background-color:'. $config[$type.'_bg_color'];
                }else {
                    $class_bg = 'default';
                }
            }
        }
        ?>
        <div class="breadcrumb <?php echo esc_attr($class_bg); ?>" style="<?php echo esc_attr($automatic_style); ?>">
            <div class="breadcrumbs-content">
                <div class="container">
                    <div class="table-middle">
                        <div class="table-cell">
                            <div class="page-title">
                                <h1 class="heading text-uppercase"><?php automatic_page_title(); ?></h1>
                            </div>
                            <?php automatic_breadcrumbs(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
    echo ob_get_clean();
}
/*Automatic Pagination Custom*/
function custom_pagination($numpages = '', $pagerange = '', $paged='') {

  if (empty($pagerange)) {
    $pagerange = 2;
  }
    global $paged;
    if (empty($paged)) {
        $paged = 1;
    }
    if ($numpages == '') {
        global $wp_query;
        $numpages = $wp_query->max_num_pages;
        if(!$numpages) {
            $numpages = 1;
        }
    }
    $pagination_args = array(
        'base'            => get_pagenum_link(1) . '%_%',
        'format'          => 'page/%#%',
        'total'           => $numpages,
        'current'         => $paged,
        'show_all'        => False,
        'end_size'        => 1,
        'mid_size'        => $pagerange,
        'prev_next'       => True,
        'prev_text'       => '<',
        'next_text'       => '>',
        'type'            => 'plain',
        'add_args'        => false,
        'add_fragment'    => ''
    );

  $paginate_links = paginate_links($pagination_args);

    if ($paginate_links) {
        echo "<nav class='custom-pagination'>";
            echo ($paginate_links);
        echo "</nav>";
    }

}
/***** Header Footer functions ******/
function automatic_header_show(){
    global $post;
    $automatic_header_show = 'show_header';
    if(is_page()){
        $automatic_id = $post->ID;
    }
    elseif(function_exists('is_shop') && is_shop()){
        $automatic_id = get_option( 'woocommerce_shop_page_id' );
    }
    else{
        $automatic_id = -1;
    }
    if(get_post_meta($automatic_id, 'hidden_header', true)){
        $automatic_header_show = get_post_meta($automatic_id, 'hidden_header', true);
    }
    return $automatic_header_show;
}
function automatic_header_types() {
	global $post;
	$config = automatic_settings();
	$automatic_header_show = 'show_header';
	$automatic_header_layout = '';
	$automatic_header_layout = $config['header_selected'];
	
	if(is_page()){
		$automatic_id = $post->ID;
	}
	elseif(function_exists('is_shop') && is_shop()){
		$automatic_id = get_option( 'woocommerce_shop_page_id' );
	}
	else{
		$automatic_id = -1;
	}
	if(get_post_meta($automatic_id, 'hidden_header', true)){
		$automatic_header_show = get_post_meta($automatic_id, 'hidden_header', true);
	}
	if(get_post_meta($automatic_id, 'header_layout', true) && get_post_meta($automatic_id, 'header_layout', true) !='default'){
		$automatic_header_layout = get_post_meta($automatic_id, 'header_layout', true);

	} 
	return $automatic_header_layout;
}
function automatic_header() {
    $automatic_header_layout = automatic_header_types();
    $automatic_header_show = automatic_header_show();
    ob_start();
    if($automatic_header_show == 'show_header'){
        switch($automatic_header_layout){
            case 'header_1':
                get_template_part( 'inc/template-parts/headers/header-1' );
                break;
            case 'header_2':
                get_template_part( 'inc/template-parts/headers/header-2' );
                break;
            case 'header_3':
                get_template_part( 'inc/template-parts/headers/header-3' );
                break;
            default :
                get_template_part( 'inc/template-parts/headers/header-1' );
                break;
        }
    }else{
        echo '<div class="site-inner">';
    }
    echo ob_get_clean();
}
function automatic_footer_types() {
    global $post;
    $automatic_config = automatic_settings();
    ob_start();
    $automatic_footer_show = 'show_footer';
    $automatic_footer_layout = '';
    $automatic_footer_layout = $automatic_config['footer_selected'];
    if(is_page()){
        $automatic_id = $post->ID;
    }
    elseif(function_exists('is_shop') && is_shop()){
        $automatic_id = get_option( 'woocommerce_shop_page_id' );
    }
    else{
        $automatic_id = -1;
    }
    if( class_exists('Woocommerce') && (is_product_category() || is_product()) ){
        $automatic_footer_layout = $automatic_config['footer_category'];
    }
    $posttype = get_post_type($post );
    if ( (is_search() || is_archive() || is_author() || is_category() || is_home() || is_single() || is_tag()) && ( $posttype == 'post') ){
        $automatic_footer_layout = $automatic_config['footer_blog'];
    }
    if( is_404() ){
        $automatic_footer_layout = $automatic_config['footer_404'];
    }
    if(get_post_meta($automatic_id, 'hidden_footer', true)){
        $automatic_footer_show = get_post_meta($automatic_id, 'hidden_footer', true);
    }
    if(get_post_meta($automatic_id, 'footer_layout', true) && get_post_meta($automatic_id, 'footer_layout', true) !='default'){
        $automatic_footer_layout = get_post_meta($automatic_id, 'footer_layout', true);
    }
    if($automatic_footer_show == 'show_footer'){
        switch($automatic_footer_layout){
            case 'footer_1':
                get_template_part( 'inc/template-parts/footers/footer-1' );
                break;
            case 'footer_2':
                get_template_part( 'inc/template-parts/footers/footer-2' );
                break;
            case 'footer_3':
                get_template_part( 'inc/template-parts/footers/footer-3' );
                break;
            default :
                get_template_part( 'inc/template-parts/footers/footer-1' );
                break;
        }
    }
    echo ob_get_clean();
}
