<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage Automatic
 * @since Automatic 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php endif; ?>
	<?php $automatic_settings = automatic_settings();
		if ((! function_exists( 'has_site_icon' ) || ! has_site_icon()) &&!empty($automatic_settings['favicon_main'])): ?>
			<link rel="shortcut icon" href="<?php echo esc_url( is_ssl() ? (str_replace("http://","https://",$automatic_settings['favicon_main']['url'])) : $automatic_settings['favicon_main']['url'])?> "/>
    <?php endif; ?>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php 
	automatic_loader();
?>
<div id="page" class="site">
	<div class="site-inner">
		<header id="masthead">
			<?php automatic_header() ; ?>
		</header><!-- .site-header -->
		<div id="content" class="site-content">
