<?php
$theme = wp_get_theme();
define('automatic_version', $theme->get('Version'));
define('automatic_lib', get_template_directory() . '/inc');
define('automatic_admin', automatic_lib . '/admin');
define('automatic_megamenu', automatic_admin . '/settings/walker_nav_menu');
define('automatic_functions', automatic_lib . '/functions');
define('automatic_plugins', automatic_lib . '/plugins');
define('automatic_metaboxes', automatic_functions . '/metaboxes');
define('automatic_css', get_template_directory_uri() . '/assets/css');
define('automatic_js', get_template_directory_uri() . '/assets/js');

if ( ! defined( 'AUTOMATIC_DIR' ) ) define( 'AUTOMATIC_DIR', get_template_directory() );
if ( ! defined( 'AUTOMATIC_DIR_URI') )  define( 'AUTOMATIC_DIR_URI', get_template_directory_uri() );
require_once(automatic_plugins . '/functions.php');
require( AUTOMATIC_DIR . '/inc/theme-setup.php' );
require( AUTOMATIC_DIR . '/inc/widgets/widgets.php' );
add_filter('woocommerce_currency_symbol', 'add_auto_currency_symbol', 10, 2);

function add_auto_currency_symbol( $currency_symbol, $currency ) {
     switch( $currency ) {
          case 'RUB': $currency_symbol = 'ք'; break;
          case 'TRY': $currency_symbol = '&#84;&#76;'; break;
          case 'INR': $currency_symbol = '&#8377;'; break;
     }
     return $currency_symbol;
}
