// page init
jQuery(function(){
	"use strict";
	initScollTop(); 
	initSlide_product( '.initSlide_product' ); 
	initRecentAddSlide('.slide-product-add');  
	initStickyHeader(); 
	automatic_initmegamenu();
	automatic_404();
	js_flexslider();
	automatic_initloader();
});
function js_flexslider(){
	jQuery(window).load(function () {
		jQuery('.flexslider').each(function(){
			jQuery(this).flexslider({
				animation: "slide",
				slideshow: false
			});
		});
	});
	jQuery('.list-view-as a').click(function(e) {
		e.preventDefault();
		jQuery('.flexslider').each(function(){
			jQuery(this).resize();
		});
	});
	jQuery( window ).resize(function(){
		jQuery('.flexslider').each(function(){
			jQuery(this).flexslider({
				animation: "slide",
				slideshow: false,
				before: function (slider) { 
            jQuery('.slide').find('.li').delay(800);
         }
			}); 
		});
	});
}
function automatic_404() {
    jQuery(document).ready(function () {
        if (jQuery(".home404").length > 0){
            jQuery( window ).height();
            jQuery('.content-area').css('min-height',(jQuery( window ).height() - jQuery( '.site-header').innerHeight()));
        }
    });
    jQuery(window).resize(function() {
        if (jQuery(".home404").length > 0){
            jQuery( window ).height();
            jQuery('.content-area').css('min-height',(jQuery( window ).height() - jQuery( '.site-header').innerHeight()));
        }
    });
}

function automatic_initmegamenu() {
    if(jQuery( window ).width() > 991){
        jQuery('li.megamenu').each(function(){
            if(jQuery(this).find('> ul.sub-menu').length){
                var container = jQuery(this).find('> ul.sub-menu');
                container.wrap( "<div class='menu_fullwidth' style='width:"+jQuery( '.site-content' ).width()+"px'></div>" );
            }
        });
    }else{
        jQuery('.header-over').each(function(){
            jQuery(this).addClass('header-over-rm');
            jQuery(this).removeClass('header-over');
        });
    }
    jQuery(window).resize(function() {
       if(jQuery( window ).width() > 991){
            jQuery('li.megamenu').each(function(){
                if(jQuery(this).find('> ul.sub-menu').length){
                    var container = jQuery(this).find('> ul.sub-menu');
                    container.wrap( "<div class='menu_fullwidth' style='width:"+jQuery( '.site-content' ).width()+"px'></div>" );
                }
            });
            jQuery('.header-over-rm').each(function(){
                jQuery(this).addClass('header-over');
                jQuery(this).removeClass('header-over-rm');
            });
        }else{
            jQuery('li.megamenu').each(function(){
                if(jQuery(this).find('> .menu_fullwidth > ul.sub-menu').length){
                    var container = jQuery(this).find(' > .menu_fullwidth > ul.sub-menu');
                    container.unwrap();
                }
            });
            jQuery('.header-over').each(function(){
                jQuery(this).addClass('header-over-rm');
                jQuery(this).removeClass('header-over');
            });
        }
    });
}
function automatic_initloader() {
	jQuery(window).load(function () {
			if (jQuery(".loaderWrap").length > 0)
			{
					jQuery(".loaderWrap").delay(300).fadeOut("slow");
			}
	});
}
 
//Scoll Top
function initScollTop(){
    if(jQuery('.scroll-to-top').length){
        var linkTop = jQuery('.scroll-to-top');
        var animationSpeed = 600;

        linkTop.click(function(e) {
            e.preventDefault();

            jQuery('body,html').stop(true).animate({
                scrollTop: 0
            }, animationSpeed);
        });

        initGoToTopScroll()
    }

    jQuery(window).scroll(function() {
        initGoToTopScroll();
    });
    function initGoToTopScroll() {
        var linkTop = jQuery('.scroll-to-top'),
            win = jQuery(window);

        if(win.scrollTop() > 0) {
            linkTop.css('bottom','25px');
        } else {
            linkTop.css('bottom','-100px');
        }
    }
}


function initSlide_product( element ){ 
    jQuery( element+' .beans-stepslider').each(function() {
        var item = jQuery(this);
        var column = item.parent().attr('data-columns'); 
        var btnPrev = item.find('.btn-prev');
        var btnNext = item.find('.btn-next');
        var slider = item.find('.beans-slideset');
        var pagination = item.find('.beans-pagination');
				var column_768 = 1, column_640 = 1,column_480 = 1; 
				if(parseInt(column) > 3){ column_1024 = parseInt(column) -1 }else{column_1024 = parseInt(column)}
				if(parseInt(column) > 3){ column_992 = parseInt(column) -2 }else{column_992 = parseInt(column)} 
				if (item.parent().attr('data-column1024')) {
					column_1024 = item.parent().attr('data-column1024');
				}
				if (item.parent().attr('data-column992')) {
					column_992 = item.parent().attr('data-column992');
				}
				if (item.parent().attr('data-column768')) {
					column_768 = item.parent().attr('data-column768');
				}
				if (item.parent().attr('data-column640')) {
					column_640 = item.parent().attr('data-column640');
				}
        slider.slick({
						prevArrow: '<button type="button" class="slick-prev"><i class="automaticicon-arrow_thin_left"></i></button>',
						nextArrow: '<button type="button" class="slick-next"><i class="automaticicon-arrow_thin_right"></i></button>',
            arrows: (btnPrev.length > 0) && (btnNext.length > 0) ? true : false,
            dots: pagination.length > 0 ? true : false,
            slidesToShow: parseInt(column),
            slidesToScroll: parseInt(column),  
            autoplay: false,
            responsive: [
                {
									breakpoint: 1024,
									settings: {
										slidesToShow: parseInt(column_1024), 
										slidesToScroll:  parseInt(column_1024), 
									}
                },{
									breakpoint: 992,
									settings: {
										slidesToShow: parseInt(column_992), 
										slidesToScroll: parseInt(column_992), 
									}
                },{
									breakpoint: 768,
									settings: {
										slidesToShow: parseInt(column_768), 
										slidesToScroll: parseInt(column_768), 
									}
                },{
									breakpoint: 640,
									settings: {
										slidesToShow: parseInt(column_640), 
										slidesToScroll: parseInt(column_640), 
									}
                }
            ]
        });
        pagination.remove();
        btnPrev.remove();
        btnNext.remove();
    });
}
/*slider thumb single product*/
function initProductSlide_thumb( element ){
    jQuery( element+' .beans-stepslider').each(function() {
        var item = jQuery(this);
        var btnPrev = item.find('.btn-prev');
        var btnNext = item.find('.btn-next');
        var slider = item.find('.beans-slideset');
        var pagination = item.find('.beans-pagination');

        slider.slick({
            arrows: (btnPrev.length > 0) && (btnNext.length > 0) ? true : false,
            dots: pagination.length > 0 ? true : false,
            slidesToShow: 1,
            mobileFirst: true,
            autoplay: false,
            responsive: [
								{
									breakpoint: 1024,
									settings: {
										slidesToShow: 3
									}
                },
                {
									breakpoint: 767,
									settings: {
										slidesToShow: 3
									}
                }, 
								{
									breakpoint: 320,
									settings: {
										slidesToShow: 2
									}
                }
            ]
        });
        slider.slick('setPosition');
        pagination.remove();
        btnPrev.remove();
        btnNext.remove();
    });
}
function initRecentAddSlide( element ){
    jQuery( element+' .beans-stepslider').each(function() {
			var item = jQuery(this);
			var column = item.parent().attr('data-columns');
			var row = item.parent().attr('data-rows');
			var btnPrev = item.find('.btn-prev');
			var btnNext = item.find('.btn-next');
			var slider = item.find('.beans-slideset');
			var pagination = item.find('.beans-pagination');
			if(parseInt(column) > 3){ column_1024 = parseInt(column) -1 }else{column_1024 = parseInt(column)}
			if(parseInt(row) > 3){ row_1024 = parseInt(row) -1 }else{row_1024 = parseInt(row)}
			slider.slick({
				prevArrow: '<button type="button" class="slick-prev"><i class="automaticicon-arrow_thin_left"></i></button>',
				nextArrow: '<button type="button" class="slick-next"><i class="automaticicon-arrow_thin_right"></i></button>',
				arrows: (btnPrev.length > 0) && (btnNext.length > 0) ? true : false,
				dots: pagination.length > 0 ? true : false,
				slidesToScroll: 1,
				rows: parseInt(row),
				slidesPerRow: parseInt(column),
				autoplay: false,
				responsive: [
						{
							breakpoint: 1024,
							settings: {
								rows: parseInt(row_1024),
								slidesPerRow: parseInt(column_1024),
								slidesToScroll:1,
							}
						},{
							breakpoint: 768,
							settings: {
								rows: 1,
								slidesPerRow: 1,
								slidesToScroll:1,
							}
						}

				]
			});
			slider.slick('setPosition');
			pagination.remove();
			btnPrev.remove();
			btnNext.remove();
    });
}


// sticky header init
function initStickyHeader() {
    var win = jQuery(window),
        stickyClass = 'fixed-position';

    jQuery('.header_fixed').each(function() {
        var header = jQuery(this);
        var headerOffset = header.offset().top || 0;
        var flag = true;

        function scrollHandler() {
            if (win.scrollTop() > headerOffset) {
                if (flag){
                    flag = false;
                    header.addClass(stickyClass);
                }
            } else {
                if (!flag) {
                    flag = true;
                    header.removeClass(stickyClass);
                }
            }
            ResponsiveHelper.addRange({
                '..767': {
                    on: function() {
                        header.removeClass(stickyClass);
                    }
                }
            });
        }

        scrollHandler();
        win.on('scroll resize orientationchange', scrollHandler);
    });
}

/*
 * Responsive Layout helper
 */
ResponsiveHelper = (function($){
    // init variables
    var handlers = [],
        prevWinWidth,
        win = $(window),
        nativeMatchMedia = false;

    // detect match media support
    if(window.matchMedia) {
        if(window.Window && window.matchMedia === Window.prototype.matchMedia) {
            nativeMatchMedia = true;
        } else if(window.matchMedia.toString().indexOf('native') > -1) {
            nativeMatchMedia = true;
        }
    }

    // prepare resize handler
    function resizeHandler() {
        var winWidth = win.width();
        if(winWidth !== prevWinWidth) {
            prevWinWidth = winWidth;

            // loop through range groups
            $.each(handlers, function(index, rangeObject){
                // disable current active area if needed
                $.each(rangeObject.data, function(property, item) {
                    if(item.currentActive && !matchRange(item.range[0], item.range[1])) {
                        item.currentActive = false;
                        if(typeof item.disableCallback === 'function') {
                            item.disableCallback();
                        }
                    }
                });

                // enable areas that match current width
                $.each(rangeObject.data, function(property, item) {
                    if(!item.currentActive && matchRange(item.range[0], item.range[1])) {
                        // make callback
                        item.currentActive = true;
                        if(typeof item.enableCallback === 'function') {
                            item.enableCallback();
                        }
                    }
                });
            });
        }
    }
    win.bind('load resize orientationchange', resizeHandler);

    // test range
    function matchRange(r1, r2) {
        var mediaQueryString = '';
        if(r1 > 0) {
            mediaQueryString += '(min-width: ' + r1 + 'px)';
        }
        if(r2 < Infinity) {
            mediaQueryString += (mediaQueryString ? ' and ' : '') + '(max-width: ' + r2 + 'px)';
        }
        return matchQuery(mediaQueryString, r1, r2);
    }

    // media query function
    function matchQuery(query, r1, r2) {
        if(window.matchMedia && nativeMatchMedia) {
            return matchMedia(query).matches;
        } else if(window.styleMedia) {
            return styleMedia.matchMedium(query);
        } else if(window.media) {
            return media.matchMedium(query);
        } else {
            return prevWinWidth >= r1 && prevWinWidth <= r2;
        }
    }

    // range parser
    function parseRange(rangeStr) {
        var rangeData = rangeStr.split('..');
        var x1 = parseInt(rangeData[0], 10) || -Infinity;
        var x2 = parseInt(rangeData[1], 10) || Infinity;
        return [x1, x2].sort(function(a, b){
            return a - b;
        });
    }

    // export public functions
    return {
        addRange: function(ranges) {
            // parse data and add items to collection
            var result = {data:{}};
            $.each(ranges, function(property, data){
                result.data[property] = {
                    range: parseRange(property),
                    enableCallback: data.on,
                    disableCallback: data.off
                };
            });
            handlers.push(result);

            // call resizeHandler to recalculate all events
            prevWinWidth = null;
            resizeHandler();
        }
    };
}(jQuery));