<?php

defined('ABSPATH') or die('You cannot access here.');

add_action('admin_init', 'automatic_import');

function automatic_import() {

    if (current_user_can('manage_options') && isset($_GET['page']) && $_GET['page'] == 'automatic_pt') {

        if (isset($_GET['import_sample_content'])) {

            if (!defined('WP_LOAD_IMPORTERS'))
                define('WP_LOAD_IMPORTERS', true); // we are loading importers

            if (!class_exists('WP_Importer')) { // if main importer class doesn't exist
                $wp_importer = ABSPATH . 'wp-admin/includes/class-wp-importer.php';
                include $wp_importer;
            }
            if (!class_exists('WP_Import')) { // if WP importer doesn't exist
                $wp_import = dirname( __FILE__ ) . '/wordpress-importer.php';
                include $wp_import;

            }

            $upload = wp_upload_dir();
            $upload_dir = $upload['basedir'];

            if (class_exists('WP_Importer') && class_exists('WP_Import')) { // check for main import class and wp import class
                $data_download = array('automatic.wordpress.xml','automatic.wordpress.menu.xml','widget_data.json','about-1.zip', 'about-2.zip','about-3.zip','agency-2.zip','business-2.zip','bussiness-1.zip','corporate.zip','fashion.zip','home-agency1.zip','home-studio.zip','interior.zip','restaurants.zip','service-1.zip');
                $remote_url = 'http://demo.arrowpress.net/plugins/automatic/';

                foreach($data_download as $file_download) {
                    $download_result = automatic_fetch_remote_file($remote_url . $file_download);
                }

                // setting visual composer content
                update_option('wpb_js_content_types', array('page','block'));
                update_option('ultimate_css', 'disable');
                update_option('ultimate_js', 'enable');

                //not allow duplicate menu
                wp_delete_nav_menu('Main menu');
                wp_delete_nav_menu('Footer menu 2');
                wp_delete_nav_menu('Features sidebar');
				// Import revolustion slider sliders
				if (class_exists('RevSlider')) {
					$rev_lists = array('about-1', 'about-2','about-3','agency-2','business-2','bussiness-1','corporate','fashion','home-agency1','home-studio','interior','restaurants','service-1');
					$revolutionDb = new UniteDBRev();
					$revolutionDb->delete(GlobalsRevSlider::$table_sliders, "alias in ('about-1', 'about-2','about-3','agency-2','business-2','bussiness-1','corporate','fashion','home-agency1','home-studio','interior','restaurants','service-1')");
					foreach($rev_lists as $rev_list){
						$file_path = $upload_dir . '/automatic_data/'.$rev_list.'.zip';
						$slider = new RevSlider();
						$slider->importSliderFromPost(true, true, $file_path);
					}

				}
                // Import data
                $importer = new WP_Import();
                $theme_xml = $upload_dir . '/automatic_data/automatic.wordpress.xml';

                set_time_limit(0);
                $importer->fetch_attachments = true;
                ob_start();
                $importer->import($theme_xml);
                ob_end_clean();

                // Import data

                wp_delete_nav_menu('Main menu');
                wp_delete_nav_menu('Footer menu 2');
                wp_delete_nav_menu('Features sidebar');
                $importer = new WP_Import();
                $theme_xml = $upload_dir . '/automatic_data/automatic.wordpress.menu.xml';

                set_time_limit(0);
                $importer->fetch_attachments = true;
                ob_start();
                $importer->import($theme_xml);
                ob_end_clean();
				// import redux option

                // Set imported menus to registered theme locations
                $locations = get_theme_mod('nav_menu_locations');
                $menus = wp_get_nav_menus(); // registered menus
                if ($menus) {
                    foreach ($menus as $menu) {
                        if ($menu->name == 'Main menu') {
                            $locations['primary'] = $menu->term_id;
                        }
                    }
                }
                set_theme_mod('nav_menu_locations', $locations); // set menus to locations
                // Set reading options
                $homepage = get_page_by_title('Agency 01');
				$posts_page = get_page_by_title('Blog');
                if (($homepage && $homepage->ID)) {
                    update_option('show_on_front', 'page');
                    if ($homepage && $homepage->ID) {
                        update_option('page_on_front', $homepage->ID); // Front Page
                    }
					if ($posts_page && $posts_page->ID) {
                        update_option('page_for_posts', $posts_page->ID); // Blog Page
                    }
                }
				// Set woocommerce pages
				if (class_exists('WooCommerce')) {
                    $woopages = array(
                        'woocommerce_shop_page_id' => 'Shop',
                        'woocommerce_cart_page_id' => 'Cart',
                        'woocommerce_checkout_page_id' => 'Checkout',
                        'woocommerce_myaccount_page_id' => 'My Account'
                    );
                    foreach ($woopages as $page_key => $page_title) {
                        $woopage = get_page_by_title($page_title);
                        if (isset($woopage) && $woopage->ID) {
                            update_option($page_key, $woopage->ID); // Front Page
                        }
                    }

                    // disable woocommerce notice install page
                    $notices = array_diff(get_option('woocommerce_admin_notices', array()), array('install', 'update'));
                    update_option('woocommerce_admin_notices', $notices);
                    update_option('woocommerce_default_catalog_orderby', 'date');
                    delete_option('_wc_needs_pages');
                    delete_transient('_wc_activation_redirect');
                }
            }


            //deactive exist widgets
			update_option('sidebars_widgets', array());
            // Import widgets
            ob_start();
            include($upload_dir . '/automatic_data/widget_data.json');
            $widget_data = ob_get_clean();
            automatic_import_widget_data($widget_data);

            flush_rewrite_rules();
            // finally redirect to success page
            wp_redirect(admin_url('admin.php?page=automatic&import_options_success=true'));
        }

    }
}

// Parsing Widgets Function
// Reference: http://wordpress.org/plugins/widget-settings-importexport/
function automatic_import_widget_data($widget_data) {
    $json_data = $widget_data;
    $json_data = json_decode($json_data, true);

    $sidebar_data = $json_data[0];
    $widget_data = $json_data[1];
    foreach ($widget_data as $widget_data_title => $widget_data_value) {
        $widgets[$widget_data_title] = '';
        foreach ($widget_data_value as $widget_data_key => $widget_data_array) {
            if (is_int($widget_data_key)) {
                $widgets[$widget_data_title][$widget_data_key] = 'on';
            }
        }
    }
    unset($widgets[""]);

    foreach ($sidebar_data as $title => $sidebar) {
        $count = count($sidebar);
        for ($i = 0; $i < $count; $i++) {
            $widget = array();
            $widget['type'] = trim(substr($sidebar[$i], 0, strrpos($sidebar[$i], '-')));
            $widget['type-index'] = trim(substr($sidebar[$i], strrpos($sidebar[$i], '-') + 1));
            if (!isset($widgets[$widget['type']][$widget['type-index']])) {
                unset($sidebar_data[$title][$i]);
            }
        }
        $sidebar_data[$title] = array_values($sidebar_data[$title]);
    }

    foreach ($widgets as $widget_title => $widget_value) {
        foreach ($widget_value as $widget_key => $widget_value) {
            $widgets[$widget_title][$widget_key] = $widget_data[$widget_title][$widget_key];
        }
    }

    $sidebar_data = array(array_filter($sidebar_data), $widgets);
    automatic_parse_import_data($sidebar_data);
}

function automatic_parse_import_data($import_array) {
    global $wp_registered_sidebars;
    $sidebars_data = $import_array[0];
    $widget_data = $import_array[1];
    $current_sidebars = get_option('sidebars_widgets');
    $new_widgets = array();

    foreach ($sidebars_data as $import_sidebar => $import_widgets) :

        foreach ($import_widgets as $import_widget) :
            //if the sidebar exists
            if (isset($wp_registered_sidebars[$import_sidebar])) :
                $title = trim(substr($import_widget, 0, strrpos($import_widget, '-')));
                $index = trim(substr($import_widget, strrpos($import_widget, '-') + 1));
                $current_widget_data = get_option('widget_' . $title);
                $new_widget_name = automatic_get_new_widget_name($title, $index);
                $new_index = trim(substr($new_widget_name, strrpos($new_widget_name, '-') + 1));

                if (!empty($new_widgets[$title]) && is_array($new_widgets[$title])) {
                    while (array_key_exists($new_index, $new_widgets[$title])) {
                        $new_index++;
                    }
                }
                $current_sidebars[$import_sidebar][] = $title . '-' . $new_index;
                if (array_key_exists($title, $new_widgets)) {
                    $new_widgets[$title][$new_index] = $widget_data[$title][$index];
                    $multiwidget = $new_widgets[$title]['_multiwidget'];
                    unset($new_widgets[$title]['_multiwidget']);
                    $new_widgets[$title]['_multiwidget'] = $multiwidget;
                } else {
                    $current_widget_data[$new_index] = $widget_data[$title][$index];
                    $current_multiwidget = (isset($current_widget_data['_multiwidget'])) ? $current_widget_data['_multiwidget'] : '';
                    $new_multiwidget = isset($widget_data[$title]['_multiwidget']) ? $widget_data[$title]['_multiwidget'] : false;
                    $multiwidget = ($current_multiwidget != $new_multiwidget) ? $current_multiwidget : 1;
                    unset($current_widget_data['_multiwidget']);
                    $current_widget_data['_multiwidget'] = $multiwidget;
                    $new_widgets[$title] = $current_widget_data;
                }

            endif;
        endforeach;
    endforeach;

    if (isset($new_widgets) && isset($current_sidebars)) {
        update_option('sidebars_widgets', $current_sidebars);

        foreach ($new_widgets as $title => $content)
            update_option('widget_' . $title, $content);

        return true;
    }

    return false;
}

function automatic_get_new_widget_name($widget_name, $widget_index) {
    $current_sidebars = get_option('sidebars_widgets');
    $all_widget_array = array();
    foreach ($current_sidebars as $sidebar => $widgets) {
        if (!empty($widgets) && is_array($widgets) && $sidebar != 'wp_inactive_widgets') {
            foreach ($widgets as $widget) {
                $all_widget_array[] = $widget;
            }
        }
    }
    while (in_array($widget_name . '-' . $widget_index, $all_widget_array)) {
        $widget_index++;
    }
    $new_widget_name = $widget_name . '-' . $widget_index;
    return $new_widget_name;
}

function automatic_fetch_remote_file( $url ) {
    global $automaticReduxSettings;
    $reduxFramework = $automaticReduxSettings->ReduxFramework;
    $tmp = download_url( $url );
    $file_array = array(
        'name' => basename( $url ),
        'tmp_name' => $tmp
    );
    // Check for download errors
    if ( is_wp_error( $tmp ) ) {
        @unlink( $file_array[ 'tmp_name' ] );
        return $tmp;
    }
    $upload = wp_upload_dir();
    $new_file = $upload['basedir'] . "/automatic_data/" . $file_array['name'];
    if(file_exists($new_file)) {
        @unlink($new_file);
    }
    if ( !wp_mkdir_p( $upload['basedir'] . '/automatic_data' ) ) {
        if ( 0 === strpos( $upload['basedir'], ABSPATH ) )
            $error_path = str_replace( ABSPATH, '', $upload['basedir'] ) . $upload['subdir'];
        else
            $error_path = basename( $upload['basedir'] ) . $upload['subdir'];

        $message = sprintf( esc_html__( 'Unable to create directory %s. Is its parent directory writable by the server?', 'automatic_pt' ), $error_path );
        return array( 'error' => $message );
    }
    $new_file_content = $reduxFramework->filesystem->execute('get_contents', $file_array['tmp_name']);
    $reduxFramework->filesystem->execute('put_contents', $new_file, array('content' => $new_file_content, 'chmod' => 0777));
    return '';
}


?>