<?php

/*
  Plugin Name: Automatic Post Types
  Plugin URI:
  Description: Register Post Types for automatic Theme.
  Version: 1.0.0
  Author: AHT
  Author URI:
 */

// don't load directly
if (!defined('ABSPATH'))
    die('-1');
require_once dirname( __FILE__ ) . '/importer/importer.php';
class AutomaticPostTypes{

    function __construct() {

        // Load text domain
        add_action('plugins_loaded', array($this, 'loadTextDomain'));

        // Register post types
        add_action('init', array( $this, 'automatic_addPostPostType'), 0 );
        add_action('init', array($this, 'automatic_addBlockPostType'));
        add_action('init', array($this, 'automatic_testimonialPostType'),0);
        add_action('init', array($this, 'automatic_addClientPostType'),0);
        add_action('init', array($this, 'automatic_addTeamPostType'),0);
    }
    // Init plugins
    function initPlugin() {

    }
    // Register static block post type
    function automatic_addBlockPostType() {
        register_post_type(
            'block', array(
            'labels' => $this->getLabels(esc_html__('Static Block', 'automatic_pt'), esc_html__('Static Block', 'automatic_pt')),
            'exclude_from_search' => true,
            'has_archive' => false,
            'publicly_queryable'  => false,
            'public' => true,
            'rewrite' => array('slug' => 'block'),
            'supports' => array('title', 'editor', 'thumbnail', 'comments', 'page-attributes'),
            'can_export' => true
                )
        );
    }
    // Register static block post type
    function automatic_addPostPostType() {
        register_taxonomy(
            'post_layout', 'post', array(
                'hierarchical' => true,
                'has_archive'   => true,
                'public' => false,  // it's not public, it shouldn't have it's own permalink, and so on
                'publicly_queriable' => true,  // you should be able to query it
                'show_ui' => true,  // you should be able to edit it in wp-admin
                'exclude_from_search' => true,  // you should exclude it from search results
                'show_in_nav_menus' => false,  // you shouldn't be able to add it to menus
                'has_archive' => false,  // it shouldn't have archive page
                'rewrite' => false,  // it shouldn't have rewrite rules
                'labels' => $this->getLabels(esc_html__('Tax Layout', 'automatic_pt'), esc_html__('Tax Layout', 'automatic_pt')),
                'query_var' => true,
                'rewrite' => true
                )
        );
    }
    // Register client post type
    function automatic_addClientPostType() {
        register_post_type(
            'client', array(
            'labels' => $this->getLabels(esc_html__('Client', 'automatic_pt'), esc_html__('Client', 'automatic_pt')),
            'exclude_from_search' => true,
            'has_archive' => false,
            'publicly_queryable'  => false,
            'public' => true,
            'rewrite' => array('slug' => 'block'),
            'supports' => array('title', 'editor', 'thumbnail', 'comments', 'page-attributes'),
            'can_export' => true
                )
        );
        $labels_format = array(
            'name'              => __( 'Client Category','automatic_pt' ),
            'singular_name'     => __( 'Client Category','automatic_pt' ),
            'search_items'      => __( 'Search Client Category','automatic_pt' ),
            'all_items'         => __( 'All Client Category','automatic_pt' ),
            'parent_item'       => __( 'Parent Client Category','automatic_pt' ),
            'parent_item_colon' => __( 'Parent Client Category:','automatic_pt' ),
            'edit_item'         => __( 'Edit Client Category','automatic_pt' ),
            'update_item'       => __( 'Update Client Category','automatic_pt' ),
            'add_new_item'      => __( 'Add New Client Category' ,'automatic_pt'),
            'new_item_name'     => __( 'New Client Category','automatic_pt' ),
            'menu_name'         => __( 'Client Category','automatic_pt' ),
        );
        $args_format = array(
            'labels' => $labels_format,
            'hierarchical' => true,
            'has_archive'   => true,
        );
        register_taxonomy( 'client_cat', 'client', $args_format );
    }
    // Register team post type
    function automatic_addTeamPostType() {
        register_post_type(
            'team', array(
            'labels' => $this->getLabels(esc_html__('Team', 'automatic_pt'), esc_html__('Team', 'automatic_pt')),
            'exclude_from_search' => false,
            'has_archive' => true,
            'public' => true,
            'rewrite' => array('slug' => 'team'),
            'supports' => array('title', 'editor', 'thumbnail', 'comments', 'page-attributes'),
            'can_export' => true
                )
        );
    }

    // Register testimonial
    function automatic_testimonialPostType(){
        $labels = array(
            'name'               => esc_html__( 'All Testimonial','automatic_pt' ),
            'singular_name'      => esc_html__( 'All Testimonial','automatic_pt'),
            'add_new'            => esc_html__( 'Add New','automatic_pt'),
            'add_new_item'       => esc_html__( 'Add New Testimonial','automatic_pt' ),
            'edit_item'          => esc_html__( 'Edit Testimonial','automatic_pt' ),
            'new_item'           => esc_html__( 'New Testimonial','automatic_pt' ),
            'all_items'          => esc_html__( 'All Testimonial','automatic_pt' ),
            'view_item'          => esc_html__( 'View Testimonial','automatic_pt' ),
            'search_items'       => esc_html__( 'Search Testimonial','automatic_pt' ),
            'not_found'          => esc_html__( 'No Testimonial found','automatic_pt' ),
            'not_found_in_trash' => esc_html__( 'No Testimonial found in the Trash','automatic_pt' ),
            'parent_item_colon'  => '',
            'menu_name'          => 'Testimonial'
        );
        $args = array(
            'labels'        => $labels,
            'description'   => 'Holds our testimonial specific data',
            'public'        => true,
            'menu_position' => 5,
            'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'comments' ),
            'has_archive'   => true,
            'public' => false,  // it's not public, it shouldn't have it's own permalink, and so on
            'publicly_queriable' => true,  // you should be able to query it
            'show_ui' => true,  // you should be able to edit it in wp-admin
            'exclude_from_search' => true,  // you should exclude it from search results
            'show_in_nav_menus' => false,  // you shouldn't be able to add it to menus
            'has_archive' => false,  // it shouldn't have archive page
            'rewrite' => false,  // it shouldn't have rewrite rules
        );
        register_post_type( 'testimonial', $args );
    }
    // load plugin text domain
    function loadTextDomain() {
        load_plugin_textdomain('automatic_pt', false, dirname(__FILE__) . '/languages/');
    }

    // Get content type labels
    function getLabels($singular_name, $name, $title = FALSE) {
        if (!$title)
            $title = $name;

        return array(
            "name" => $title,
            "singular_name" => $singular_name,
            "add_new" => esc_html__("Add New", 'automatic_pt'),
            "add_new_item" => sprintf(esc_html__("Add New %s", 'automatic_pt'), $singular_name),
            "edit_item" => sprintf(esc_html__("Edit %s", 'automatic_pt'), $singular_name),
            "new_item" => sprintf(esc_html__("New %s", 'automatic_pt'), $singular_name),
            "view_item" => sprintf(esc_html__("View %s", 'automatic_pt'), $singular_name),
            "search_items" => sprintf(esc_html__("Search %s", 'automatic_pt'), $name),
            "not_found" => sprintf(esc_html__("No %s found", 'automatic_pt'), $name),
            "not_found_in_trash" => sprintf(esc_html__("No %s found in Trash", 'automatic_pt'), $name),
            "parent_item_colon" => ""
        );
    }

}
new AutomaticPostTypes();
