<?php
add_shortcode( 'automatic_testimonial', 'automatic_tp_testimonial' );
function automatic_tp_testimonial( $atts ){
    extract( shortcode_atts(
        array(
            'title' => '',
            'layout' => 'default',
            'items_show' => -1,
            'el_class' => '',
            'css' => '',
        ),$atts ));
    ob_start();

    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, '' ), 'automatic_testimonial', $atts );
    $el_class = automatic_extract_class( $el_class );
    if ( $css_class != '' ){
        $el_class .= automatic_extract_class( $css_class );
    }
    ?>
    <div class="automatic-testi<?php echo $el_class; ?>">
        <?php
        if ( $title != '' ) : 
					?>
					<div class="shortcode-title wpb_bottom-to-top">
							<h2><?php echo esc_attr( $title );?></h2>
					</div>
					<?php
        endif;
        if ( $items_show < 0 ){
            $args = array(
                'post_type' => 'testimonial',
                'post_status' => 'publish',
                'posts_per_page' => -1,
            );
        }else{
            $args = array(
                'post_type' => 'testimonial',
                'post_status' => 'publish',
                'posts_per_page' => $items_show,
            );
        }

        $rquery = New Wp_Query( $args );
        if ( $rquery -> have_posts() ) :?>
            <div class="slide-testimonial automatic-widge initSlide_product" data-columns="1">
                <div class="beans-stepslider" data-rotate="true">
                    <div class="beans-mask">
                        <div class="beans-slideset">
                            <?php
                            $col = 0;
                            while ( $rquery -> have_posts() ) : $rquery -> the_post();
                                ?>
                                <div class="beans-slide">
                                    <img class="icon-testi" src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/img_tes.png" alt="" />
                                    <div class="txt">
                                        <?php the_content(); ?>
                                    </div>
                                    <div class="testiImg">
                                        <?php the_post_thumbnail( 'full' );?>
                                        <div class="info">
                                            <h3><?php the_title(); ?></h3>
                                            <span><?php echo get_post_meta( get_the_ID(), 'business', true );?></span>
                                        </div>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                        </div>
                    </div>
                    <div class="beans-pagination">
                        <!-- pagination generated here -->
                    </div>
                </div>
            </div>
		    <?php
        endif;
        ?>
    </div>
    <?php
    return ob_get_clean();
}
?>