<?php
add_shortcode( 'automatic_team', 'automatic_tp_team' );
function automatic_tp_team( $atts ){
    extract( shortcode_atts(
        array(
            'title' => '',
            'layout' => 'layout1',
            'items_show' => -1,
            'column' => '1',
            'link'  =>'',
            'css_animation'=>'',
            'el_class' => '',
            'css' => '',
        ),$atts));
    ob_start();
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'automatic_team', $atts );
    $css_class_anm = automatic_getCSSAnimation( $css_animation );

    $el_class = automatic_extract_class( $el_class );
    if ( $css_class != '' ){
        $el_class .= automatic_extract_class( $css_class );
    }
    if ( $css_class_anm != '' ){
        $el_class .= ' '.$css_class_anm;
    }
     //parse link
    $link = ( '||' == $link ) ? '' : $link;
    $link = vc_build_link($link);
    $has_link = false;
    $a_link = '';
    $a_title = $a_target =' ';
    if ( strlen( $link['url'] ) > 0 ){
        $has_link = true;
        $a_link = $link['url'];
        $a_title = $link['title'];
        $a_target = ( strlen($link['target']) > 0 ) ? $link['target'] : '_self';
    }

    switch ( $column ) {
        case '1':
            $cl_class = 'col-xs-12 col-sm-12 col-md-12';
            break;
        case '2':
            $cl_class = 'col-xs-12 col-sm-6 col-md-6';
            break;
        case '3':
            $cl_class = 'col-xs-12 col-sm-4 col-md-4';
            break;
        case '4':
            $cl_class = 'col-xs-12 col-sm-6 col-md-3';
            break;
        case '5':
            $cl_class = 'col-xs-12 col-sm-15 col-md-15';
            break;

        default:
            $cl_class = '';
            break;
    }
?>

    <div class="automatic-team<?php echo $el_class .' '. $layout?> au_fadeIn">
        <?php
        if ( $layout == 'layout1' ):
            if ( $title != '' ) :
							 
        ?>
                <div class="shortcode-title wpb_bottom-to-top">
                    <h2><?php echo esc_attr( $title );?></h2>
                </div>
            <?php
            endif;
            $args = array(
                'post_type' => 'team' ,
                'post_status' => 'publish',
                'posts_per_page' => 4,
            );

            $rquery = new Wp_Query( $args ); ?>
            <div class="row">
            <?php
                if ( $rquery->have_posts() ) :
                    while ( $rquery->have_posts() ) : $rquery->the_post();
                    $position = ( get_post_meta( get_the_ID(), 'position', true ) ) ? get_post_meta( get_the_ID(), 'position', true ) : '';
                ?>
                    <div class="col-xs-4 col-sm-15 col-md-15 col-lg-15 col-xl-15">
                        <div class="team-img">
                            <?php the_post_thumbnail('full'); ?>
                            <div class="info">
                                <p class="name default-color"><a href="<?php the_permalink() ?>"><?php the_title();?></a></p>
                                <p class="work"><?php echo $position; ?></p>
                            </div>
                        </div>

                    </div>
                <?php
                    endwhile;
                    wp_reset_postdata();

                endif;
                if( ($a_title != '') && ($a_link != '') ) :
                ?>
                    <div class="col-xs-4 col-sm-15 col-md-15 col-lg-15 col-xl-15 col-more-team">
                        <div class="automatic-more-team">
                            <span class="pe-7s-users"></span>
                        </div>
                        <p class="name default-color"><a class="link_banner" href="<?php echo esc_attr( $a_link ); ?>" title="<?php echo esc_attr( $a_title ); ?>" target="<?php echo esc_attr( $a_target ); ?>" > <?php echo esc_attr( $a_title ); ?></a></p>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif;
        if ( $layout == 'layout2' ):
            $args = array(
                'post_type' => 'team' ,
                'post_status' => 'publish',
                'posts_per_page' => $items_show,
            );
         $rquery = new Wp_Query( $args ); ?>
            <div class="automatic-team-2">
                <div class="row">
                  <?php
                    if ( $rquery->have_posts() ) :
                        while ( $rquery->have_posts() ) : $rquery->the_post();
                        $position = ( get_post_meta( get_the_ID(), 'position', true ) ) ? get_post_meta( get_the_ID(), 'position', true ) : '';
                        $facebook = !empty( get_post_meta( get_the_ID(), 'facebook', true ) ) ? get_post_meta( get_the_ID(), 'facebook', true ) : '';
                        $twitter = !empty( get_post_meta( get_the_ID(), 'twitter', true ) ) ? get_post_meta( get_the_ID(), 'twitter', true ) : '';
                        $instagram = !empty( get_post_meta( get_the_ID(), 'instagram', true ) ) ? get_post_meta( get_the_ID(), 'instagram', true ) : '';
                        $googleplus = !empty( get_post_meta( get_the_ID(), 'googleplus', true ) ) ? get_post_meta( get_the_ID(), 'googleplus', true ) : '';
                        $social_html = '<ul class="post-social list-unstyled">';
                        if ( $facebook != '' ) :
                            $social_html .= '<li><a class="share-buttons" href="'.esc_url( $facebook ).'" target="_blank"><span><i class="fa fa-facebook"></i></span></a></li>';
                        endif;
                        if ( $twitter != '' ) :
                            $social_html .= '<li><a class="share-buttons" href="'.esc_url( $twitter ).'" target="_blank"><span><i class="fa fa-twitter"></i></span></a></li>';
                        endif;
                        if ( $instagram != '' ) :
                            $social_html .='<li><a class="share-buttons" href="'.esc_url( $instagram ).'" target="_blank"><span><i class="fa fa-instagram" aria-hidden="true"></i></span></a></li>';
                        endif;
                        if ( $googleplus != '' ) :
                            $social_html .='<li><a href="'.esc_url( $googleplus ).'" target="_blank"><i class="fa fa-google-plus"></i></a></li>';
                        endif;
                            $social_html .='</ul>';
                    ?>
                       <div class="<?php echo $cl_class; ?>">
                            <div class="team-img">
                                <?php the_post_thumbnail('full'); ?>
                                <div class="info">
                                <p class="name default-color"><a href="<?php the_permalink() ?>"><?php the_title();?></a></p>
                                    <p class="work"><?php echo $position; ?></p>
                                    <div class="dsc-team"><?php the_content(''); ?></div>
                                    <div class="social">
                                        <?php echo $social_html; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php
                        endwhile;
                        wp_reset_postdata();
                    endif;?>
                </div>
            </div>
        <?php endif; ?>
    </div>
    <?php
    return ob_get_clean();
}