<?php
/**
*
*/
add_shortcode( 'automatic_product_special', 'automatic_template_product_special' );
function automatic_template_product_special( $atts ){
    extract( shortcode_atts(
        array(
            'title' =>'',
            'items_show' => -1,
            'cat_product' => '',
            'column' => '1',
            'row' => '1',
            'el_class' => '',
            'css' => '',
        ),$atts ));
    ob_start();

    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, '' ), 'automatic_product_special', $atts );
    $el_class = automatic_extract_class( $el_class );

    if ( $css_class != '' ){
        $el_class .= automatic_extract_class( $css_class );
    }
    $cl_class = '';
    $column_index = 3;
    switch ( $column ) {
        case '1':
            $column_index = 1;
            $cl_class = 'col-xs-12 col-sm-12 col-md-12';
            break;
        case '2':
            $column_index = 2;
            $cl_class = 'col-xs-12 col-sm-6 col-md-6';
            break;
        case '3':
            $column_index = 3;
            $cl_class = 'col-xs-12 col-sm-4 col-md-4';
            break;
        case '4':
            $column_index = 4;
            $cl_class = 'col-xs-12 col-sm-3 col-md-3';
            break;
        case '5':
            $column_index = 5;
            $cl_class = 'col-xs-12 col-sm-15 col-md-15';
            break;

        default:
            $cl_class = '';
            break;
    }
    $row_index = 1;
    switch ( $row ) {
        case '1':
            $row_index = 1;
            break;
        case '2':
            $row_index = 2;
            break;
        case '3':
            $row_index = 3;
            break;
        case '4':
            $row_index = 4;
            break;
        default:
            $row_index = 1;
            break;
    }
    ?>
    <div class="automatic-product-added automatic-product-list<?php echo $el_class; ?>">
        <?php
        if ( $title != '' ) : 
            ?>
						<div class="shortcode-title wpb_bottom-to-top">
                <h2><?php echo esc_attr( $title );?></h2>
            </div>
            <?php
        endif;
        if ( $cat_product == '' ) :
                $args = array(
                'post_type' => 'product',
                'post_status' => 'publish',
                'posts_per_page' => $items_show,
                'meta_key' => '_featured',
                'meta_value' => 'yes',
            );
        else :
            $term_id = get_term_by('slug', $cat_product, 'product_cat');
            $term_id = $term_id  -> term_id;
            $automatic_term_childs = get_term_children($term_id,'product_cat');
            $automatic_term_childs[] = $term_id;
            $args = array(
                'post_type' => 'product',
                'post_status' => 'publish',
                'posts_per_page' => $items_show,
                'meta_key' => '_featured',
                'meta_value' => 'yes',
                'tax_query' => array(
                    'relation' => 'AND',
                    array(
                        'taxonomy' => 'product_cat',
                        'field'    => 'term_id',
                        'terms'    => $automatic_term_childs,
                    ),
                ),
            );
        endif;
        
        $rquery = new Wp_Query($args);
        ?>
        <div class="slide-product-add" data-columns="<?php echo $column_index; ?>" data-rows="<?php echo $row_index; ?>">
            <div class="beans-stepslider" data-rotate="true">
                <div class="beans-mask">
                    <div class="beans-slideset">
                        <?php
                        if ( $rquery -> have_posts() ) :
                            while ( $rquery -> have_posts() ) : $rquery -> the_post();
                                ?>
                                <div class="beans-slide">
                                    <div class="padding-10">
                                        <?php au_content_product_list(); ?>
                                    </div>
                                </div>
                                <?php
                            endwhile;
                            wp_reset_postdata();
                        endif;
                        ?>
                    </div>
                </div>
                <a class="btn-prev" href="#"><i class="fa fa-angle-left"></i></a>
                <a class="btn-next" href="#"><i class="fa fa-angle-right"></i></a>
            </div>
        </div>
    </div>
    <?php
    return ob_get_clean();

}