<?php
/**
 * Map template
 */

add_shortcode( 'automatic_map', 'automatic_tp_map' );
function automatic_tp_map( $atts, $content=null ){
    extract( shortcode_atts(
        array(
            'google_map' => 'normal',
            'latitude' => 0,
            'longitude' => 0,
            'image'=>'',
            'name' => '',
            'content2' => '',
            'el_class' => '',
            'css' => '',
        ),$atts));
        $content = wpb_js_remove_wpautop( $content, true );
    ob_start();
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'automatic_map', $atts );
    $url_img = wp_get_attachment_url($image);
    $el_class = automatic_extract_class( $el_class );

    if ( $css_class != '' ){
        $el_class .= automatic_extract_class( $css_class );
    }
    ?>
    <div class="google-map automatic-map<?php echo $el_class;?> au_fadeIn">
        <div class="row">
            <div class="col-xs-12">
            <?php
                switch ( $google_map ) {
                    case 'normal':
                        ?>
                        <?php echo $content; ?>
                        <?php
                        break;
                    case 'other':
                        ?>
						<div class="automatic_map_api">
							<div class="map" data-lat="<?php echo $latitude; ?>" data-lng="<?php echo $longitude; ?>" data-zoom="15"></div>
							<div class="hide">
								<div class="map-info" data-image="<?php echo $url_img; ?>" >
									<h2><?php echo $name; ?></h2>
									<p><?php echo $content2; ?></p>
								</div>
                            </div>
                        </div>
                        <?php
                        break;
                    default:
                        # code...
                        break;
                }
            ?>
            </div>
        </div>
    </div>
    <?php
		$automatic_settings = automatic_settings();
		$automatic__styles = automatic_theme_styles();
		$automatic__scripts = automatic_theme_scripts();
		if(isset($automatic_settings['mapapi']) && $automatic_settings['mapapi']!=''){
			wp_enqueue_script('automatic-map',$automatic__scripts['map'] ,array( 'jquery' ), '1.0', true);
			wp_enqueue_script('maps-api', 'https://maps.googleapis.com/maps/api/js?key='.esc_attr($automatic_settings['mapapi']).'&callback=initGoogleMap',array( 'jquery' ), '', true);
		}
    return ob_get_clean();
}