<?php
/**
 * Icon Advanced
 */

add_shortcode( 'automatic_icon', 'automatic_tp_icon' );
function automatic_tp_icon( $atts, $content=null ){
    extract( shortcode_atts(
        array(
            'layout'=>'default',
            'values'=>'',
            'title' => '',
            'type_icon' => 'font-icon',
            'icon_font' => '',
            'image'=>'',
            'size' => 'md',
            'align' => 'text-left',
            'css_animation' => '',
            'el_class' => '',
            'css' => '',
        ),$atts));
        $content = wpb_js_remove_wpautop( $content, true );
    ob_start();
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'automatic_icon', $atts );

    $html_icon ='';
    if ( $icon_font ){
        $font_icon = $icon_font;
        $html_icon = '<i class="'.esc_attr( $font_icon ).'"></i>';
    }

    $css_class_anm = automatic_getCSSAnimation( $css_animation );
    $el_class = automatic_extract_class( $el_class );
    if ( $css_class != '' ){
        $el_class .= automatic_extract_class( $css_class );
    }
    if ( $css_class_anm != '' ){
        $el_class .= ' '.$css_class_anm;
    }
    ?>
    <div class="automatic-icon<?php echo $el_class.' '.$layout; ?> au_fadeIn">
        <div class="<?php echo $align;?> icon-size-<?php echo $size;?>">
            <?php if ( $layout == 'default' ) : ?>
                <div class="icon">
                    <?php if ( $type_icon == 'font-icon' && $html_icon != '' ): ?>
                        <span class="icon">
                            <?php echo $html_icon;?>
                        </span>
                    <?php endif; ?>
                    <?php
                    if ( $type_icon == 'image' ):
                        if ( $image !='' ):
                            $images = wp_get_attachment_image_src( $image, 'full' );
                            ?>
                            <img alt="icon" src="<?php echo $images[0]; ?>">
                            <?php
                        endif;
                    endif;
                    ?>
                    <?php if ( $title !='' ) : ?>
                        <h4 class="title-icon"><?php echo esc_attr( $title );?></h4>
                    <?php endif; ?>
                </div>
                <div class="box-content">

                    <div><?php echo $content; ?></div>
                </div>
            <?php else :
                $values = (array) vc_param_group_parse_atts( $values );
                echo '<div class="line-row">';
                    $i=0;
                    foreach ( $values as $data ) {
                        $i++;
                        $new_line = $data;
                        $new_line['type_icon'] = isset( $data['type_icon'] ) ? $data['type_icon'] : '';
                        $new_line['title'] = isset( $data['title'] ) ? $data['title'] : '';
                        $new_line['content'] = isset( $data['content'] ) ? $data['content'] : '';
                        $new_line['icon_font'] = isset( $data['icon_font'] ) ? $data['icon_font'] : '';
                        $new_line['image'] = isset( $data['image'] ) ? $data['image'] : '';
                        $html_icon ='';
                        if ( $new_line['icon_font'] ){
                            $html_icon = '<i class="'.esc_attr( $new_line['icon_font'] ).'"></i>';
                        }
                        ?>
                        <div class="border col-xs-15 col-sm-15 col-md-15 col-lg-15 col-xl-15 <?php if($i==1) echo 'first'; ?>">
                            <div class="icon">
                                <?php if ( $new_line['type_icon'] == 'font-icon' && $html_icon != '' ): ?>
                                    <span class="icon">
                                        <?php echo $html_icon;?>
                                    </span>
                                <?php endif; ?>
                                <?php
                                if ( $new_line['type_icon'] == 'image' ):
                                    if ( $new_line['image'] !='' ):
                                        $images = wp_get_attachment_image_src( $new_line['image'], 'full' );
                                        ?>
                                        <img alt="icon" src="<?php echo $images[0]; ?>">
                                        <?php
                                    endif;
                                endif;
                                ?>
                            </div>
                            <div class="box-content">
                                <?php if ( $new_line['title'] !='' ) : ?>
                                    <h4 class="title-icon"><?php echo esc_attr( $new_line['title'] );?></h4>
                                <?php endif; ?>
                                <div><?php echo $new_line['content']; ?></div>
                            </div>
                        </div>
                    <?php
                    }
                ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <?php
    return ob_get_clean();
}