<?php
add_action('vc_build_admin_page', 'automatic_shortcode_testimonial');
add_action( 'vc_before_init', 'automatic_shortcode_testimonial' );

function automatic_shortcode_testimonial() {
    $link_category = array( esc_html__( 'Select...', 'js_composer' ) => '' );
    $link_cats = get_terms( 'testimonial_cat' );
    if ( is_array( $link_cats ) && ! empty( $link_cats ) ) {
        foreach ( $link_cats as $link_cat ) {
            if ( is_object( $link_cat ) && isset( $link_cat->name, $link_cat->term_id ) ) {
                $link_category[ $link_cat->name ] = $link_cat->term_id;
            }
        }
    }
    vc_map( array(
        'name' => esc_html__( '[Automatic] Testimonial', 'automatic_sc' ),
        'base' => 'automatic_testimonial',
        'icon' => 'automatic_vc_icon',
        'category' =>'Automatic',
        'description' => esc_html__( 'List item(s) testimonial', 'automatic_sc' ),
        'params' => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'automatic_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( 'Widget Title.', 'automatic_sc' ),
                'admin_label' => true,
            ),
            array(
                "type" => "number",
                "class" => "",
                "heading" => esc_html__("Number item", "automatic"),
                "param_name" => "items_show",
                "value" => -1,
                "suffix" => "item(s)",
                "description" => esc_html__("select item show. note: value -1 if show all item.", "automatic"),
                'dependency' => array(
                    'element' => 'layout_blog',
                    'value' => array('default','slide')
                )
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'automatic_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'automatic_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'automatic_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'automatic_sc' ),
            ),
        )
    ) );
}