<?php
add_action('vc_build_admin_page', 'automatic_shortcode_team');
add_action( 'vc_before_init', 'automatic_shortcode_team' );

function automatic_shortcode_team() {
    vc_map( array(
        "name" => esc_html__( "[Automatic] Team", "automatic" ),
        "base" => "automatic_team",
        'icon' => 'automatic_vc_icon',
        "category" => "Automatic",
        "description" => esc_html__( 'Show item team.','automatic_sc' ),
        "params" => array(
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Type Team', 'automatic_sc' ),
                'param_name' => 'layout',
                'value' => array(
                    esc_html__( 'Team with Short Info', 'automatic_sc' ) => 'layout1',
                    esc_html__( 'Team with All Info', 'automatic_sc' ) => 'layout2',
                ),
                'description' => esc_html__( 'Select type for team.', 'automatic_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'automatic_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( 'Widget Title.', 'automatic_sc' ),
                'admin_label' => true,
            ),
            array(
                "type" => "number",
                "heading" => esc_html__("Number item", "automatic"),
                "param_name" => "items_show",
                "value" => -1,
                "suffix" => "item(s)",
                'dependency' => array(
                    'element' => 'layout',
                    'value' => 'layout2'
                ),
                "description" => esc_html__("select item show. note: value -1 if show all item.", "automatic"),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Column', 'automatic_sc' ),
                'param_name' => 'column',
                'value' => array(
                    esc_html__( '1 column', 'automatic_sc' ) => '1',
                    esc_html__( '2 column', 'automatic_sc' ) => '2',
                    esc_html__( '3 column', 'automatic_sc' ) => '3',
                    esc_html__( '4 column', 'automatic_sc' ) => '4',
                    esc_html__( '5 column', 'automatic_sc' ) => '5',
                ),
                'dependency' => array(
                    'element' => 'layout',
                    'value' => 'layout2'
                ),
                'description' => esc_html__( 'Layout column product.', 'automatic_sc' ),
            ),
            array(
                'type' => 'vc_link',
                'heading' => esc_html__( 'URL (Link)', 'automatic_sc' ),
                'param_name' => 'link',
                'dependency' => array(
                    'element' => 'layout',
                    'value' => 'layout1'
                ),
                'description' => esc_html__( 'Add link to button..', 'automatic_sc' ),
            ),
            vc_map_add_css_animation(),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'automatic_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'automatic_sc' )
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'Css','automatic_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Option','automatic_sc' ),
            )
        )
    ));
}