<?php
add_shortcode('automatic_static_block', 'automatic_shortcode_static_block');
add_action('vc_build_admin_page', 'automatic_load_static_block_shortcode');
add_action('vc_after_init', 'automatic_load_static_block_shortcode');

function automatic_shortcode_static_block($atts, $content = null) {
    ob_start();
    if ($template = automatic_shortcode_template('automatic_static_block'))
        include $template;
    return ob_get_clean();
}

function automatic_load_static_block_shortcode() {
    $custom_class = automatic_vc_custom_class();
    $block_options = array();
    $block_options[0] = __('Choose a block to display', 'automatic_sc');
    $args = array(
        'numberposts'       => -1,
        'post_type'         => 'block',
        'post_status'       => 'publish',
    );
    $posts = get_posts($args);
    foreach( $posts as $_post ){
        $block_options[$_post->post_title] = $_post->post_title;
    }
    vc_map( array(
        'name' => "[Automatic] " . __('Static Block', 'automatic_sc'),
        'base' => 'automatic_static_block',
        'category' => 'Automatic',
        'icon' => 'automatic_vc_icon',
        'weight' => - 50,
        "params" => array(
            array(
                "type" => "dropdown",
                "heading" => __("Static Block", 'automatic_sc'),
                "param_name" => "static",
                'value' =>  $block_options,
                "admin_label" => true
            ),
            $custom_class
        )
    ));

    if (!class_exists('WPBakeryShortCode_automatic_Static_Block')) {
        class WPBakeryShortCode_automatic_Static_Block extends WPBakeryShortCode {
        }
    }
}