<?php
add_action('vc_build_admin_page', 'automatic_shortcode_slide_banner');
add_action( 'vc_before_init', 'automatic_shortcode_slide_banner' );
function automatic_shortcode_slide_banner() {
    vc_map( array(
        "name" => esc_html__( "[Automatic] Banner Slide", "automatic" ),
        "base" => "automatic_banner_slide",
        "class" => "",
        'icon' => 'automatic_vc_icon',
        "category" => "Automatic",
        "description" => esc_html__( 'Slide show image banner','automatic_sc' ),
        "params" => array(
            array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Values', 'automatic_sc' ),
                'param_name' => 'values',
                'description' => esc_html__( 'Enter banner images.', 'automatic_sc' ),
                'value' => urlencode( json_encode( array(
                    array(
                        'title' => esc_html__( 'Banner 1', 'automatic_sc' ),
                    ),
                    array(
                        'title' => esc_html__( 'Banner 2', 'automatic_sc' ),
                    ),
                    array(
                        'title' => esc_html__( 'Banner 3', 'automatic_sc' ),
                    ),
                ) ) ),
                'params' => array(
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Title', 'automatic_sc' ),
                        'param_name' => 'title',
                        'description' => esc_html__( 'Title slide banner', 'automatic_sc' ),
                        'admin_label' => true,
                    ),
                    array(
                        'type' => 'attach_image',
                        'param_name' =>'image',
                        'heading' => esc_html__( 'Image','automatic_sc' ),
                        'value' => '',
                        'description' => esc_html__( 'Select banner image','automatic_sc' ),
                    ),
                    array(
                        'type' => 'vc_link',
                        'heading' => esc_html__( 'URL (Link) banner', 'automatic_sc' ),
                        'param_name' => 'link',
                        'description' => esc_html__( 'Add custom link to page.', 'automatic_sc' ),
                    ),
                ),
            ),

            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'automatic_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'automatic_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'automatic_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'automatic_sc' ),
            ),
        )
    ));
}