<?php
add_action('vc_build_admin_page', 'automatic_shortcode_blog');
add_action( 'vc_before_init', 'automatic_shortcode_blog' );
function automatic_shortcode_blog(){
    vc_map( array(
        "name" => esc_html__( "[Automatic] Recent Blog", "automatic" ),
        "base" => "automatic_blog",
        "icon" => "automatic_vc_icon",
        "category" => "Automatic",
        "description" => esc_html__( 'List item blog','automatic_sc' ),
        "params" => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'automatic_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( 'Widget Title.', 'automatic_sc' ),
                'admin_label' => true,
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Type', 'automatic_sc' ),
                'param_name' => 'layout_blog',
                'value' => array(
                    esc_html__( 'List', 'automatic_sc' ) => 'list',
                    esc_html__( 'Slide', 'automatic_sc' ) => 'slide',
                ),
                'description' => esc_html__( 'Type post show.ex:slide or list.', 'automatic_sc' ),
            ),
            array(
                "type" => "number",
                "class" => "",
                "heading" => esc_html__("Number item", "automatic"),
                "param_name" => "items_show",
                "value" => -1,
                "suffix" => "item(s)",
                "description" => esc_html__("select item show. note: value -1 if show all item.", "automatic"),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'automatic_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'automatic_sc' )
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'Css','automatic_sc'),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Option','automatic_sc' ),
            )

        ),
    ));
}