<?php
add_action('vc_build_admin_page', 'automatic_shortcode_product_dailydeal');
add_action( 'vc_before_init', 'automatic_shortcode_product_dailydeal' );

function automatic_shortcode_product_dailydeal() {
    vc_map( array(
        'name' => esc_html__( '[Automatic] Product Dailydeals', 'automatic_sc' ),
        'base' => 'automatic_product_dailydeal',
        'icon' => 'automatic_vc_icon',
        'category' =>'Automatic',
        'description' => esc_html__( 'List item(s) product dailydeals', 'automatic_sc' ),
        'params' => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'automatic_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( 'Widget Title.', 'automatic_sc' ),
                'admin_label' => true,
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Layout Product Show', 'automatic_sc' ),
                'param_name' => 'layout',
                'value' => array(
                    esc_html__( 'Default', 'automatic_sc' ) => 'default',
                    esc_html__( 'Layout 1', 'automatic_sc' ) => 'layout1',
                    esc_html__( 'Layout 2', 'automatic_sc' ) => 'layout2',
                ),
                'description' => esc_html__( 'Type product daily deals show.', 'automatic_sc' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Product Offers Type', 'automatic_sc' ),
                'param_name' => 'type_offer',
                'value' => array(
                    esc_html__( 'Default', 'automatic_sc' ) => 'default',
                    esc_html__( 'Type 1', 'automatic_sc' ) => 'type1',
                    esc_html__( 'Type 2', 'automatic_sc' ) => 'type2',
                ),
                'description' => esc_html__( 'Type product daily deals show.', 'automatic_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Product Special Offers by Price', 'automatic_sc' ),
                'param_name' => 'offer_price',
                'description' => esc_html__( 'Enter value price offer. ex: 30', 'automatic_sc' ),
                'dependency' => array(
                    'element' =>'type_offer',
                    'value' => 'type1',
                )
            ),
            array(
                "type" => "datetimepicker",
                "class" => "",
                "heading" => esc_html__("Product Special Offers by Date", "automatic"),
                "param_name" => "offer_date",
                "value" => "",
                "description" => esc_html__("Date and time format (yyyy/mm/dd hh:mm:ss).", "automatic"),
                'dependency' => array(
                    'element' =>'type_offer',
                    'value' => 'type2',
                )
            ),
            array(
                "type" => "number",
                "heading" => esc_html__("Number item", "automatic"),
                "param_name" => "items_show",
                "value" => -1,
                "suffix" => "item(s)",
                "description" => esc_html__("select item show. note: value -1 if show all item.", "automatic"),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Column', 'automatic_sc' ),
                'param_name' => 'column',
                'value' => array(
                    esc_html__( '1 column', 'automatic_sc' ) => '1',
                    esc_html__( '2 column', 'automatic_sc' ) => '2',
                    esc_html__( '3 column', 'automatic_sc' ) => '3',
                    esc_html__( '4 column', 'automatic_sc' ) => '4',
                    esc_html__( '5 column', 'automatic_sc' ) => '5',
                ),
                'description' => esc_html__( 'Layout column product.', 'automatic_sc' ),
            ),
            array(
                'type' => 'vc_link',
                'heading' => esc_html__( 'URL (Link) View More', 'automatic_sc' ),
                'param_name' => 'link',
                'dependency' => array(
                    'element' =>'type_offer',
                    'value' => 'type2',
                ),
                'description' => esc_html__( 'Add custom link to other page.', 'automatic_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'automatic_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'automatic_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'automatic_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'automatic_sc' ),
            ),
        )
    ) );
}