<?php
add_action('vc_build_admin_page', 'automatic_shortcode_product');
add_action( 'vc_before_init', 'automatic_shortcode_product' );

function automatic_shortcode_product() {
    $layout = array( esc_html__( 'All Links', 'automatic_sc' ) => '' );
    $link_cats = get_terms( 'product_cat' );
    if ( is_array( $link_cats ) && ! empty( $link_cats ) ) {
        foreach ( $link_cats as $link_cat ) {
            if ( is_object( $link_cat ) && isset( $link_cat->name, $link_cat->term_id ) ) {
                $layout[ $link_cat->name ] = $link_cat->slug;
            }
        }
    }
    $list_item = array( esc_html__( 'Select item', 'automatic_sc' ) => '' );
    $args = array(
        'post_type' => "product",
        'posts_per_page' => -1,
        'orderby' => 'title',
        'order'   => 'ASC'
    );
    $rquery = New Wp_Query( $args );
    if ( $rquery->have_posts() ) :
        while( $rquery->have_posts() ) : $rquery-> the_post();
            global $post;
            $list_item[ get_the_title().'('.$post->post_name.')' ] = get_the_ID();
        endwhile;
    endif;
    vc_map( array(
        'name' => esc_html__( '[Automatic] Product', 'automatic_sc' ),
        'base' => 'automatic_product',
        'icon' => 'automatic_vc_icon',
        'category' =>'Automatic',
        'description' => esc_html__( 'List item(s) product', 'automatic_sc' ),
        'params' => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'automatic_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( 'Widget Title.', 'automatic_sc' ),
                'admin_label' => true,
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Product Show', 'automatic_sc' ),
                'param_name' => 'type_product',
                'value' => array(
                    esc_html__( 'New Product', 'automatic_sc' ) => 'new-product',
                    esc_html__( 'Sale Product', 'automatic_sc' ) => 'sale-product',
                    esc_html__( 'Featured Product', 'automatic_sc' ) => 'feature-product',
                    esc_html__( 'Top Rated Product', 'automatic_sc' ) => 'top-rated-product',
                    esc_html__( 'Bestselling Product', 'automatic_sc' ) => 'bestselling-product',
                    esc_html__( 'Gift Card Product', 'automatic_sc' ) => 'gift-card-product',
                    esc_html__( 'Single Product', 'automatic_sc' ) => 'single-product',
                ),
                'description' => esc_html__( 'Type product show.ex:porpular,best sale...', 'automatic_sc' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Type', 'automatic_sc' ),
                'param_name' => 'type_layout',
                'value' => array(
                    esc_html__( 'Default', 'automatic_sc' ) => 'default',
                    esc_html__( 'Grid Product', 'automatic_sc' ) => 'layout-grid',
                    esc_html__( 'List Product', 'automatic_sc' ) => 'layout-1',
                ),
                'description' => esc_html__( 'Select type show item product. Default type is slider.', 'automatic_sc' ),
                'dependency' => array(
                    'element' => 'type_product',
                    'value' => array('new-product','sale-product','feature-product','top-rated-product')
                ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Style', 'automatic_sc' ),
                'param_name' => 'style',
                'value' => array(
                    esc_html__( 'Default', 'automatic_sc' ) => 'default',
                    esc_html__( 'Style 1', 'automatic_sc' ) => 'style-1',
                ),
                'description' => esc_html__( 'Select type style.', 'automatic_sc' ),
            ),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Product", "automatic"),
                "param_name" => "item",
                "value" => $list_item,
                'description' => esc_html__( 'Select product you would like to use', 'automatic_sc' ),
                'dependency' => array(
                    'element' => 'type_product',
                    'value' => 'single-product',
                ),
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Group", "automatic"),
                "param_name" => "cat_product",
                "value" => $layout,
                'description' => esc_html__( 'Select taxonomy layout you would like to use', 'automatic_sc' ),
            ),
            array(
                "type" => "number",
                "heading" => esc_html__("Number item", "automatic"),
                "param_name" => "items_show",
                "value" => -1,
                "suffix" => "item(s)",
                "description" => esc_html__("select item show. note: value -1 if show all item.", "automatic"),
            ),
            array(
							'type' => 'dropdown',
							'heading' => esc_html__( 'Column', 'automatic_sc' ),
							'param_name' => 'column',
							'value' => array(
								esc_html__( '1 column', 'automatic_sc' ) => '1',
								esc_html__( '2 column', 'automatic_sc' ) => '2',
								esc_html__( '3 column', 'automatic_sc' ) => '3',
								esc_html__( '4 column', 'automatic_sc' ) => '4',
								esc_html__( '5 column', 'automatic_sc' ) => '5',
							),
							'dependency' => array(
								'element' => 'type_product',
								'value' => array('new-product','sale-product','feature-product','top-rated-product','bestselling-product','gift-card-product')
							),
							'description' => esc_html__( 'Layout column product.', 'automatic_sc' ),
            ),
            array(
							'type' => 'ult_switch',
							"heading" => esc_html__( "Show Navigation", "automatic" ),
							"param_name" => "show_nav",
							'value' => '',
							'options' => array(
								'enable_show_nav' => array(
									'label' => '',
									'on' => esc_html__('Yes','ultimate_vc'),
									'off' => esc_html__('No','ultimate_vc')
								)
							),
							'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
							'description' =>esc_html__( 'if enable, show navigation builet.','automatic_sc' ),
							'dependency' => array(
								'element' => 'type_product',
								'value' => array('new-product','sale-product','feature-product','top-rated-product','bestselling-product','gift-card-product')
							)
            ),
            array(
							"type" => "ult_switch",
							"heading" => esc_html__( "Show Navigation Button", "automatic" ),
							"param_name" => "show_navbt",
							'value' => '',
							'options' => array(
								'enable_show_navbt' => array(
									'label' => '',
									'on' => esc_html__('Yes','ultimate_vc'),
									'off' => esc_html__('No','ultimate_vc')
								)
							),
							'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
							'description' =>esc_html__( 'if enable, show nav button next, prev.','automatic_sc' ),
							'dependency' => array(
								'element' => 'type_product',
								'value' => array('new-product','sale-product','feature-product','top-rated-product','bestselling-product','gift-card-product')
							)
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'automatic_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'automatic_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'automatic_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'automatic_sc' ),
            ),
        )
    ) );
}