<?php
/**
 * Add field shortcode vc_icon
 * @var array
 */

/*Shortcode Toogle*/
function vc_tta_toggle($atts, $content){
    extract( shortcode_atts( array(
            'title' => '',
            'tab_id' => '',
            'tab_index' => '',
        ), $atts ) );
    ob_start();
?>
    <div class="panel-heading" id="heading<?php echo $atts['tab_id']?>">
        <h4 class="panel-title">
            <a role="button" data-toggle="collapse" data-parent="#accordion" href="#collapse<?php echo $atts['tab_id']?>" aria-controls="collapse<?php echo $atts['tab_id']?>">
                <?php echo $atts['title']?>
            </a>
        </h4>
    </div>
    <div id="collapse<?php echo $atts['tab_id']?>" class="panel-collapse collapse" role="tabpanel" aria-labelledby="heading<?php echo $atts['tab_id']?>">
        <div class="panel-body">
            <?php echo do_shortcode($content); ?>
        </div>
    </div>
<?php
    return ob_get_clean();
}
add_shortcode( 'vc_tta_toggle', 'vc_tta_toggle' );


add_action( 'vc_after_init', 'automatic_vc_row' );
function automatic_vc_row(){
    $attr_rowsetting = array(
        array(
            "type" => "checkbox",
            "class" => "",
            "heading" => esc_html__("Content In Container", "automatic"),
            "param_name" => "incontainer",
            'value' => array( esc_html__( 'Yes', 'automatic_sc' ) => 'yes' ),
            "description" => esc_html__("Box content with custom style.", "automatic"),
            'group' => 'Design Options',
        ),
        array(
            'type' => 'ult_switch',
            "heading" => esc_html__( "Background fixed", "automatic" ),
            "param_name" => "bg_fixed",
            'value' => '',
            'options' => array(
                'enable_bg_fixed' => array(
                    'label' => '',
                    'on' => esc_html__('Yes','ultimate_vc'),
                    'off' => esc_html__('No','ultimate_vc')
                )
            ),
            'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
            'description' =>esc_html__( 'if enable, background row will fixed.','automatic_sc' ),
            'group' => 'Design Options',
        ),
        array(
            "type" => "ult_switch",
            "heading" => esc_html__( "Background width color opacity", "automatic" ),
            "param_name" => "bg_color_opacity",
            'value' => '',
            'options' => array(
                'enable_color_opacity' => array(
                    'label' => '',
                    'on' => esc_html__('Yes','ultimate_vc'),
                    'off' => esc_html__('No','ultimate_vc')
                )
            ),
            'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
            'description' =>esc_html__( 'if enable, background row will fixed.','automatic_sc' ),
            'group' => 'Design Options',
        ),
        array(
            'type' => 'colorpicker',
            'param_name' =>'color_op',
            'heading' => esc_html__( 'Background color','automatic_sc' ),
            'value' => '',
            'description' => esc_html__( 'select color for background','automatic_sc' ),
            'dependency' => array(
                'element' => 'bg_color_opacity',
                'value' => array('enable_color_opacity')
            ),
            'group' => 'Design Options',
        ),
    );
    vc_add_params( 'vc_row', $attr_rowsetting );
}

/**
 * Include file shortcode
 */
class automatic_VcSharedLibrary {
    // Here we will store plugin wise (shared) settings. Colors, Locations, Sizes, etc...
    /**
     * @var array
     */
    private static $colors = array(
        'Blue' => 'blue',
        'Turquoise' => 'turquoise',
        'Pink' => 'pink',
        'Violet' => 'violet',
        'Peacoc' => 'peacoc',
        'Chino' => 'chino',
        'Mulled Wine' => 'mulled_wine',
        'Vista Blue' => 'vista_blue',
        'Black' => 'black',
        'Grey' => 'grey',
        'Orange' => 'orange',
        'Sky' => 'sky',
        'Green' => 'green',
        'Juicy pink' => 'juicy_pink',
        'Sandy brown' => 'sandy_brown',
        'Purple' => 'purple',
        'White' => 'white'
    );

    /**
     * @var array
     */
    public static $icons = array(
        'Glass' => 'glass',
        'Music' => 'music',
        'Search' => 'search'
    );

    /**
     * @var array
     */
    public static $sizes = array(
        'Mini' => 'xs',
        'Small' => 'sm',
        'Normal' => 'md',
        'Large' => 'lg'
    );

    /**
     * @var array
     */
    public static $button_styles = array(
        'Rounded' => 'rounded',
        'Square' => 'square',
        'Round' => 'round',
        'Outlined' => 'outlined',
        '3D' => '3d',
        'Square Outlined' => 'square_outlined'
    );

    /**
     * @var array
     */
    public static $message_box_styles = array(
        'Standard' => 'standard',
        'Solid' => 'solid',
        'Solid icon' => 'solid-icon',
        'Outline' => 'outline',
        '3D' => '3d',
    );

    /**
     * Toggle styles
     * @var array
     */
    public static $toggle_styles = array(
        'Default' => 'default',
        'Simple' => 'simple',
        'Round' => 'round',
        'Round Outline' => 'round_outline',
        'Rounded' => 'rounded',
        'Rounded Outline' => 'rounded_outline',
        'Square' => 'square',
        'Square Outline' => 'square_outline',
        'Arrow' => 'arrow',
        'Text Only' => 'text_only',
    );

    /**
     * Animation styles
     * @var array
     */
    public static $animation_styles = array(
        'Bounce' => 'easeOutBounce',
        'Elastic' => 'easeOutElastic',
        'Back' => 'easeOutBack',
        'Cubic' => 'easeinOutCubic',
        'Quint' => 'easeinOutQuint',
        'Quart' => 'easeOutQuart',
        'Quad' => 'easeinQuad',
        'Sine' => 'easeOutSine'
    );

    /**
     * @var array
     */
    public static $cta_styles = array(
        'Rounded' => 'rounded',
        'Square' => 'square',
        'Round' => 'round',
        'Outlined' => 'outlined',
        'Square Outlined' => 'square_outlined'
    );

    /**
     * @var array
     */
    public static $txt_align = array(
        'Left' => 'left',
        'Right' => 'right',
        'Center' => 'center',
        'Justify' => 'justify'
    );

    /**
     * @var array
     */
    public static $el_widths = array(
        '100%' => '',
        '90%' => '90',
        '80%' => '80',
        '70%' => '70',
        '60%' => '60',
        '50%' => '50',
        '40%' => '40',
        '30%' => '30',
        '20%' => '20',
        '10%' => '10'
    );

    /**
     * @var array
     */
    public static $sep_widths = array(
        '1px' => '',
        '2px' => '2',
        '3px' => '3',
        '4px' => '4',
        '5px' => '5',
        '6px' => '6',
        '7px' => '7',
        '8px' => '8',
        '9px' => '9',
        '10px' => '10'
    );

    /**
     * @var array
     */
    public static $sep_styles = array(
        'Border' => '',
        'Dashed' => 'dashed',
        'Dotted' => 'dotted',
        'Double' => 'double'
    );

    /**
     * @var array
     */
    public static $box_styles = array(
        'Default' => '',
        'Rounded' => 'vc_box_rounded',
        'Border' => 'vc_box_border',
        'Outline' => 'vc_box_outline',
        'Shadow' => 'vc_box_shadow',
        'Bordered shadow' => 'vc_box_shadow_border',
        '3D Shadow' => 'vc_box_shadow_3d'
    );

    /**
     * Round box styles
     *
     * @var array
     */
    public static $round_box_styles = array(
        'Round' => 'vc_box_circle',
        'Round Border' => 'vc_box_border_circle',
        'Round Outline' => 'vc_box_outline_circle',
        'Round Shadow' => 'vc_box_shadow_circle',
        'Round Border Shadow' => 'vc_box_shadow_border_circle'
    );

    /**
     * Circle box styles
     *
     * @var array
     */
    public static $circle_box_styles = array(
        'Circle' => 'vc_box_circle_2',
        'Circle Border' => 'vc_box_border_circle_2',
        'Circle Outline' => 'vc_box_outline_circle_2',
        'Circle Shadow' => 'vc_box_shadow_circle_2',
        'Circle Border Shadow' => 'vc_box_shadow_border_circle_2'
    );

    /**
     * @return array
     */
    public static function getColors() {
        return self::$colors;
    }

    /**
     * @return array
     */
    public static function getIcons() {
        return self::$icons;
    }

    /**
     * @return array
     */
    public static function getSizes() {
        return self::$sizes;
    }

    /**
     * @return array
     */
    public static function getButtonStyles() {
        return self::$button_styles;
    }

    /**
     * @return array
     */
    public static function getMessageBoxStyles() {
        return self::$message_box_styles;
    }

    /**
     * @return array
     */
    public static function getToggleStyles() {
        return self::$toggle_styles;
    }

    /**
     * @return array
     */
    public static function getAnimationStyles() {
        return self::$animation_styles;
    }

    /**
     * @return array
     */
    public static function getCtaStyles() {
        return self::$cta_styles;
    }

    /**
     * @return array
     */
    public static function getTextAlign() {
        return self::$txt_align;
    }

    /**
     * @return array
     */
    public static function getBorderWidths() {
        return self::$sep_widths;
    }

    /**
     * @return array
     */
    public static function getElementWidths() {
        return self::$el_widths;
    }

    /**
     * @return array
     */
    public static function getSeparatorStyles() {
        return self::$sep_styles;
    }

    /**
     * Get list of box styles
     *
     * Possible $groups values:
     * - default
     * - round
     * - circle
     *
     * @param array $groups Array of groups to include. If not specified, return all
     *
     * @return array
     */
    public static function getBoxStyles( $groups = array() ) {
        $list = array();
        $groups = (array) $groups;

        if ( ! $groups || in_array( 'default', $groups ) ) {
            $list += self::$box_styles;
        }

        if ( ! $groups || in_array( 'round', $groups ) ) {
            $list += self::$round_box_styles;
        }

        if ( ! $groups || in_array( 'cirlce', $groups ) ) {
            $list += self::$circle_box_styles;
        }

        return $list;
    }

    public static function getColorsDashed() {
        $colors = array(
            esc_html__( 'Blue', 'automatic_sc' ) => 'blue',
            esc_html__( 'Turquoise', 'automatic_sc' ) => 'turquoise',
            esc_html__( 'Pink', 'automatic_sc' ) => 'pink',
            esc_html__( 'Violet', 'automatic_sc' ) => 'violet',
            esc_html__( 'Peacoc', 'automatic_sc' ) => 'peacoc',
            esc_html__( 'Chino', 'automatic_sc' ) => 'chino',
            esc_html__( 'Mulled Wine', 'automatic_sc' ) => 'mulled-wine',
            esc_html__( 'Vista Blue', 'automatic_sc' ) => 'vista-blue',
            esc_html__( 'Black', 'automatic_sc' ) => 'black',
            esc_html__( 'Grey', 'automatic_sc' ) => 'grey',
            esc_html__( 'Orange', 'automatic_sc' ) => 'orange',
            esc_html__( 'Sky', 'automatic_sc' ) => 'sky',
            esc_html__( 'Green', 'automatic_sc' ) => 'green',
            esc_html__( 'Juicy pink', 'automatic_sc' ) => 'juicy-pink',
            esc_html__( 'Sandy brown', 'automatic_sc' ) => 'sandy-brown',
            esc_html__( 'Purple', 'automatic_sc' ) => 'purple',
            esc_html__( 'White', 'automatic_sc' ) => 'white'
        );

        return $colors;
    }
}
/**
 * @param string $asset
 *
 * @return array
 */
function automatic_getVcShared( $asset = '' ) {
    switch ( $asset ) {
        case 'colors':
            return automatic_VcSharedLibrary::getColors();
            break;

        case 'colors-dashed':
            return automatic_VcSharedLibrary::getColorsDashed();
            break;

        case 'icons':
            return automatic_VcSharedLibrary::getIcons();
            break;

        case 'sizes':
            return automatic_VcSharedLibrary::getSizes();
            break;

        case 'button styles':
        case 'alert styles':
            return automatic_VcSharedLibrary::getButtonStyles();
            break;
        case 'message_box_styles':
            return automatic_VcSharedLibrary::getMessageBoxStyles();
            break;
        case 'cta styles':
            return automatic_VcSharedLibrary::getCtaStyles();
            break;

        case 'text align':
            return automatic_VcSharedLibrary::getTextAlign();
            break;

        case 'cta widths':
        case 'separator widths':
            return automatic_VcSharedLibrary::getElementWidths();
            break;

        case 'separator styles':
            return automatic_VcSharedLibrary::getSeparatorStyles();
            break;

        case 'separator border widths':
            return automatic_VcSharedLibrary::getBorderWidths();
            break;

        case 'single image styles':
            return automatic_VcSharedLibrary::getBoxStyles();
            break;

        case 'single image external styles':
            return automatic_VcSharedLibrary::getBoxStyles( array( 'default', 'round' ) );
            break;

        case 'toggle styles':
            return automatic_VcSharedLibrary::getToggleStyles();
            break;

        case 'animation styles':
            return automatic_VcSharedLibrary::getAnimationStyles();
            break;

        default:
            # code...
            break;
    }

    return '';
}