<?php
add_action('vc_build_admin_page', 'automatic_shortcode_map');
add_action( 'vc_before_init', 'automatic_shortcode_map' );

function automatic_shortcode_map() {
    vc_map(
        array(
           "name" => esc_html__("[Automatic] Map","automatic"),
           "base" => "automatic_map",
           "class" => "automatic_map",
           "icon" => "automatic_vc_icon",
           "category" => "Automatic",
           "description" => esc_html__("Google map.","automatic"),
           "params" => array(
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__( 'Layout map', 'automatic_sc' ),
                    'param_name' => 'google_map',
                    'value' => array(
                        esc_html__( 'Normal', 'automatic_sc' ) => 'normal',
                        esc_html__( 'Map with Latitude and Longitude', 'automatic_sc' ) => 'other'
                    ),
                    'description' => esc_html__( 'Select type map.', 'automatic_sc' ),
                ),
                array(
                    "type" => "textarea_html",
                    "holder" => "div",
                    "class" => "",
                    "heading" => esc_html__( "Iframe", "automatic" ),
                    "param_name" => "content",
                    "value" => esc_html__( "", "automatic" ),
                    "description" => esc_html__( "Enter iframe map google.", "automatic" ),
                    'dependency' => array(
                        'element' => 'google_map',
                        'value' => 'normal',
                    ),
                ),
                array(
                    "type" => "number",
                    "class" => "",
                    "heading" => esc_html__("Latitude", "automatic"),
                    "param_name" => "latitude",
                    "value" => 0,
                    "min" => 0,
                    "suffix" => "",
                    "description" => esc_html__("Enter value latitude.", "automatic"),
                    'dependency' => array(
                        'element' => 'google_map',
                        'value' => 'other',
                    ),
                ),
                array(
                    "type" => "number",
                    "class" => "",
                    "heading" => esc_html__("Longitude", "automatic"),
                    "param_name" => "longitude",
                    "value" => 0,
                    "min" => 0,
                    "suffix" => "",
                    "description" => esc_html__("Enter value longitude.", "automatic"),
                    'dependency' => array(
                        'element' => 'google_map',
                        'value' => 'other',
                    ),
                ),
                array(
                    "type" => "attach_image",
                    "class" => "",
                    "heading" => esc_html__("Image",  "automatic"),
                    "param_name" => "image",
                    "value" => "",
                    "description" => esc_html__("Image marker.",  "automatic"),
                    'dependency' => array(
                        'element' => 'google_map',
                        'value' => 'other',
                    ),
                ),
                array(
                    "type" => "textfield",
                    "class" => "",
                    "heading" => esc_html__("Name",  "automatic"),
                    "param_name" => "name",
                    "value" => "",
                    "description" => esc_html__("Name map .", "automatic"),
                    'dependency' => array(
                        'element' => 'google_map',
                        'value' => 'other',
                    ),
                ),
                array(
                    "type" => "textfield",
                    "holder" => "div",
                    "class" => "",
                    "heading" => esc_html__( "Description", "automatic" ),
                    "param_name" => "content2",
                    "value" => esc_html__( "", "automatic" ),
                    "description" => esc_html__( "Enter your content.", "automatic" ),
                    'dependency' => array(
                        'element' => 'google_map',
                        'value' => 'other',
                    ),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__( 'Extra class name', 'automatic_sc' ),
                    'param_name' => 'el_class',
                    'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'automatic_sc' )
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => esc_html__( 'CSS box', 'automatic_sc' ),
                    'param_name' => 'css',
                    'group' => esc_html__( 'Design Options', 'automatic_sc' ),
                ),
            )
        )
    );
}
