<?php
add_action('vc_build_admin_page', 'automatic_shortcode_list_category');
add_action( 'vc_before_init', 'automatic_shortcode_list_category' );

function automatic_shortcode_list_category() {
    $layout = array( esc_html__( 'Select category', 'automatic_sc' ) => '' );
    $link_cats = get_terms( 'product_cat' );
    if ( is_array( $link_cats ) && ! empty( $link_cats ) ) {
        foreach ( $link_cats as $link_cat ) {
            if ( is_object( $link_cat ) && isset( $link_cat->name, $link_cat->term_id ) ) {
                $layout[ $link_cat->name ] = $link_cat->slug;
            }
        }
    }
    $list_item = array( esc_html__( 'Select item', 'automatic_sc' ) => '' );
    vc_map( array(
        'name' => esc_html__( '[Automatic] List Category', 'automatic_sc' ),
        'base' => 'automatic_list_category',
        'icon' => 'automatic_vc_icon',
        'category' =>'Automatic',
        'description' => esc_html__( 'List category', 'automatic_sc' ),
        'params' => array(
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Group", "automatic"),
                "param_name" => "cat_product",
                "value" => $layout,
                'description' => esc_html__( 'Select taxonomy layout you would like to use', 'automatic_sc' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Type', 'automatic_sc' ),
                'param_name' => 'type',
                'value' => array(
                    esc_html__( 'Default', 'automatic_sc' ) => 'default',
                    esc_html__( 'List', 'automatic_sc' ) => 'list',
                ),
                'description' => esc_html__( 'Select type show item.', 'automatic_sc' ),
            ),
            array(
                'type' => 'attach_image',
                'heading' => esc_html__( 'Image', 'automatic_sc' ),
                'param_name' => 'image',
                'description' => esc_html__( 'Select image from media library.', 'automatic_sc' ),
                'dependency' => array(
                    'element' => 'type',
                    'value'   => 'default'
                )
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'automatic_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'automatic_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'automatic_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'automatic_sc' ),
            ),
        )
    ) );
}