<?php
add_action('vc_build_admin_page', 'automatict_shortcode_advanced_image');
add_action( 'vc_before_init', 'automatict_shortcode_advanced_image' );

function automatict_shortcode_advanced_image() {
    vc_map( array(
        'name' => esc_html__( '[Automatic] Advanced Box', 'automatic_sc' ),
        'base' => 'automatic_advanced_image',
        'icon' => 'automatic_vc_icon',
        'category' =>'Automatic',
        'description' => esc_html__( 'automatic advanced with images is background for box', 'automatic_sc' ),
        'params' => array(
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Type Box', 'automatic_sc' ),
                'param_name' => 'layout',
                'value' => array(
                    esc_html__( 'Box with Banner', 'automatic_sc' ) => 'layout4',
                    esc_html__( 'Box with Banner Color', 'automatic_sc' ) => 'layout5',
                    esc_html__( 'Box with Banner Background', 'automatic_sc' ) => 'layout6',
                    esc_html__( 'Box with Banner Page', 'automatic_sc' ) => 'layout7',
                     esc_html__( 'Box with Banner Page 1', 'automatic_sc' ) => 'layout8',
                ),
                'description' => esc_html__( 'Select type for box.', 'automatic_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'automatic_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( 'Name time line.', 'automatic_sc' ),
                'admin_label' => true,
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('layout4', 'layout5', 'layout7','layout8'),
                )
            ),
            array(
                "type" => "colorpicker",
                "heading" => esc_html__("Background Text Color","automatic"),
                "param_name" => "bg_title_color",
                "value" => "#74a7cb",
                "description" => "",
                'dependency' => array(
                    'element' => 'layout',
                    'value' => 'layout6'
                )
            ),
            array(
                "type" => "colorpicker",
                "heading" => esc_html__("Title Color","automatic"),
                "param_name" => "auto_title_color",
                "value" => "#111",
                "description" => "",
                'dependency' => array(
                    'element' => 'layout',
                    'value' => 'layout7'
                )
            ),
            array(
                "type" => "textarea_html",
                "heading" => esc_html__( "Description", "automatic" ),
                "param_name" => "content",
                "value" => esc_html__( "", "automatic" ),
                "description" => esc_html__( "add content.", "automatic" ),
            ),
            array(
                "type" => "colorpicker",
                "heading" => esc_html__("Text Color","automatic"),
                "param_name" => "auto_text_color",
                "value" => "#666",
                "description" => "",
                'dependency' => array(
                    'element' => 'layout',
                    'value' => 'layout7'
                )
            ),
            array(
                'type' => 'attach_image',
                'heading' => esc_html__( 'Image', 'automatic_sc' ),
                'param_name' => 'image',
                'description' => esc_html__( 'Select image from media library.', 'automatic_sc' )
            ),
            array(
                'type' => 'vc_link',
                'heading' => esc_html__( 'URL (Link)', 'automatic_sc' ),
                'param_name' => 'link',
                'description' => esc_html__( 'Add link to button..', 'automatic_sc' ),
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('layout4', 'layout5','layout6','layout8'),
                )
            ),
            array(
                "type" => "colorpicker",
                "heading" => esc_html__("Button Text Color","automatic"),
                "param_name" => "btn_title_color",
                "value" => "#34B3FB",
                "description" => "",
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('layout4', 'layout5','layout6','layout8'),
                )
            ),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Content Alignment","automatic"),
                "param_name" => "content_align",
                "value" => array(
                        esc_html__("Left",'automatic_sc') => "ct-left",
                        esc_html__("Right",'automatic_sc') => "ct-right",
                    ),
                "description" => "",
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('layout4','layout8'),
                )
            ),
            vc_map_add_css_animation(),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'automatic_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'automatic_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'automatic_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'automatic_sc' ),
            ),
        )
    ) );
}