<?php
add_action( 'vc_before_init', 'shortcode_about' );

function shortcode_about() {
    vc_map( array(
        "name" => esc_html__( "[Automatic] About", "automatic" ),
        "base" => "automatic_about",
        "class" => "",
        'services' => 'automatic_vc_about',
        "category" => "Automatic",
        "description" => esc_html__( 'About','automatic_sc' ),
        "params" => array(
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Layout about', 'automatic_sc' ),
                'param_name' => 'layout',
                'value' => array(
                    esc_html__( 'Image Left', 'automatic_sc' ) => 'ltr',
                    esc_html__( 'Image Right', 'automatic_sc' ) => 'rtl',
                ),
                'admin_label' => true,
                'description' => esc_html__( 'Select layout.', 'automatic_sc' ),
            ),
            array(
                'type' => 'textfield',
                'param_name' => 'title',
                'heading' => esc_html__( 'Title', 'automatic_sc' ),
                'description' => esc_html__( 'Enter text used as widget title.', 'automatic_sc' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Text align', 'automatic_sc' ),
                'param_name' => 'align',
                'value' => array(
                    esc_html__( 'Left', 'automatic_sc' ) => 'left',
                    esc_html__( 'Center', 'automatic_sc' ) => 'center',
                    esc_html__( 'Right', 'automatic_sc' ) => 'right',
                ),
                'description' => esc_html__( 'Select align heading title.', 'automatic_sc' ),
            ),
            array(
                "type" => "textarea_html",
                "heading" => esc_html__( "Description", "automatic" ),
                "param_name" => "content",
                "value" => esc_html__( "", "automatic" ),
                "description" => esc_html__( "Enter your content.", "automatic" )
            ),
			array(
				'type' => 'dropdown',
				'heading' => __( 'Image source', 'automatic_sc' ),
				'param_name' => 'source',
				'value' => array(
					__( 'Media library', 'automatic_sc' ) => 'media_library',
					__( 'External links', 'automatic_sc' ) => 'external_link',
				),
				'std' => 'media_library',
				'description' => __( 'Select image source.', 'automatic_sc' ),
			),
			array(
				'type' => 'attach_image',
				'heading' => __( 'Image', 'automatic_sc' ),
				'param_name' => 'image',
				'value' => '',
				'description' => __( 'Select images from media library.', 'automatic_sc' ),
				'dependency' => array(
					'element' => 'source',
					'value' => 'media_library',
				),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'External link', 'automatic_sc' ),
				'param_name' => 'custom_src',
				'description' => __( 'Select external link.', 'automatic_sc' ),
				'dependency' => array(
					'element' => 'source',
					'value' => 'external_link',
				),
			),
            vc_map_add_css_animation(),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'automatic_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'automatic_sc' ),
            ),
        )
    ));
}