<?php
/*
Plugin Name: ArrowPress Importer
Plugin URI: 
Description: Import Demo Content For Theme
Version: 1.0.0
Author: ArrowPress
Author URI: 
*/

defined('ABSPATH') or die('You cannot access here.');
//add_action('admin_init', 'automatic_import');  
class Automatic_import_demo{
	function __construct() {  
		add_action( 'wp_ajax_automatic_import',  array( $this,'automatic_import') );
		add_action( 'wp_ajax_nopriv_automatic_import',  array( $this,'automatic_import') );
		add_action('admin_enqueue_scripts', array( $this,'automatic_import_scripts')); 
	}
	function automatic_import_scripts() {
		wp_enqueue_script('automatic_import_scripts',plugin_dir_url( __FILE__ ) .'assets/js/import.js' ,array( 'jquery' ), '1.0', true);
		wp_localize_script( 'automatic_import_scripts', 'automatic_ajax_product', array(
        'ajaxurl'       => admin_url( 'admin-ajax.php' )
    ));
	}
	function automatic_import() { 
		global $wp_filesystem; 
		if ( empty( $wp_filesystem ) ) {
				require_once ABSPATH . '/wp-admin/includes/file.php';
				WP_Filesystem();
		}
		if (!defined('WP_LOAD_IMPORTERS'))
			define('WP_LOAD_IMPORTERS', true); // we are loading importers 
		if (!class_exists('WP_Importer')) { // if main importer class doesn't exist
			$wp_importer = ABSPATH . 'wp-admin/includes/class-wp-importer.php';
			include $wp_importer;
		}
		if (!class_exists('WP_Import')) { // if WP importer doesn't exist
			require_once( dirname( __FILE__ ) . '/wordpress-importer/wordpress-importer.php' ); 
		} 
		if (class_exists('WP_Importer') && class_exists('WP_Import')) {
			update_option('wpb_js_content_types', array('page','block'));
		}
		if (class_exists('RevSlider')) {
			$rev_lists = array('home-1', 'home-2','home-3'); 
			$revolutionDb = new UniteDBRev(); 
			global $wpdb;
			$table = GlobalsRevSlider::$table_sliders; 
			$query = "delete from $table where alias in ('home-1', 'home-2','home-3')";
			$wpdb->query($query) ;
			foreach($rev_lists as $rev_list){
				$file_path = plugin_dir_path( __FILE__ ) . 'data/rev_slider/'.$rev_list.'.zip'; 
				if ( file_exists( $file_path ) ){
					$slider = new RevSlider();  
					$slider->importSliderFromPost( true, true, $file_path );
				}
			}
		}
		// Import widgets
		update_option('sidebars_widgets', array());
		ob_start();
		$widget_datas = plugin_dir_path( __FILE__ ). '/data/widget/widget_data.json';
		include $widget_datas;
		$widget_data = ob_get_clean();
		$this-> automatic_import_widget_data($widget_data);
		flush_rewrite_rules();
		wp_delete_nav_menu('Main Menu'); 
		wp_delete_nav_menu('Departments');
		wp_delete_nav_menu('Header_1_menu');
		wp_delete_nav_menu('Header_2_menu');
		wp_delete_nav_menu('Infomation');
		wp_delete_nav_menu('Quickly_menu');
		// Import data
		$importer = new WP_Import();
		$theme_xml = plugin_dir_path( __FILE__ ) . 'data/content/automatic.xml';
		set_time_limit(0);
		$importer->fetch_attachments = true;
		ob_start();
		$importer->import($theme_xml);
		ob_end_clean();
		$locations = get_theme_mod('nav_menu_locations');
		$menus = wp_get_nav_menus(); // registered menus
		if ($menus) {
			foreach ($menus as $menu) {
				if ($menu->name == 'Main Menu') {
					$locations['primary'] = $menu->term_id;
				}
				if ($menu->name == 'Quickly_menu') {
					$locations['quickly'] = $menu->term_id;
				}
			}
		}
		// Set reading options
		$homepage = get_page_by_title('Home'); 
		$posts_page = get_page_by_title('Blog');
		if (($homepage && $homepage->ID)) {
			update_option('show_on_front', 'page');
			if ($homepage && $homepage->ID) {
				update_option('page_on_front', $homepage->ID); // Front Page
			}
			if ($posts_page && $posts_page->ID) {
				update_option('page_for_posts', $posts_page->ID); // Blog Page
			}
		}
		// Set woocommerce pages
		if (class_exists('WooCommerce')) {
			$woopages = array(
				'woocommerce_shop_page_id' => 'Shop',
				'woocommerce_cart_page_id' => 'Cart',
				'woocommerce_checkout_page_id' => 'Checkout',
				'woocommerce_myaccount_page_id' => 'My Account'
			);
			foreach ($woopages as $page_key => $page_title) {
				$woopage = get_page_by_title($page_title);
				if (isset($woopage) && $woopage->ID) {
					update_option($page_key, $woopage->ID); // Front Page
				}
			}

			// disable woocommerce notice install page
			$notices = array_diff(get_option('woocommerce_admin_notices', array()), array('install', 'update'));
			update_option('woocommerce_admin_notices', $notices);
			delete_option('_wc_needs_pages');
			delete_transient('_wc_activation_redirect');
		} 
		exit();
	}  
		// Parsing Widgets Function
		// Reference: http://wordpress.org/plugins/widget-settings-importexport/
	function automatic_import_widget_data($widget_data) {
		$json_data = $widget_data;
		$json_data = json_decode($json_data, true);

		$sidebar_data = $json_data[0];
		$widget_data = $json_data[1];
		foreach ($widget_data as $widget_data_title => $widget_data_value) {
				$widgets[$widget_data_title] = '';
				foreach ($widget_data_value as $widget_data_key => $widget_data_array) {
						if (is_int($widget_data_key)) {
								$widgets[$widget_data_title][$widget_data_key] = 'on';
						}
				}
		}
		unset($widgets[""]);

		foreach ($sidebar_data as $title => $sidebar) {
				$count = count($sidebar);
				for ($i = 0; $i < $count; $i++) {
						$widget = array();
						$widget['type'] = trim(substr($sidebar[$i], 0, strrpos($sidebar[$i], '-')));
						$widget['type-index'] = trim(substr($sidebar[$i], strrpos($sidebar[$i], '-') + 1));
						if (!isset($widgets[$widget['type']][$widget['type-index']])) {
								unset($sidebar_data[$title][$i]);
						}
				}
				$sidebar_data[$title] = array_values($sidebar_data[$title]);
		}

		foreach ($widgets as $widget_title => $widget_value) {
				foreach ($widget_value as $widget_key => $widget_value) {
						$widgets[$widget_title][$widget_key] = $widget_data[$widget_title][$widget_key];
				}
		}

		$sidebar_data = array(array_filter($sidebar_data), $widgets);
		$this->automatic_parse_import_data($sidebar_data);
	}

	function automatic_parse_import_data($import_array) {
		global $wp_registered_sidebars;
		$sidebars_data = $import_array[0];
		$widget_data = $import_array[1];
		$current_sidebars = get_option('sidebars_widgets');
		$new_widgets = array();

		foreach ($sidebars_data as $import_sidebar => $import_widgets) :

				foreach ($import_widgets as $import_widget) :
						//if the sidebar exists
						if (isset($wp_registered_sidebars[$import_sidebar])) :
								$title = trim(substr($import_widget, 0, strrpos($import_widget, '-')));
								$index = trim(substr($import_widget, strrpos($import_widget, '-') + 1));
								$current_widget_data = get_option('widget_' . $title);
								$new_widget_name = $this-> automatic_get_new_widget_name($title, $index);
								$new_index = trim(substr($new_widget_name, strrpos($new_widget_name, '-') + 1));

								if (!empty($new_widgets[$title]) && is_array($new_widgets[$title])) {
										while (array_key_exists($new_index, $new_widgets[$title])) {
												$new_index++;
										}
								}
								$current_sidebars[$import_sidebar][] = $title . '-' . $new_index;
								if (array_key_exists($title, $new_widgets)) {
										$new_widgets[$title][$new_index] = $widget_data[$title][$index];
										$multiwidget = $new_widgets[$title]['_multiwidget'];
										unset($new_widgets[$title]['_multiwidget']);
										$new_widgets[$title]['_multiwidget'] = $multiwidget;
								} else {
										$current_widget_data[$new_index] = $widget_data[$title][$index];
										$current_multiwidget = (isset($current_widget_data['_multiwidget'])) ? $current_widget_data['_multiwidget'] : '';
										$new_multiwidget = isset($widget_data[$title]['_multiwidget']) ? $widget_data[$title]['_multiwidget'] : false;
										$multiwidget = ($current_multiwidget != $new_multiwidget) ? $current_multiwidget : 1;
										unset($current_widget_data['_multiwidget']);
										$current_widget_data['_multiwidget'] = $multiwidget;
										$new_widgets[$title] = $current_widget_data;
								}

						endif;
				endforeach;
		endforeach;

		if (isset($new_widgets) && isset($current_sidebars)) {
				update_option('sidebars_widgets', $current_sidebars);

				foreach ($new_widgets as $title => $content)
						update_option('widget_' . $title, $content);

				return true;
		}

		return false;
	}

	function automatic_get_new_widget_name($widget_name, $widget_index) {
		$current_sidebars = get_option('sidebars_widgets');
		$all_widget_array = array();
		foreach ($current_sidebars as $sidebar => $widgets) {
				if (!empty($widgets) && is_array($widgets) && $sidebar != 'wp_inactive_widgets') {
						foreach ($widgets as $widget) {
								$all_widget_array[] = $widget;
						}
				}
		}
		while (in_array($widget_name . '-' . $widget_index, $all_widget_array)) {
				$widget_index++;
		}
		$new_widget_name = $widget_name . '-' . $widget_index;
		return $new_widget_name;
	}

	function automatic_fetch_remote_file( $url ) {
		global $automaticReduxSettings;
		$reduxFramework = $automaticReduxSettings->ReduxFramework;
		$tmp = download_url( $url );
		$file_array = array(
				'name' => basename( $url ),
				'tmp_name' => $tmp
		);
		// Check for download errors
		if ( is_wp_error( $tmp ) ) {
				@unlink( $file_array[ 'tmp_name' ] );
				return $tmp;
		}
		$upload = wp_upload_dir();
		$new_file = $upload['basedir'] . "/automatic_data/" . $file_array['name'];
		if(file_exists($new_file)) {
				@unlink($new_file);
		}
		if ( !wp_mkdir_p( $upload['basedir'] . '/automatic_data' ) ) {
				if ( 0 === strpos( $upload['basedir'], ABSPATH ) )
						$error_path = str_replace( ABSPATH, '', $upload['basedir'] ) . $upload['subdir'];
				else
						$error_path = basename( $upload['basedir'] ) . $upload['subdir'];

				$message = sprintf( esc_html__( 'Unable to create directory %s. Is its parent directory writable by the server?', 'automatic' ), $error_path );
				return array( 'error' => $message );
		}
		$new_file_content = $reduxFramework->filesystem->execute('get_contents', $file_array['tmp_name']);
		$reduxFramework->filesystem->execute('put_contents', $new_file, array('content' => $new_file_content, 'chmod' => 0777));
		return '';
	}
} 
new Automatic_import_demo();