<?php
/**
*
*/
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
add_shortcode( 'automatic_viewed_product', 'automatic_template_viewed_product' );
function automatic_template_viewed_product( $atts ,$content=null){
    extract( shortcode_atts(
        array(
            'title' =>'',
            'no_view' =>'',
            'align' =>'left',
            'el_class' => '',
            'css' => '',
        ),$atts ));
    ob_start();
    $content = wpb_js_remove_wpautop( $content, true );
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, '' ), 'automatic_viewed_product', $atts );
    $el_class = automatic_extract_class( $el_class );

    if ( $css_class != '' ){
        $el_class .= automatic_extract_class( $css_class );
    }
    ?>
    <div class="automatic-viewed-product <?php echo $el_class; ?> au_fadeIn">
        <div class="row">
            <?php
            if ( $title != '' ) :  
                ?>
            <div class="col-md-2 col-xs-12 col-sm-2">
                <div class="shortcode-title wpb_bottom-to-top">
                    <h2><?php echo esc_attr( $title );?></h2>
                </div>
            </div>
                <?php
            endif;
            // Get WooCommerce Global
            global $woocommerce; 
            // Get recently viewed product cookies data
            $viewed_products = ! empty( $_COOKIE['woocommerce_recently_viewed'] ) ? (array) explode( '|', $_COOKIE['woocommerce_recently_viewed'] ) : array();
            $viewed_products = array_filter( array_map( 'absint', $viewed_products ) ); 
            // If no data, quit 
            if ( empty( $viewed_products ) ){
							echo '<div class="col-md-10 col-xs-12 col-sm-10 automatic-viewed">';
								if($no_view == ''){
									echo '<div class="no_product_view">'.esc_html_e( 'You have not viewed any product yet!', 'automatic_sc' ).'</div>';
								}else{
									echo '<div class="no_product_view">'.esc_attr($no_view).'</div>';
								}
								if ($content != '' ) :
									echo '<div class="other-content">';
										echo $content ;
									echo '</div>';
								endif;
							echo '</div>';
						}else{
							$wp_query = new WP_Query( array(
								'posts_per_page' => -1,
								'no_found_rows'  => 1,
								'post_status'    => 'publish',
								'post_type'      => 'product',
								'post__in'       => $viewed_products,
								));
							?>
							<div class="col-md-10 col-xs-12 col-sm-10">
								<div class="slide-product viewed-product initSlide_product" data-columns="7">
									<div class="beans-stepslider" data-rotate="true">
										<div class="beans-mask">
											<div class="beans-slideset">
												<?php
												while ($wp_query->have_posts()) : $wp_query->the_post();
														global  $post, $product;
														?>
														<div class="beans-slide">
																<a href="<?php the_permalink();?>" title="<?php the_title(); ?>"><?php the_post_thumbnail('automatic-image-product-xsmall'); ?></a> 
														</div>
														<?php
												endwhile;
												wp_reset_postdata();
												?>
											</div>
										</div>
									</div>
								</div>
								<?php if ($content != '' ) : ?>
										<div class="other-content">
												<?php echo $content ; ?>
										</div>
								<?php endif;?>
							</div>
					<?php } ?>
        </div>
    </div>
    <?php
    return ob_get_clean();

}