<?php
/**
 *  Contact Info
 */
add_shortcode( 'automatic_contactinfo', 'automatic_tp_contactinfo' );

function automatic_tp_contactinfo( $atts, $content = null ) { // New function parameter $content is added!
    extract( shortcode_atts( array(
        'title' => '',
        'phone' => '',
        'email' => '',
        'address' => '',
        'align_heading' => 'text-left',
        'css_animation' => '',
        'el_class' => '',
        'css' => '',
    ), $atts ) );

    ob_start();
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'automatic_contactinfo', $atts );
    $css_class_anm = automatic_getCSSAnimation( $css_animation );
    $el_class = automatic_extract_class( $el_class );
    if ( $css_class != '' ){
        $el_class .= automatic_extract_class( $css_class );
    }
    if ( $css_class_anm != '' ){
        $el_class .= ' '.$css_class_anm;
    }
    $el_class .= ' '.$align_heading;
    ?>

    <div class="automatic-contactinfo automatic_widget_contact">
        <?php if ( $title != '' ) : ?>
            <div class="shortcode-title <?php echo $el_class; ?>">
                <h2><?php echo esc_attr( $title );?></h2><?php endif; ?>
            </div>
        <?php if ( $phone != '' || $email != '' || $address != '' ) : ?>
        <ul>
            <?php if ( $address != '' ) : ?><li><em class="automaticicon-home"></em><span class="text"><?php echo esc_attr( $address );?></span></li><?php endif; ?>
            <?php if ( $phone != '' ) : ?><li><em class="automaticicon-phone"></em><a href="tel:<?php echo esc_attr( $phone );?>"><?php  esc_html_e( 'Tel','automatic_sc' ); ?>. <span class="text"><?php echo esc_attr( $phone );?></span></a></li><?php endif; ?>
            <?php if ( $email != '' ) : ?><li><em class="automaticicon-mail"></em><a href="mailto:<?php echo esc_attr( $email );?>"><?php  esc_html_e( 'Mail','automatic_sc' ); ?>.<span class="text"><?php echo esc_attr( $email );?></span></a></li><?php endif; ?>
        </ul>
    <?php endif; ?>
    </div>

    <?php
    return ob_get_clean();
}