<?php
/**
*
*/
add_shortcode( 'automatic_compare', 'automatic_template_compare' );
function automatic_template_compare( $atts ){
    extract( shortcode_atts(
        array( 
            'el_class' => '',
            'css' => '',
        ),$atts ));
    ob_start();
		if(class_exists( 'YITH_WOOCOMPARE' ) ) {
			$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, '' ), 'automatic_compare', $atts );
			$el_class = automatic_extract_class( $el_class );

			if ( $css_class != '' ){
					$el_class .= automatic_extract_class( $css_class );
			}  
			global $yith_woocompare;   
			global $product;  
			$wc_get_template = function_exists('wc_get_template') ? 'wc_get_template' : 'woocommerce_get_template';		
			?> 
			<div class="automatic-compare <?php echo $el_class; ?>"> 
					<?php 
						$products = $yith_woocompare->obj->get_products_list(); 
						$fields = $yith_woocompare->obj->fields(); 
						 
					?>
					<table class="compare-list table table-reponsive" cellpadding="0" cellspacing="0"<?php if ( empty( $products ) ) echo ' style="width:100%"' ?>>
						<thead>
						<tr>
								<th>&nbsp;</th>
								<?php foreach( $products as $i => $product ) : ?>
										<td></td>
								<?php endforeach; ?>
						</tr>
						</thead>
						<tfoot>
						<tr>
								<th>&nbsp;</th>
								<?php foreach( $products as $i => $product ) : ?>
										<td></td>
								<?php endforeach; ?>
						</tr>
						</tfoot>
						<tbody>

						<?php if ( empty( $products ) ) : ?>

								<tr class="no-products">
										<td><?php echo esc_html__( 'No products added in the compare table.', 'automatic_sc' ) ?></td>
								</tr>

						<?php else : ?>
								<tr class="remove">
										<th>&nbsp;</th>
										<?php foreach( $products as $i => $product ) : $product_class = ( $i % 2 == 0 ? 'odd' : 'even' ) . ' product_' . $product->id ?>
												<td class="<?php echo esc_attr($product_class); ?>">
														<a href="<?php echo add_query_arg( 'redirect', 'view', $yith_woocompare->obj->remove_product_url( $product->id ) ) ?>" data-product_id="<?php echo esc_attr($product->id); ?>"><i class="fa fa-trash-o"></i></a>
												</td>
										<?php endforeach ?>
								</tr>

								<?php foreach ( $fields as $field => $name ) : ?>

										<tr class="<?php echo esc_attr($field) ?>">

												<th>
														<?php echo wp_kses_post($name) ?>
														<?php if ( $field == 'image' ) echo '<div class="fixed-th"></div>'; ?>
												</th>

												<?php foreach( $products as $i => $product ) : $product_class = ( $i % 2 == 0 ? 'odd' : 'even' ) . ' product_' . $product->id; ?>
														<td class="<?php echo esc_attr($product_class); ?> product-desc"><?php
																switch( $field ) {

																		case 'image':
																				echo '<div class="image-wrap"><a href="' . get_permalink($product->id) . '">' . wp_get_attachment_image( $product->fields[$field], 'yith-woocompare-image' ) . '</a></div>';
																				break;

																		case 'add-to-cart':
																				$wc_get_template( 'loop/add-to-cart.php' );
																				break;

																		default:
																				echo empty( $product->fields[$field] ) ? '&nbsp;' : $product->fields[$field];
																				break;
																}
																?>
														</td>
												<?php endforeach ?>

										</tr>

								<?php endforeach; ?> 
						<?php endif; ?>

						</tbody>
				</table> 
			</div>
		<?php 
		}
    return ob_get_clean();

}