<?php
/**
*
*/
add_shortcode( 'automatic_banner_product', 'automatic_template_banner_product' );
function automatic_template_banner_product( $atts, $content=null ){
    extract( shortcode_atts(
        array(
            'title' =>'', 
            'shopnow' =>'Shop Now!', 
            'type_layout' =>'default',
            'link_product' =>'',
            'el_class' => '',
            'css' => '',
        ),$atts ));
    ob_start();

    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, '' ), 'automatic_banner_product', $atts );
    $el_class = automatic_extract_class( $el_class );

    if ( $css_class != '' ){
        $el_class .= automatic_extract_class( $css_class );
    }
	if ( $type_layout != '' ){
        $el_class .= ' '.$type_layout;
    }
	if($link_product !=''){
		$_product = wc_get_product( (int)$link_product );
	}
	?>
	<div class="automatic_banner_product <?php echo $el_class; ?> au_fadeIn">
		<?php 
			if($type_layout == 'layout-1'){
				$content = wpb_js_remove_wpautop( $content, true );
				if ( $_product->is_featured() ){
					echo '<div class="info-alert"><span class="automatic-title-r">'.esc_html__('Hot','automatic_sc').'</span></div>';
				}
				$args = array(
					'post_type' => "product",
					'p' => (int)$link_product
				);
				$rquery = New Wp_Query( $args );
				if ( $rquery->have_posts() ) :
					while( $rquery->have_posts() ) : $rquery-> the_post();
						global $product;
						if ( $title != '' ){
							echo '<div class="shortcode-title"><a href="'. get_the_permalink() .'"> <h2>'. esc_attr( $title ) .'</h2></a> </div>';
						} 
						echo '<div class="shortcode-subtitle">'. $content .'</div>'; 
						// Ensure visibility
						if ( empty( $product ) || ! $product->is_visible() ) {
							return;
						} 
						echo '<div class="price-product">';
							woocommerce_template_loop_price();
						echo '</div>';
						if ( wc_get_page_id( 'shop' ) > 0 ) : ?>
							<p class="return-to-shop">
								<a class="button wc-backward" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
									<i class="automaticicon-cart"></i> <?php echo $shopnow; ?>
								</a>
							</p>
						<?php 
						endif;
					endwhile;
				endif;
				wp_reset_postdata();
			}elseif($type_layout == 'layout-2'){
				$content = wpb_js_remove_wpautop( $content, true );
				if ( $_product->is_featured() ){
					echo '<div class="info-alert"><span class="automatic-title-r">'.esc_html__('Hot','automatic_sc').'</span></div>';
				}
				$args = array(
					'post_type' => "product",
					'p' => (int)$link_product
				);
				$rquery = New Wp_Query( $args );
				if ( $rquery->have_posts() ) :
					while( $rquery->have_posts() ) : $rquery-> the_post();
						global $product;
						if ( $title != '' ){
							echo '<div class="shortcode-title"><a href="'. get_the_permalink() .'"> <h2>'. esc_attr( $title ) .'</h2></a> </div>';
						} 
						echo '<div class="shortcode-subtitle">'. $content .'</div>';
						// Ensure visibility
						if ( empty( $product ) || ! $product->is_visible() ) {
							return;
						} 
						echo '<div class="price-product">';
							woocommerce_template_loop_price();
						echo '</div>';
						if ( wc_get_page_id( 'shop' ) > 0 ) : ?>
							<p class="return-to-shop">
								<a class="button wc-backward" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
									<i class="automaticicon-cart"></i> <?php echo $shopnow; ?>
								</a>
							</p>
						<?php 
						endif;
					endwhile;
				endif;
				wp_reset_postdata();
			}elseif($type_layout == 'layout-3'){
				if ( $_product->is_featured() ){
					echo '<div class="info-alert"><span class="automatic-title-r">'.esc_html__('Hot','automatic_sc').'</span></div>';
				} 
				$args = array(
					'post_type' => "product",
					'p' => (int)$link_product
				);
				$rquery = New Wp_Query( $args );
				if ( $rquery->have_posts() ) :
					while( $rquery->have_posts() ) : $rquery-> the_post();
						global $product; 
						if ( empty( $product ) || ! $product->is_visible() ) {
							return;
						} 
						echo '<div class="shortcode-title"><a href="'. get_the_permalink() .'"><h2> '. get_the_title() .'</h2></a> </div>';
						echo '<div class="price-product">';
							woocommerce_template_loop_price();
						echo '</div>';
						if ( wc_get_page_id( 'shop' ) > 0 ) : ?>
							<p class="return-to-shop">
								<a class="button wc-backward" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
									<i class="automaticicon-cart"></i> <?php echo $shopnow; ?>
								</a>
							</p>
						<?php 
						endif;
					endwhile;
				endif;
				wp_reset_postdata();
			}elseif($type_layout == 'layout-4'){
				$args = array(
						'post_type' => "product",
						'p' => (int)$link_product
					);
				$rquery = New Wp_Query( $args );
				if ( $rquery->have_posts() ) :
					while( $rquery->have_posts() ) : $rquery-> the_post(); 
						au_content_product_list();
					endwhile;
				endif;
				wp_reset_postdata(); 
			}else{
				$args = array(
						'post_type' => "product",
						'p' => (int)$link_product
					);
				$rquery = New Wp_Query( $args );
				if ( $rquery->have_posts() ) :
					while( $rquery->have_posts() ) : $rquery-> the_post();
						echo '<ul>';
						au_content_product();
						echo '</ul>';
					endwhile;
				endif;
				wp_reset_postdata(); 
			}
		?> 
	</div>
	<?php 
    return ob_get_clean();

}