<?php
/**
 * Shortcode Automatic Tabs
 */
add_action('vc_build_admin_page', 'automatic_shortcode_tabs');
add_action( 'vc_before_init', 'automatic_shortcode_tabs' );

function automatic_shortcode_tabs() {
    vc_map( array(
        'name' => esc_html__( '[Automatic] Tabs', 'automatic_sc' ),
        'base' => 'automatic_tabs',
        "icon" => "automatic_vc_icon",
        'as_parent' => array(
            'only' => 'vc_tta_section'
        ),
        'category' =>'Automatic',
        'description' => esc_html__( 'Collapsible content panels', 'automatic_sc' ),
        'params' => array(
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Align', 'automatic_sc' ),
                'param_name' => 'align',
                'value' => array(
                    esc_html__( 'Left', 'automatic_sc' ) => 'left',
                    esc_html__( 'Right', 'automatic_sc' ) => 'right',
                    esc_html__( 'Center', 'automatic_sc' ) => 'center'
                ),
                'description' => esc_html__( 'Type align title tab.', 'automatic_sc' ),
            ),
            vc_map_add_css_animation(),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'automatic_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'automatic_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'automatic_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'automatic_sc' ),
            ),
        ),
        'js_view' => 'VcBackendTtaTabsView',
        'custom_markup' => '
            <div class="vc_tta-container" data-vc-action="collapse">
				<div class="vc_general vc_tta vc_tta-tabs vc_tta-color-backend-tabs-white vc_tta-style-flat vc_tta-shape-rounded vc_tta-spacing-1 vc_tta-tabs-position-top vc_tta-controls-align-left">
					<div class="vc_tta-tabs-container">'
								   . '<ul class="vc_tta-tabs-list">'
								   . '<li class="vc_tta-tab" data-vc-tab data-vc-target-model-id="{{ model_id }}" data-element_type="vc_tta_section"><a href="javascript:;" data-vc-tabs data-vc-container=".vc_tta" data-vc-target="[data-model-id=\'{{ model_id }}\']" data-vc-target-model-id="{{ model_id }}"><span class="vc_tta-title-text">{{ section_title }}</span></a></li>'
								   . '</ul>
					</div>
					<div class="vc_tta-panels vc_clearfix {{container-class}}">
					  {{ content }}
					</div>
				</div>
			</div>',
        'default_content' => '
        [vc_tta_section title="' . sprintf( '%s %d', __( 'Tab', 'js_composer' ), 1 ) . '"][/vc_tta_section]
		[vc_tta_section title="' . sprintf( '%s %d', __( 'Tab', 'js_composer' ), 2 ) . '"][/vc_tta_section]
            '
    ) );
}