<?php
add_action('vc_build_admin_page', 'automatic_shortcode_product_special');
add_action( 'vc_before_init', 'automatic_shortcode_product_special' );

function automatic_shortcode_product_special() {
    $layout = array( esc_html__( 'All Links', 'automatic_sc' ) => '' );
    $link_cats = get_terms( 'product_cat' );
    if ( is_array( $link_cats ) && ! empty( $link_cats ) ) {
        foreach ( $link_cats as $link_cat ) {
            if ( is_object( $link_cat ) && isset( $link_cat->name, $link_cat->term_id ) ) {
                $layout[ $link_cat->name ] = $link_cat->slug;
            }
        }
    }
    $list_item = array( esc_html__( 'Select item', 'automatic_sc' ) => '' );
    $args = array(
        'post_type' => "product",
        'posts_per_page' => -1,
        'orderby' => 'title',
        'order'   => 'ASC'
    );
    $rquery = New Wp_Query( $args );
    if ( $rquery->have_posts() ) :
        while( $rquery->have_posts() ) : $rquery-> the_post();
            global $post;
            $list_item[ get_the_title().'('.$post->post_name.')' ] = get_the_ID();
        endwhile;
    endif;
    vc_map( array(
        'name' => esc_html__( '[Automatic] Product Special', 'automatic_sc' ),
        'base' => 'automatic_product_special',
        'icon' => 'automatic_vc_icon',
        'category' =>'Automatic',
        'description' => esc_html__( 'List item(s) product', 'automatic_sc' ),
        'params' => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'automatic_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( 'Widget Title.', 'automatic_sc' ),
                'admin_label' => true,
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Group", "automatic"),
                "param_name" => "cat_product",
                "value" => $layout,
                'description' => esc_html__( 'Select taxonomy layout you would like to use', 'automatic_sc' ),
            ),
            array(
                "type" => "number",
                "heading" => esc_html__("Number item", "automatic"),
                "param_name" => "items_show",
                "value" => -1,
                "suffix" => "item(s)",
                "description" => esc_html__("select item show. note: value -1 if show all item.", "automatic"),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Column', 'automatic_sc' ),
                'param_name' => 'column',
                'value' => array(
                    esc_html__( '1 column', 'automatic_sc' ) => '1',
                    esc_html__( '2 column', 'automatic_sc' ) => '2',
                    esc_html__( '3 column', 'automatic_sc' ) => '3',
                    esc_html__( '4 column', 'automatic_sc' ) => '4',
                    esc_html__( '5 column', 'automatic_sc' ) => '5',
                ),
                'description' => esc_html__( 'Layout column product.', 'automatic_sc' ),
            ),
             array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Row', 'automatic_sc' ),
                'param_name' => 'row',
                'value' => array(
                    esc_html__( '1 row', 'automatic_sc' ) => '1',
                    esc_html__( '2 row', 'automatic_sc' ) => '2',
                    esc_html__( '3 row', 'automatic_sc' ) => '3',
                    esc_html__( '4 row', 'automatic_sc' ) => '4',
                    esc_html__( '5 row', 'automatic_sc' ) => '5',
                ),
                'description' => esc_html__( 'Layout row product.', 'automatic_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'automatic_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'automatic_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'automatic_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'automatic_sc' ),
            ),
        )
    ) );
}