<?php
add_action('vc_build_admin_page', 'automatic_shortcode_contactinfo');
add_action( 'vc_before_init', 'automatic_shortcode_contactinfo' );

function automatic_shortcode_contactinfo() {
    vc_map( array(
        'name' => esc_html__( '[Automatic] Contact Info', 'automatic_sc' ),
        'base' => 'automatic_contactinfo',
        "icon" => "automatic_vc_icon",
        'category' => 'Automatic',
        'description' => esc_html__( 'Collapsible content panels', 'automatic_sc' ),
        'params' => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'automatic_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( 'Name title.', 'automatic_sc' ),
                'admin_label' => true,
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Align text heading', 'automatic_sc' ),
                'param_name' => 'align_heading',
                'value' => array(
                    esc_html__( 'Left', 'automatic_sc' ) => 'text-left',
                    esc_html__( 'Right', 'automatic_sc' ) => 'text-right',
                    esc_html__( 'Center', 'automatic_sc' ) => 'text-center',
                ),
                'description' => esc_html__( 'Select type align for text heading.', 'automatic_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Address', 'automatic_sc' ),
                'param_name' => 'address',
                'description' => esc_html__( 'Enter address.', 'automatic_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Phone', 'automatic_sc' ),
                'param_name' => 'phone',
                'description' => esc_html__( 'Enter phone number.', 'automatic_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Email', 'automatic_sc' ),
                'param_name' => 'email',
                'description' => esc_html__( 'Enter address email.', 'automatic_sc' ),
            ),
            vc_map_add_css_animation(),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'automatic_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'automatic_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'automatic_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'automatic_sc' ),
            ),
        ),
    ) );
}