<?php
add_action('vc_build_admin_page', 'automatic_shortcode_banner_product');
add_action( 'vc_before_init', 'automatic_shortcode_banner_product' );

function automatic_shortcode_banner_product() {

    $list_item = array( esc_html__( 'Select item', 'automatic_sc' ) => '' );
    $args = array(
        'post_type' => "product",
        'posts_per_page' => -1,
        'orderby' => 'title',
        'order'   => 'ASC'
    );
    $rquery = New Wp_Query( $args );
    if ( $rquery->have_posts() ) :
        while( $rquery->have_posts() ) : $rquery-> the_post();
            global $post;
            $list_item[ get_the_title().'('.$post->post_name.')' ] = get_the_ID();
        endwhile;
    endif;
	wp_reset_postdata();
    vc_map( array(
        'name' => esc_html__( '[Automatic] Banner Product', 'automatic_sc' ),
        'base' => 'automatic_banner_product',
        'icon' => 'automatic_vc_icon',
        'category' =>'Automatic',
        'description' => esc_html__( 'Banner product', 'automatic_sc' ),
        'params' => array(
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Type', 'automatic_sc'),
                'param_name' => 'type_layout',
                'value' => array(
                    esc_html__( 'Default', 'automatic_sc' ) => 'default',
                    esc_html__( 'Layout 1', 'automatic_sc' ) => 'layout-1',
                    esc_html__( 'Layout 2', 'automatic_sc' ) => 'layout-2',
                    esc_html__( 'Layout 3', 'automatic_sc' ) => 'layout-3',
                    esc_html__( 'Layout 4', 'automatic_sc' ) => 'layout-4',
                    esc_html__( 'Layout 4', 'automatic_sc' ) => 'layout-5',
                ),
                'description' => esc_html__( 'Select style for Product banner', 'automatic_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'automatic_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( 'Title.', 'automatic_sc' ),
								'dependency' => array(
									'element' => 'type_layout',
									'value' => array('layout-1','layout-2')
								),
                'admin_label' => true,
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Shop Now', 'automatic_sc' ),
                'param_name' => 'shopnow',
                'description' => esc_html__( 'Shop Now Text', 'automatic_sc' ),
								'dependency' => array(
									'element' => 'type_layout',
									'value' => array('layout-1','layout-2','layout-3')
								),
                'admin_label' => true,
            ),
            array(
							"type" => "textarea_html",
							"heading" => esc_html__( "Description", "automatic" ),
							'param_name' => 'content',
							'description' => esc_html__( 'Description.', 'automatic_sc' ),
							'dependency' => array(
								'element' => 'type_layout',
								'value' => array('layout-1','layout-2')
							),
							'admin_label' => true,
            ),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Link to Product", "automatic"),
                "param_name" => "link_product",
                "value" => $list_item,
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'automatic_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'automatic_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'automatic_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'automatic_sc' ),
								'dependency' => array(
									'element' => 'type_layout',
									'value' => array('layout-1','layout-2','layout-3')
								),
            ),
        )
    ) );
}