<?php
add_action('vc_build_admin_page', 'automatic_shortcode_product_2');
add_action( 'vc_before_init', 'automatic_shortcode_product_2' );

function automatic_shortcode_product_2() {
    vc_map( array(
        'name' => esc_html__( '[Automatic] Recent Added', 'automatic_sc' ),
        'base' => 'automatic_product_2',
        'icon' => 'automatic_vc_icon',
        'category' =>'Automatic',
        'description' => esc_html__( 'List item(s) product', 'automatic_sc' ),
        'params' => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'automatic_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( 'Widget Title.', 'automatic_sc' ),
                'admin_label' => true,
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'No view', 'automatic_sc' ),
                'param_name' => 'no_added',
                'description' => esc_html__( 'Text show when You have not added product', 'automatic_sc' ),
                'admin_label' => true,
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Product Show', 'automatic_sc' ),
                'param_name' => 'type_product',
                'value' => array(
                    esc_html__( 'Product List', 'automatic_sc' ) => 'list-product',
                    esc_html__( 'Product Grid', 'automatic_sc' ) => 'grid-product',
                ),
                'description' => esc_html__( 'Type product show then added cart', 'automatic_sc' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Column', 'automatic_sc' ),
                'param_name' => 'column',
                'value' => array(
                    esc_html__( '1 column', 'automatic_sc' ) => '1',
                    esc_html__( '2 column', 'automatic_sc' ) => '2',
                    esc_html__( '3 column', 'automatic_sc' ) => '3',
                    esc_html__( '4 column', 'automatic_sc' ) => '4',
                    esc_html__( '5 column', 'automatic_sc' ) => '5',
                ),
                'description' => esc_html__( 'Layout column product.', 'automatic_sc' ),
            ),
             array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Row', 'automatic_sc' ),
                'param_name' => 'row',
                'value' => array(
                    esc_html__( '1 row', 'automatic_sc' ) => '1',
                    esc_html__( '2 row', 'automatic_sc' ) => '2',
                    esc_html__( '3 row', 'automatic_sc' ) => '3',
                    esc_html__( '4 row', 'automatic_sc' ) => '4',
                    esc_html__( '5 row', 'automatic_sc' ) => '5',
                ),
                'description' => esc_html__( 'Layout row product.', 'automatic_sc' ),
                'dependency' => array(
                    'element' => 'type_product',
                    'value' => 'list-product',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'automatic_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'automatic_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'automatic_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'automatic_sc' ),
            ),
        )
    ) );
}