<?php
function automatic_vc_custom_class() {
    return array(
        'type' => 'textfield',
        'heading' => __( 'Extra class name', 'automatic_sc' ),
        'param_name' => 'el_class',
        'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'automatic_sc' )
    );
}
function automatic_extract_class( $el_class ) {
    $output = '';
    if ( $el_class != '' ) {
        $output = " " . str_replace( ".", "", $el_class );
    }

    return $output;
}
function vc_get_css_colors( $prefix, $color ) {
    $rgb_color = preg_match( '/rgba/', $color ) ? preg_replace( array(
        '/\s+/',
        '/^rgba\((\d+)\,(\d+)\,(\d+)\,([\d\.]+)\)$/',
    ), array(
        '',
        'rgb($1,$2,$3)',
    ), $color ) : $color;
    $string = $prefix . ':' . $rgb_color . ';';
    if ( $rgb_color !== $color ) {
        $string .= $prefix . ':' . $color . ';';
    }

    return $string;
}
function automatic_shortcode_template( $name = false ) {
    if (!$name)
        return false;

    if ( $overridden_template = locate_template( 'vc_templates' . $name . '.php' ) ) {
        return $overridden_template;
    } else {
        // If neither the child nor parent theme have overridden the template,
        // we load the template from the 'templates' sub-directory of the directory this file is in
        return AUTOMATIC_SHORTCODES_TEMPLATES . $name . '.php';
    }
}
function automatic_shortcode_end_block_comment( $string ) {
    return WP_DEBUG ? '<!-- END ' . $string . ' -->' : '';
}
/*Get css editor*/
function vc_shortcode_custom_css_classs( $param_value, $prefix = '' ) {
    $css_class = preg_match( '/\s*\.([^\{]+)\s*\{\s*([^\}]+)\s*\}\s*/', $param_value ) ? $prefix . preg_replace( '/\s*\.([^\{]+)\s*\{\s*([^\}]+)\s*\}\s*/', '$1', $param_value ) : '';

    return $css_class;
}
/**
 * Css Animation
 */
function automatic_css_animation() {
    return array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'CSS Animation', 'automatic_sc' ),
        'param_name' => 'css_animation',
        'admin_label' => true,
        'value' => array(
            esc_html__( 'No', 'automatic_sc' ) => '',
            esc_html__( 'Top to bottom', 'automatic_sc' ) => 'top-to-bottom',
            esc_html__( 'Bottom to top', 'automatic_sc' ) => 'bottom-to-top',
            esc_html__( 'Left to right', 'automatic_sc' ) => 'left-to-right',
            esc_html__( 'Right to left', 'automatic_sc' ) => 'right-to-left',
            esc_html__( 'Appear from center', 'automatic_sc' ) => 'appear',
        ),
        'description' => esc_html__( 'Select type of animation for element to be animated when it "enters" the browsers viewport (Note: works only in modern browsers).', 'automatic_sc' ),
    );
}
function automatic_getCSSAnimation( $css_animation ) {
    $output = '';
    if ( '' !== $css_animation ) {
        wp_enqueue_script( 'waypoints' );
        $output = 'wpb_animate_when_almost_visible wpb_' . $css_animation;
    }

    return $output;
}

function vc_tta_tab_list($atts, $content){
    extract( shortcode_atts( array(
            'title' => '',
        ), $atts ) );
    ob_start();
?>
    <?php echo do_shortcode($content); ?>
<?php
    $result = ob_get_contents();
    ob_end_clean();

    return $result;
}
add_shortcode( 'vc_tta_tab_list', 'vc_tta_tab_list' );

function vc_tta_tab_list_title($atts, $content){
    extract( shortcode_atts( array(
            'title' => '',
        ), $atts ) );
    ob_start();
    $i=0;
    $i++;
?>
    <?php echo $atts['title']; ?>
<?php
    $result = ob_get_contents();
    ob_end_clean();

    return $result;
}
add_shortcode( 'vc_tta_tab_list_title', 'vc_tta_tab_list_title' );