<?php
/*
Plugin Name: Woocommerce Group and Daily Deals
Plugin URI:
Description: A plugin to create group and daily deals
Version: 1.1
Author: BlakeTee
Author URI: http://codecanyon.net/user/BlakeTee
License: Envato License
Text Domain: woo_groupdeal
Domain Path: /languages
*/


register_activation_hook( __FILE__, 'groupDealPlugin_activate' );

$gdOriPrice;

//function to add the default localization option when plugin is activated
function groupDealPlugin_activate(){
   global $wpdb;
	$wordToTranslate = array("Value", "Discount", "You save" , "About %d bought during this deal", "Time Left to Buy", "The deal is on", "%d more buyers needed", "Sale!", "There are insufficient %s as in your cart (%d available)", "Deal will start in", "Woo Group & Daily Deals");
	$wordToTranslateName = array("valHidden", "discountHidden", "youSaveHidden" , "AbtboughtthisdealHidden", "timeLeftToBuyHidden", "dealSuccessHidden", "buyerNeedHidden", "SaleHidden", "inSufficientErrorHidden", "DealWillStartInHidden", "woognddeals");
    
    $defaultSeriallocalizeArr = array();
    $initialLocalizeArr = array();
	
	 for($n = 0; $n < count($wordToTranslateName); $n++){
			$defaultSeriallocalizeArr[$wordToTranslateName[$n]] = $wordToTranslate[$n];
	}
	
	
  
    if(!get_option('gd_localize_default')){
		$defaultSeriallocalizeArr = serialize($defaultSeriallocalizeArr);
		add_option( "gd_localize_default", $defaultSeriallocalizeArr);
		add_option( "gd_localize", $defaultSeriallocalizeArr);
	}else{
		if(get_option('gd_localize')){
			$localizeStrArr = get_option('gd_localize');
			$localizeStrArr = unserialize($localizeStrArr);
			
			for($g = 0; $g < count($wordToTranslate); $g++){
			    if(isset($localizeStrArr[$wordToTranslateName[$g]])){
               	
                			
				  if($localizeStrArr[$wordToTranslateName[$g]]){
				    $initialLocalizeArr[$wordToTranslateName[$g]] = $localizeStrArr[$wordToTranslateName[$g]];
				  }
				
				 
				}
				$defaultSeriallocalizeArr[$wordToTranslateName[$g]] = $wordToTranslate[$g];
			 }
		
		$defaultSeriallocalizeArr = serialize($defaultSeriallocalizeArr);
		$initialLocalizeArr = serialize($initialLocalizeArr);
		}
	   update_option("gd_localize_default", $defaultSeriallocalizeArr);
	   update_option("gd_localize", $initialLocalizeArr);
	}
	
	
	//function to check and add customization
		
		$CustomOptionLabelId = array("gd_price_table", "gd_timer", "noOfUser", "gd_progress_bar", "gd_show_deal_success", "gd_buyer_need");
	       
		   	if(get_option('gd_customize')){
				$customizeStrArr = get_option('gd_customize');
				$customizeStrArr = unserialize($customizeStrArr);
			}
		   
		   $defaultSerialCustomizeArr = array();
	        if(isset($customizeStrArr['gd_timer_language'])){
		       $defaultSerialCustomizeArr['gd_timer_language'] = $customizeStrArr['gd_timer_language'];
		    }else{
			   $defaultSerialCustomizeArr['gd_timer_language'] = "en";
			}
			
		
			for($n = 0; $n < count($CustomOptionLabelId); $n++){
			   if(isset($customizeStrArr[$CustomOptionLabelId[$n]])){
			        $defaultSerialCustomizeArr[$CustomOptionLabelId[$n]] = $customizeStrArr[$CustomOptionLabelId[$n]];
			   }else{
					$defaultSerialCustomizeArr[$CustomOptionLabelId[$n]] = $CustomOptionLabelId[$n];
			   }
			}
			
			$defaultSerialCustomizeArr = serialize($defaultSerialCustomizeArr);
			
			
			  if(!get_option('gd_customize')){
					add_option( "gd_customize", $defaultSerialCustomizeArr);
			  }else{
			     update_option( "gd_customize", $defaultSerialCustomizeArr);
			  } 
			
	
	  //create database wp_groupdeal1 if not exists
	   if($wpdb->get_var("SHOW TABLES LIKE 'wp_groupdeal1'") != "wp_groupdeal1") {
   
	  $sql = "CREATE TABLE wp_groupdeal1(
			id int(11) NOT NULL AUTO_INCREMENT,
            pid int(11) NOT NULL,
            gid int(11) NOT NULL,
            description LONGTEXT NOT NULL,
            min int(11) NOT NULL,
            max int(11) NOT NULL,
            min_type int(11) NOT NULL,
            max_type int(11) NOT NULL,
            date_start DATE NOT NULL,
            date_end DATE NOT NULL,
            date_start_status tinyint(1) NOT NULL,
            date_end_status tinyint(1) NOT NULL,
            offer_type varchar(100) NOT NULL,
            offer_val double NOT NULL,
            roles varchar(100) NOT NULL,
            roles_val varchar(100) NOT NULL,
	        PRIMARY KEY (id)      
      );";
	 
	 
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php'  );
		dbDelta($sql);
		 
  }
  
  	 //create database wp_groupdeal2 if not exists
	   if($wpdb->get_var("SHOW TABLES LIKE 'wp_groupdeal2'") != "wp_groupdeal2") {
   
	  $sql = "CREATE TABLE wp_groupdeal2(
			id int(11) NOT NULL AUTO_INCREMENT,
            pid int(11) NOT NULL,
            gid int(11) NOT NULL,
            thisdeal int(11) NOT NULL,
            cumulativedeal int(11) NOT NULL,
	        PRIMARY KEY (id)      
      );";
	 
	 
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php'  );
		dbDelta($sql);
	}
	
	//create database wp_groupdeal3 if not exists
	   if($wpdb->get_var("SHOW TABLES LIKE 'wp_groupdeal3'") != "wp_groupdeal3") {
   
	  $sql = "CREATE TABLE wp_groupdeal3(
			id int(11) NOT NULL AUTO_INCREMENT,
            pid int(11) NOT NULL,
            gid int(11) NOT NULL,
            order_code int(11) NOT NULL,
            qty int(11) NOT NULL,
	        PRIMARY KEY (id)      
      );";
	 
	 
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php'  );
		dbDelta($sql);
	}

}


//add the translation
add_action('init', 'GDinitFunc');
function GDinitFunc(){
     load_plugin_textdomain('woo_groupdeal', false, dirname(plugin_basename(__FILE__)) . '/languages/');
     
}



//enqueue and register all the javascript and css and register a submenu page call Group Deal Settings which is for settings
add_action('admin_menu', 'register_my_custom_submenu_page');

function register_my_custom_submenu_page() {
     wp_enqueue_script('jQuery');
	wp_enqueue_script('jqueryuismoothness', plugin_dir_url(__FILE__) . 'js/jqueryuismoothness/jquery-ui.min.js');
	wp_enqueue_style('jqueryuismoothnesscss', plugin_dir_url(__FILE__) . 'js/jqueryuismoothness/jquery-ui.min.css');
	wp_enqueue_script('harvesthqchosenjs', plugin_dir_url(__FILE__) . 'js/chosen/chosen.jquery.min.js');
	wp_enqueue_style('harvesthqchosencss', plugin_dir_url(__FILE__) . 'js/chosen/chosen.min.css');
    wp_enqueue_style('woogroupdealbackend', plugin_dir_url(__FILE__) . 'css/backend.css' );
	 wp_register_script('groupdeal_customization_js', plugin_dir_url(__FILE__) . 'js/customization.js');
	 wp_register_script('groupdeal_search_js', plugin_dir_url(__FILE__) . 'js/search.js');
	
	//pure css table
	wp_register_style('purecsstable', plugin_dir_url(__FILE__) . 'css/purecss/tables-min.css' );
	
	//countdown
	wp_register_style('jquerycountdowncss', plugin_dir_url(__FILE__) . 'js/jquery.countdown.package-2.0.1/jquery.countdown.css');
	wp_register_script('jqueryCountdownjquerypluginjs', plugin_dir_url(__FILE__) . 'js/jquery.countdown.package-2.0.1/jquery.plugin.js');
	wp_register_script('jqueryCountdownjs', plugin_dir_url(__FILE__) . 'js/jquery.countdown.package-2.0.1/jquery.countdown.js');
	//wp_register_script('jqueryCountdownjszhtw', plugin_dir_url(__FILE__) . 'js/jquery.countdown.package-2.0.1/jquery.countdown-zh-TW.js');
	
	$countDownLang = array("ar","id","ms","bn","nb","bs","bg","ca","cs","cy","da","de","et","el","es","fo","fa","fr","gl","sq","gu","ko","he","hr","hy","is","it","kn","lv","lt","hu","ml","my","nl","ja","uz","th","pl","pt-BR","ro","ru","sk","sl","sr","sr-SR","fi","sv","vi","tr","uk","ur","zh-CN","zh-TW");
	
	for($v=0; $v < count($countDownLang); $v++){
	   wp_register_script('jqueryCountdownjs' . $countDownLang[$v], plugin_dir_url(__FILE__) . 'js/jquery.countdown.package-2.0.1/jquery.countdown-' . $countDownLang[$v] . '.js');
	}
	
	add_submenu_page( 'edit.php?post_type=product', 'GroupDeal Settings', 'GroupDeal Settings', 'manage_options', 'woo_groupdeal_settings', 'my_custom_submenu_page_callback' ); 

	
	
	}
	
	//add shortcode

	 add_shortcode('woo_gd' , 'shortcode_func');
     function shortcode_func($attr){
	       
		    global $woocommerce, $gdOriPrice, $wpdb;
		   
			require_once( 'mee/getthisdeal.php' );   		   
			require_once( 'mee/show-groupdeal-price.php' ); 
			require_once( 'mee/groupdealpricetable.php' );
			require_once( 'mee/showtimer.php' );
			require_once( 'mee/getsuccession.php' );
			require_once( 'mee/progress.php' );
			
			
			
	      wp_enqueue_style('jquerycountdowncss', plugin_dir_url(__FILE__) . 'js/jquery.countdown.package-2.0.1/jquery.countdown.css');
	      wp_enqueue_script('jqueryCountdownjquerypluginjs', plugin_dir_url(__FILE__) . 'js/jquery.countdown.package-2.0.1/jquery.plugin.js');
	      wp_enqueue_script('jqueryCountdownjs', plugin_dir_url(__FILE__) . 'js/jquery.countdown.package-2.0.1/jquery.countdown.js');
			
		  if(get_option('gd_localize')){
			$localizeOption = get_option('gd_localize');
			$localizeOption = unserialize($localizeOption);
		 }
	 
		if(get_option('gd_localize_default')){
			$DefaultlocalizeOption = get_option('gd_localize_default');
			$DefaultlocalizeOption = unserialize($DefaultlocalizeOption);
		}	
			
		  if(get_option('gd_customize')){
				$gd_customizeOptionExist = true;
				$gd_customize_Option = get_option('gd_customize');
				$gd_customize_Option = unserialize($gd_customize_Option);
			}else{
				$gd_customizeOptionExist = false;
			}
		 
		 
		
		 
	      wp_enqueue_style('woo_gd_shortcode', plugin_dir_url(__FILE__) . 'css/woo-gd-shortcode.css');
	      $currentProd = new WC_Product($attr[id]);
		  
		   $currentProd -> get_price();
		  
		  $Woo_shortCode_content = "<div class='woo_widget_wrapper'><div class='woo_gd_img_wrapper'><a href='" . $currentProd ->get_permalink() . "'>" .$currentProd -> get_image('shop_single') . "</a></div><div class='summary entry-summary woo_gd_shortcode_summary'><h2 itemprop='name' class='product_title entry-title woo_gd_prod_title'><a href='" . $currentProd ->get_permalink() ."'>" . $currentProd -> get_title(). "</a></h2>";
		  
		  //check if the deal is currently running
			if(getThisDeal($attr[id])){
			
				$GDFromDB1 = getThisDeal($attr[id]);
				$GIDofGDFromDB1 = $GDFromDB1['gid'];
				
                $woo123 = $attr[id];		
				$GIDofGDFromDB1 = $GDFromDB1['gid'];
			 
				$sql1 = "SELECT * FROM wp_groupdeal2 WHERE pid = $woo123 AND gid = $GIDofGDFromDB1";
				$get_ori_image = $wpdb -> get_row($sql1, ARRAY_A);
				  
				 $Woo_shortCode_content .= "<p>";
				  $Woo_shortCode_content .= "<del><span class='amount'>" .  sprintf( get_woocommerce_price_format(), get_woocommerce_currency_symbol(), $gdOriPrice )  . "</span></del> <ins><span class='amount'> " . sprintf( get_woocommerce_price_format(), get_woocommerce_currency_symbol(), showGDPrice($GDFromDB1["offer_type"], $GDFromDB1["offer_val"], $gdOriPrice)). "  </span></ins>";
				  $Woo_shortCode_content .= "</p>";

			//if get customize option not exist then use the default settings which is to display the table
		    if(!$gd_customizeOptionExist){
				 $Woo_shortCode_content .=  showGDPriceTable($gdOriPrice, showGDPrice($GDFromDB1["offer_type"], $GDFromDB1["offer_val"], $gdOriPrice), $localizeOption, $DefaultlocalizeOption);
		   }else{
		       if((isset($gd_customize_Option['gd_price_table'])) && ($gd_customize_Option['gd_price_table'] != "false")){
			       $Woo_shortCode_content .=  showGDPriceTable($gdOriPrice, showGDPrice($GDFromDB1["offer_type"], $GDFromDB1["offer_val"], $gdOriPrice), $localizeOption, $DefaultlocalizeOption);
			   }
			   
			   if($gd_customize_Option['gd_timer_language'] != "en"){
					wp_enqueue_script('jqueryCountdownjs' . $gd_customize_Option['gd_timer_language'], plugin_dir_url(__FILE__) . 'js/jquery.countdown.package-2.0.1/jquery.countdown-' . $gd_customize_Option['gd_timer_language'] . '.js');
			   }
			   
		   }
		   
		   $Woo_shortCode_content .=  woogd_show_timer($GDFromDB1, $gd_customize_Option, $localizeOption, $DefaultlocalizeOption, plugin_dir_url(__FILE__), $gd_customizeOptionExist, $attr[id]);
		    
            $Woo_shortCode_content .= woo_groupdeal_progress($GDFromDB1, $get_ori_image, $gd_customize_Option, $localizeOption, $DefaultlocalizeOption);			
		   
		   }else{
		   
		   //action to performed when deal not yet started
		       $GDFromDB1 = getNotYetStartDeal($attr[id]);
			   
			    $Woo_shortCode_content .= "<p>";
				  $Woo_shortCode_content .= "<del><span class='amount'>" .  sprintf( get_woocommerce_price_format(), get_woocommerce_currency_symbol(), $gdOriPrice )  . "</span></del> <ins><span class='amount'> " . sprintf( get_woocommerce_price_format(), get_woocommerce_currency_symbol(), showGDPrice($GDFromDB1["offer_type"], $GDFromDB1["offer_val"], $gdOriPrice)). "  </span></ins>";
				  $Woo_shortCode_content .= "</p>";

			//if get customize option not exist then use the default settings which is to display the table
				if(!$gd_customizeOptionExist){
					$Woo_shortCode_content .=  showGDPriceTable($gdOriPrice, showGDPrice($GDFromDB1["offer_type"], $GDFromDB1["offer_val"], $gdOriPrice), $localizeOption, $DefaultlocalizeOption);
				}else{
				if((isset($gd_customize_Option['gd_price_table'])) && ($gd_customize_Option['gd_price_table'] != "false")){
			       $Woo_shortCode_content .=  showGDPriceTable($gdOriPrice, showGDPrice($GDFromDB1["offer_type"], $GDFromDB1["offer_val"], $gdOriPrice), $localizeOption, $DefaultlocalizeOption);
				}
			   
				if($gd_customize_Option['gd_timer_language'] != "en"){
						wp_enqueue_script('jqueryCountdownjs' . $gd_customize_Option['gd_timer_language'], plugin_dir_url(__FILE__) . 'js/jquery.countdown.package-2.0.1/jquery.countdown-' . $gd_customize_Option['gd_timer_language'] . '.js');
				}
			   
			}
			
			    $Woo_shortCode_content .= woogd_show_nys_timer($GDFromDB1, $gd_customize_Option, $localizeOption, $DefaultlocalizeOption, plugin_dir_url(__FILE__), $gd_customizeOptionExist, $attr[id]);
		   }
		    
			 	 
			  
			 
			//$Woo_shortCode_content .=  "<del><span class='amount'>" .  sprintf( get_woocommerce_price_format(), get_woocommerce_currency_symbol(), $currentProd -> get_regular_price() )  . "</span></del> <ins><span class='amount'> " . sprintf( get_woocommerce_price_format(), get_woocommerce_currency_symbol(), showGDPrice($GDFromDB1["offer_type"], $GDFromDB1["offer_val"], $currentProd -> get_regular_price())). "  </span></ins>";
      if($attr[add_cart_button]){		
		$gd_add_to_cart_button = do_shortcode("[add_to_cart id='". $attr[id] ."']");
      }else{
		 $gd_add_to_cart_button = "";
	  }
		  $Woo_shortCode_content .=  $gd_add_to_cart_button .= "</div></div>";
		  return $Woo_shortCode_content;
		  //return "<div class='woo_widget_wrapper'><div class='woo_gd_img_wrapper'>" .$sajhj -> get_image('shop_single') . "</div><div class='summary entry-summary'><h2 itemprop='name' class='product_title entry-title woo_gd_prod_title'><a href='" . $sajhj ->get_permalink() ."'>" . $sajhj -> get_title(). "</a></h2></div></div>";
	     // return "<div id='woo_widget_wrapper'><div style='float: left; width: 40%'><img src='http://localhost/wgd/wp-content/uploads/2013/06/poster_2_up-300x300.jpg' /></div><div><h1>Hello World</h1></div></div>";
	 }
	
	//action carried when product is saved
	add_action( 'save_post', 'save_GroupDeal' );
	
	function save_GroupDeal($post_id){
	global $wpdb;
	   if(get_post_type($post_id) == "product"){
	     //add groupdeal info to database
	       if(!empty($_POST['GroupDealContentCountHidden'])){
		     $GroupDealContentCountHidden = explode(",",$_POST['GroupDealContentCountHidden']);
	     
		  //delete previous data in the wp_groupdeal1 table
		  $wpdb->delete( 
				'wp_groupdeal1', 
			array( 
				'pid' => $post_id
			)
           );
		   
		  for($i = 0; $i < count($GroupDealContentCountHidden); $i++){
		  
			$wpdb->insert( 
				'wp_groupdeal1', 
			array( 
				'pid' => $post_id,
				'gid' => $GroupDealContentCountHidden[$i],
				'description' => $_POST['GroupDealDescHidden' . $GroupDealContentCountHidden[$i]],
				'min' => $_POST['GDMinHidden' . $GroupDealContentCountHidden[$i]],
				'max' => $_POST['GDMaxHidden' . $GroupDealContentCountHidden[$i]],
				'min_type' => $_POST['GDMin_type' . $GroupDealContentCountHidden[$i]],
				'max_type' => $_POST['GDMax_type' . $GroupDealContentCountHidden[$i]],
				'offer_type' => $_POST['GD_offerType' . $GroupDealContentCountHidden[$i]],
				'offer_val' => $_POST['GD_offerVal' . $GroupDealContentCountHidden[$i]],
				'roles' => $_POST['GDRolesHidden' . $GroupDealContentCountHidden[$i]],
				'roles_val' => $_POST['GDRoles_valHidden' . $GroupDealContentCountHidden[$i]],
				'date_start' => date('Y-m-d', strtotime($_POST['GD_dateStartHidden' . $GroupDealContentCountHidden[$i]])),
				'date_start_status' => $_POST['date_start_status_hidden' . $GroupDealContentCountHidden[$i]],
				'date_end' => date('Y-m-d', strtotime($_POST['GD_dateEndHidden' . $GroupDealContentCountHidden[$i]])),
				'date_end_status' => $_POST['date_end_status_hidden' . $GroupDealContentCountHidden[$i]]
			)
           );
          
   
		  }
		 }
		 
		 //delete groupdeal from database
		 if(!empty($_POST['GroupDealContentDeleteCountHidden'])){
		     $GroupDealContentDeleteCountHidden = explode(",",$_POST['GroupDealContentDeleteCountHidden']);
			 
		  for($i = 0; $i < count($GroupDealContentDeleteCountHidden); $i++){
			//delete from the 1st table
			$wpdb->delete( 
				'wp_groupdeal1', 
			array( 
				'pid' => $post_id,
			    'gid' => $GroupDealContentDeleteCountHidden[$i]
			)
           );
		   
		   //delete from the 2nd table
		   $wpdb->delete( 
				'wp_groupdeal2', 
			array( 
				'pid' => $post_id,
			    'gid' => $GroupDealContentDeleteCountHidden[$i]
			)
           );
		   
		   //delete from the 3rd table
		    $wpdb->delete( 
				'wp_groupdeal3', 
			array( 
				'pid' => $post_id,
			    'gid' => $GroupDealContentDeleteCountHidden[$i]
			)
           );
		   
		  
		  }
		 }
		 }
	}

	

 require_once( 'mee/woo-functions.php' );

	 
	 //change the price to newly assign groupdeal price
	add_filter('woocommerce_product_get_price','change_price1', 10, 2);
	 function change_price1($myPrice, $prodID){
         global $gdOriPrice;
		 $gdOriPrice = $myPrice;
        require_once( 'mee/getthisdeal.php' );        	    
        require_once( 'mee/show-groupdeal-price.php' );  
        if(getThisDeal($prodID->get_id())){
		    $GDFromDB1 = getThisDeal($prodID->get_id());
			return showGDPrice($GDFromDB1["offer_type"], $GDFromDB1["offer_val"], $gdOriPrice);
			//return  $GDFromDB1["offer_type"];
		 }else{
		   return $myPrice;
		 }
		
		
		
	 }
	 
	
	 
	 //assign the maximum quantity available for the deal
	 add_filter( 'woocommerce_quantity_input_max', 'kia_quantity_input_step', 10, 2 );
			function kia_quantity_input_step($step, $product){
                   require_once( 'mee/getthisdeal.php' );    
				   require_once( 'mee/getQuantityAvailable.php' );
			        //global $product;
					if(getThisDeal($product->get_id())){
					   $GDFromDB1 = getThisDeal($product->get_id());
					 if(getQuantityAvailable(intVal($GDFromDB1["max_type"]), $GDFromDB1["max"], $product->get_id(), $GDFromDB1["gid"], $GDFromDB1["pid"]) != "infinity"){
					   return getQuantityAvailable(intVal($GDFromDB1["max_type"]), $GDFromDB1["max"], $product->get_id(), $GDFromDB1["gid"], $GDFromDB1["pid"]);
					  }
					}
					
					// the will be the new step value
		}
	 
	
	 
	//change the price of the deal
	 add_filter('woocommerce_get_price_html', 'gd_get_price_html', 10, 2);
	 function gd_get_price_html($myPrice, $prodID){
	 global  $woocommerce, $gdOriPrice;
	 
	  require_once( 'mee/getthisdeal.php' );        	    
        require_once( 'mee/show-groupdeal-price.php' );  
        if(getThisDeal($prodID->get_id())){
		    $GDFromDB1 = getThisDeal($prodID->get_id());
			
			//return  $GDFromDB1["offer_type"];
			
			return "<del><span class='amount'>" .  sprintf( get_woocommerce_price_format(), get_woocommerce_currency_symbol(), $gdOriPrice )  . "</span></del> <ins><span class='amount'> " . sprintf( get_woocommerce_price_format(), get_woocommerce_currency_symbol(), showGDPrice($GDFromDB1["offer_type"], $GDFromDB1["offer_val"], $gdOriPrice)). "  </span></ins>";
		 }else{
		   return $myPrice;
		 }
	 
	  
	 }
	
	//add sales badge in the list product page
	 add_action('woocommerce_before_shop_loop_item_title', 'gd_before_shop_loop_item_title');
	 function gd_before_shop_loop_item_title(){
		  require_once( 'mee/getthisdeal.php' );  
	       global $product;
		   	if(get_option('gd_localize')){
				$localizeOption = get_option('gd_localize');
				$localizeOption = unserialize($localizeOption);
			}
			
			if(get_option('gd_localize_default')){
				$DefaultlocalizeOption = get_option('gd_localize_default');
				$DefaultlocalizeOption = unserialize($DefaultlocalizeOption);
			}
			
			//assign sale badge for group deal on every item
		   if(getThisDeal($product-> get_id())){
			echo "<span class='onsale'>";
			 if((!trim($localizeOption['SaleHidden'])) || ((trim($localizeOption['SaleHidden'])) == (trim($DefaultlocalizeOption['SaleHidden'])))){
					printf( __( 'Sale!', 'woo_groupdeal' ));
				}else{
					printf( $localizeOption['SaleHidden'] );
				}
		
			
			echo "</span>";
		  }
	 }
	  
   
	 //add sale badge to single product
	  add_action('woocommerce_before_single_product_summary', 'gd_before_single_product_summary');
	 function gd_before_single_product_summary(){
	      global $product;
		  require_once( 'mee/getthisdeal.php' );    
		  
		  	if(get_option('gd_localize')){
				$localizeOption = get_option('gd_localize');
				$localizeOption = unserialize($localizeOption);
			}
			
			if(get_option('gd_localize_default')){
				$DefaultlocalizeOption = get_option('gd_localize_default');
				$DefaultlocalizeOption = unserialize($DefaultlocalizeOption);
			}
			
			//assign sale badge for every group deal product page
		   if(getThisDeal($product-> get_id())){
			echo "<span class='onsale'>";
			if((!trim($localizeOption['SaleHidden'])) || ((trim($localizeOption['SaleHidden'])) == (trim($DefaultlocalizeOption['SaleHidden'])))){
					printf( __( 'Sale!', 'woo_groupdeal' ));
				}else{
					printf( $localizeOption['SaleHidden'] );
				}
			echo"</span>";
		  }
	 }
	 
	
	//add all elements of group deal in the position of item summary
	add_action( 'woocommerce_single_product_summary', 'gd_single_product_summary', 10 ); 
	function gd_single_product_summary($summaryArg){
	global $wpdb, $gdOriPrice;
    wp_enqueue_style('woogroupdealfrontend', plugin_dir_url(__FILE__) . 'css/frontend.css' );
	
	if(get_option('gd_localize')){
		$localizeOption = get_option('gd_localize');
		$localizeOption = unserialize($localizeOption);
	 }
	 
	 if(get_option('gd_localize_default')){
		$DefaultlocalizeOption = get_option('gd_localize_default');
		$DefaultlocalizeOption = unserialize($DefaultlocalizeOption);
	 }
	 
	 //Check if group deal customize option exist
	 if(get_option('gd_customize')){
	     $gd_customizeOptionExist = true;
		 $gd_customize_Option = get_option('gd_customize');
	     $gd_customize_Option = unserialize($gd_customize_Option);
	 }else{
	     $gd_customizeOptionExist = false;
	 }
	 
	wp_enqueue_style('jquerycountdowncss', plugin_dir_url(__FILE__) . 'js/jquery.countdown.package-2.0.1/jquery.countdown.css');
	wp_enqueue_script('jqueryCountdownjquerypluginjs', plugin_dir_url(__FILE__) . 'js/jquery.countdown.package-2.0.1/jquery.plugin.js');
	wp_enqueue_script('jqueryCountdownjs', plugin_dir_url(__FILE__) . 'js/jquery.countdown.package-2.0.1/jquery.countdown.js');
	
	
	require_once( 'mee/getthisdeal.php' );    		
	    global $product, $woocommerce;
		$current_time = current_time('Y-m-d');
		

		$woo123 = $product->get_id();
		$sql2 = "SELECT * FROM wp_groupdeal1 WHERE (('$current_time' BETWEEN date_start AND date_end) AND (pid= $woo123)) OR ((('$current_time' > date_start) AND (date_end = '1970-01-01')) AND (pid= $woo123))";
		 $rows_retrieve2 = $wpdb -> get_results($sql2, ARRAY_A);
		
		
	
		require_once( 'mee/groupdealpricetable.php' );
		require_once( 'mee/show-groupdeal-price.php' );
		echo "\n";
		echo "<p>";
		echo "</p>";
		
        if(getThisDeal($product->get_id())){
		    $GDFromDB1 = getThisDeal($product->get_id());
			$GIDofGDFromDB1 = $GDFromDB1['gid'];

			//if get customize option not exist then use the default settings which is to display the table
		    if(!$gd_customizeOptionExist){
				echo showGDPriceTable($gdOriPrice, showGDPrice($GDFromDB1["offer_type"], $GDFromDB1["offer_val"], $gdOriPrice), $localizeOption, $DefaultlocalizeOption);
		   }else{
		       if((isset($gd_customize_Option['gd_price_table'])) && ($gd_customize_Option['gd_price_table'] != "false")){
			      echo showGDPriceTable($gdOriPrice, showGDPrice($GDFromDB1["offer_type"], $GDFromDB1["offer_val"], $gdOriPrice), $localizeOption, $DefaultlocalizeOption);
			   }
			   
			   if($gd_customize_Option['gd_timer_language'] != "en"){
					wp_enqueue_script('jqueryCountdownjs' . $gd_customize_Option['gd_timer_language'], plugin_dir_url(__FILE__) . 'js/jquery.countdown.package-2.0.1/jquery.countdown-' . $gd_customize_Option['gd_timer_language'] . '.js');
			   }
			   
		   }
			//return  $GDFromDB1["offer_type"];
			if($GDFromDB1["date_end_status"]){
			  //show time left to buy only if there 
			  if((isset($gd_customize_Option['gd_timer'])) && ($gd_customize_Option['gd_timer'] != "false")){
					echo "<p style='font-weight: bold;' id='kionggan'><img src='" .plugin_dir_url(__FILE__)  . "img/clock.png' style='width: 20px; height: 20px; display: inline;'><span>";
			 
				if((!trim($localizeOption['timeLeftToBuyHidden'])) || ((trim($localizeOption['timeLeftToBuyHidden'])) == (trim($DefaultlocalizeOption['timeLeftToBuyHidden'])))){
					printf( __( 'Time left to buy : ', 'woo_groupdeal' ));
				}else{
					printf( $localizeOption['timeLeftToBuyHidden'] );
				}
			  }
			}
			 echo "</span></p>";
			echo "<div id='myClock'></div>";
			

			?>
			
			<script>
			//create a countdown to the groupdeal
			  jQuery(window).load(function(){
				
			     <?php if(!$gd_customizeOptionExist){ ?>
				 
				 jQuery.countdown.setDefaults(jQuery.countdown.regionalOptions['']);
			     jQuery('#myClock').countdown(jQuery.extend({until: new Date("<?php echo $GDFromDB1["date_end"]; ?>")}, jQuery.countdown.regionalOptions['']));
				 
				 
				<?php }else{
				   
				  //assign timer if timer is set visible in the options
                   if((isset($gd_customize_Option['gd_timer'])) && ($gd_customize_Option['gd_timer'] != "false")){
				      
				    //only assign timer if the end date of a campaign is set
				     if($GDFromDB1["date_end_status"]){
				?>
					<?php if($gd_customize_Option['gd_timer_language'] != "en"){ ?>
						jQuery.countdown.setDefaults(jQuery.countdown.regionalOptions['']);
						jQuery('#myClock').countdown(jQuery.extend({until: new Date("<?php echo $GDFromDB1["date_end"]; ?>")}, jQuery.countdown.regionalOptions['<?php echo $gd_customize_Option['gd_timer_language']; ?>']));
			        
				<?php 
						}else{
						  ?>
							jQuery.countdown.setDefaults(jQuery.countdown.regionalOptions['']);
							jQuery('#myClock').countdown(jQuery.extend({until: new Date("<?php echo $GDFromDB1["date_end"]; ?>")}, jQuery.countdown.regionalOptions['']));
						  <?php
						}
					}
					}
				  }
				 ?>
				 
				});
			</script>
			<?php
			 $sql1 = "SELECT * FROM wp_groupdeal2 WHERE pid = $woo123 AND gid = $GIDofGDFromDB1";
			 $get_ori_image = $wpdb -> get_row($sql1, ARRAY_A);
			 
			if($get_ori_image['thisdeal']){ 
			 
            
			  //show number of user bought
				if((isset($gd_customize_Option['noOfUser'])) && ($gd_customize_Option['noOfUser'] != "false")){
				/**Check if user assign a localization field, if it is, then the localization field is used**/
					if((!trim($localizeOption['AbtboughtthisdealHidden'])) || ((trim($localizeOption['AbtboughtthisdealHidden'])) == (trim($DefaultlocalizeOption['AbtboughtthisdealHidden'])))){
						echo "<p style='margin-top: 50px; font-weight: bold;'><img src='". plugin_dir_url(__FILE__) ."img/3ppl.png' style='width: 18px; height: 18px; display: inline;'> " . sprintf( __( 'About %d Sold During this deal.', 'woo_groupdeal' ), intval($get_ori_image['thisdeal']) ) ."</h3>";
					}else{
						echo "<p style='margin-top: 50px; font-weight: bold;'><img src='". plugin_dir_url(__FILE__) ."img/3ppl.png' style='width: 18px; height: 18px;'> " . sprintf( $localizeOption['AbtboughtthisdealHidden'], intval($get_ori_image['thisdeal']) )."</h3>";
					}
						//About ".$get_ori_image['thisdeal']." Sold During this deal
			
				}else{
				   echo "<p style='margin-top: 50px;'></p>";
				}
				}
			
			/*******Display deal is success or not**********/
			    
				
                require_once( 'mee/getsuccession.php' ); 			   
			    if(getSuccession($GDFromDB1, $get_ori_image)){ 
				  
				   //show progress bar
				    if($GDFromDB1['min']){
   				    if((isset($gd_customize_Option['gd_progress_bar'])) && ($gd_customize_Option['gd_progress_bar'] != "false")){
						echo "<div style='height: 8px; width: 100%; border-radius: 4px; background-color: #d9d9de; margin-top: 20px; '><div style='height: 100%; width: 100%; border-radius: 4px; background-color: #2bde73;'></div></div>";
						echo "<div style='position: relative; height: 45px;'><span style='float: left; font-weight: bold;'>0</span><span style='float: right;font-weight: bold;'>" . $GDFromDB1['min'] . "</span></div>";
				    }
					}
					
					if((isset($gd_customize_Option['gd_show_deal_success'])) && ($gd_customize_Option['gd_show_deal_success'] != "false")){
					echo "<p style='font-weight: bold;'><img src='http://www.prop365.com/assets/check-icon-a165d14e76fb838b081e01a8d5d3ad56.png' style='width: 25px; height: 25px; display: inline;'>";
					  if((!trim($localizeOption['dealSuccessHidden'])) || ((trim($localizeOption['dealSuccessHidden'])) == (trim($DefaultlocalizeOption['dealSuccessHidden'])))){
								printf( __( 'The deal is on!', 'woo_groupdeal' ));
						}else{
								printf( $localizeOption['dealSuccessHidden'] );
						}
					
					echo "</p>";
					}
				}else{
				  if($get_ori_image){	

						$ProgressPercentage = ($get_ori_image["thisdeal"] / $GDFromDB1['min']) * 100;
						$BoughtTogo = $GDFromDB1['min'] - $get_ori_image["thisdeal"];
					}else{
					    $ProgressPercentage = 0;
                        $BoughtTogo = $GDFromDB1['min'];
					}
				 
				/*****************assign margin top of the progress bar gracefully according to the layout of the page*********/
				  //show progress bar
              if($GDFromDB1['min']){			   
			   if((isset($gd_customize_Option['gd_progress_bar'])) && ($gd_customize_Option['gd_progress_bar'] != "false")){
				  
				  if($GDFromDB1["date_end_status"]){
					if($get_ori_image['thisdeal']){ 
						echo "<div style='height: 8px; width: 100%; border-radius: 4px; background-color: #d9d9de; margin-top: 20px; '><div style='height: 100%; width: ". $ProgressPercentage ."%; border-radius: 4px; background-color: #2bde73;'></div></div>";
					}else{
						echo "<div style='height: 8px; width: 100%; border-radius: 4px; margin-top: 50px; background-color: #d9d9de; '><div style='height: 100%; width: ". $ProgressPercentage ."%; border-radius: 4px; background-color: #2bde73;'></div></div>";
					}
				  }else{
				        echo "<div style='height: 8px; width: 100%; border-radius: 4px; margin-top: 20px; background-color: #d9d9de; '><div style='height: 100%; width: ". $ProgressPercentage ."%; border-radius: 4px; background-color: #2bde73;'></div></div>";
				  }
				 /****************************************************************************************************************/
				  
					echo "<div style='position: relative; height: 45px;'><span style='float: left; font-weight: bold;'>0</span><span style='float: right;font-weight: bold;'>" . $GDFromDB1['min'] . "</span></div>";
				   }
				 
				 if((isset($gd_customize_Option['gd_buyer_need'])) && ($gd_customize_Option['gd_buyer_need'] != "false")){
				    echo "<p style='text-align: center; font-weight: bold;'>";
					  		  if((!trim($localizeOption['buyerNeedHidden'])) || ((trim($localizeOption['buyerNeedHidden'])) == (trim($DefaultlocalizeOption['buyerNeedHidden'])))){
									echo sprintf( __( '%d more buyers needed.', 'woo_groupdeal' ), intval($BoughtTogo) );
								}else{
		                                 	echo sprintf( $localizeOption['buyerNeedHidden'], intval($BoughtTogo) );
								}
		  
					echo "</p>";
					}
					}
				
				}
				
				echo "<div></div>";
			/*********************************************/
			
		 }		
		
	}
	
	
	
	 
   //check if the item in the cart exceeded the available quantity, if exceeded, it will show error notice
	add_action('woocommerce_check_cart_items', 'liao1', 10);
	function liao1(){
	global $wpdb, $woocommerce, $product, $blaPrice;
                   require_once( 'mee/getthisdeal.php' );    
				   require_once( 'mee/getQuantityAvailable.php' );
				   
				   
				     	if(get_option('gd_localize')){
							$localizeOption = get_option('gd_localize');
							$localizeOption = unserialize($localizeOption);
						}
						
						if(get_option('gd_localize_default')){
							$DefaultlocalizeOption = get_option('gd_localize_default');
							$DefaultlocalizeOption = unserialize($DefaultlocalizeOption);
						}
				   
				   foreach($woocommerce->cart->get_cart() as $cart_item_key => $values ) {
                       if(getThisDeal($values["product_id"])){
							$GDFromDB1 = getThisDeal($values["product_id"]);
							$GDQuantityAvailable = getQuantityAvailable(intVal($GDFromDB1["max_type"]), $GDFromDB1["max"], $values["product_id"], $GDFromDB1["gid"], $GDFromDB1["pid"]);
						    
						  if($GDQuantityAvailable != "infinity"){
								if($values['quantity'] > $GDQuantityAvailable){
									//wc_add_notice(sprintf("There are insufficient %s as in your cart (%d available)",$values["data"] -> post -> post_title ,$GDQuantityAvailable), 'error');
									//wc_add_notice("There are insufficient " .$values["data"] -> post -> post_title . " as in your cart (" . $GDQuantityAvailable . " available)", 'error');
								
								   if((!trim($localizeOption['inSufficientErrorHidden'])) || ((trim($localizeOption['inSufficientErrorHidden'])) == (trim($DefaultlocalizeOption['inSufficientErrorHidden'])))){
                                         	wc_add_notice(sprintf(__("There are insufficient %s as in your cart (%d available)", 'woo_groupdeal'),$values["data"] -> post -> post_title ,$GDQuantityAvailable), 'error');		                           
										    //sprintf( __( 'Time left to buy : ', 'woo_groupdeal' ));
				                  }else{
											wc_add_notice(sprintf( $localizeOption['inSufficientErrorHidden'],  $values["data"] -> post -> post_title ,$GDQuantityAvailable), "error");
									}
								
								}
							}
						  
						}
		
	
                    }
					
					
	      
  	    
	  
	
	}
    
	
		 
         global $woocommerce;

	
	//create panels for woocommerce
	add_action( 'woocommerce_product_write_panel_tabs', 'woocommerce_product_write_panel_tabs12');
	add_action('woocommerce_product_write_panels', 'woocommerce_product_write_panels12');
	
	/*************update the order data of group deal************************/
	add_action('woocommerce_checkout_update_order_meta','add_discount_at_checkout');
      
		function add_discount_at_checkout($order_id){
		global $wpdb;
		   
			$order = new WC_Order( $order_id );
			$items = $order->get_items();
			
			$cartItemCount = count($items);
			       $current_time = current_time('Y-m-d');
			foreach ( $items as $item ) {
				$woo123 = $item['product_id'];
				$sql2 = "SELECT * FROM wp_groupdeal1 WHERE (('$current_time' BETWEEN date_start AND date_end) AND (pid= $woo123)) OR ((('$current_time' > date_start) AND (date_end = '1970-01-01')) AND (pid= $woo123))";
				$rows_retrieve2 = $wpdb -> get_results($sql2, ARRAY_A);
          	    $itemQty = $item['qty'];
				
     
                
      			 if(getThisDeal($item['product_id'])){
				 $GDFromDB1  = getThisDeal($item['product_id']);
				 $GIDofGDFromDB1 = $GDFromDB1['gid'];
				 $sql1 = "SELECT * FROM wp_groupdeal2 WHERE pid = $woo123 AND gid = $GIDofGDFromDB1";
			     $get_ori_image = $wpdb -> get_row($sql1, ARRAY_A);
                    $GDFromDB1  = getThisDeal($item['product_id']);
					 
                					
				
					 if(!$get_ori_image){
				      $wpdb->insert( 
							'wp_groupdeal2',
						array( 
							'pid' => $woo123,
							'gid' => $GIDofGDFromDB1,
							'thisdeal' => $itemQty
							)
						);
					}
					 
					 //add value the order to wp_groupdeal2
					 $wpdb->update( 
							'wp_groupdeal2',
						array( 
							'thisdeal' => $get_ori_image['thisdeal'] + $itemQty
						), 
						array(
							'pid' => $woo123,
							'gid' => $GIDofGDFromDB1
						)
					);
					
					//add order info to wp_groupdeal3
					  $wpdb->insert( 
							'wp_groupdeal3',
						array( 
							'pid' => $woo123,
							'gid' => $GIDofGDFromDB1,
							'order_code' => $order_id,
							'qty' => $itemQty
						)
					);
					
                }				 
			}
					
		}
		
		
	/*************End of update the order data of group deal************************/


	function woocommerce_product_write_panel_tabs12(){
	 if(get_option('gd_localize')){
		$localizeOption = get_option('gd_localize');
		$localizeOption = unserialize($localizeOption);
	 }
	 
	 if(get_option('gd_localize_default')){
		$DefaultlocalizeOption = get_option('gd_localize_default');
		$DefaultlocalizeOption = unserialize($DefaultlocalizeOption);
	 }
        ?>
        <li class="custom_tab">
            <a href="#custom_tab_data_ctabs"><img src=' <?php echo plugin_dir_url(__FILE__) . "img/3ppl.png"; ?>' style="width: 18px; height: 18px;" />
			<?php
			if((!trim($localizeOption['woognddeals'])) || ((trim($localizeOption['woognddeals'])) == (trim($DefaultlocalizeOption['woognddeals'])))){
					printf( __( 'Woo Group & Daily Deals', 'woo_groupdeal' ));
				}else{
					printf( $localizeOption['woognddeals'] );
				}
				?>
		    </a>
        </li>
        <?php
    }
	
	function woocommerce_product_write_panels12() {
		wp_enqueue_script('generaljs', plugin_dir_url(__FILE__) . 'js/general.js');
        require_once( 'mee/groupdealtab.php' );
		   groupDealTab();
    }
	
	
	
	

?>