<?php
/**
 * Display single product reviews (comments)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product-reviews.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.3.2
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product;
$average      = $product->get_average_rating();
if ( ! comments_open() ) {
	return;
}

?>
<div id="reviews" class="woocommerce-Reviews">
	<div class="row">
		<div class="col-md-6 col-sm-12 col-xs-12">
			<div id="comments">
				<span class="woocommerce-Reviews-title"><?php
					if ( get_option( 'woocommerce_enable_review_rating' ) === 'yes' && ( $count = $product->get_review_count() ) )
						printf( _n( 'Based on %s review %s%s%s', 'Based on %s reviews %s%s%s', $count, 'automatic' ), $count, '<span>', '', '</span>' );
					else
						esc_html_e( 'Reviews', 'automatic' );
				?></span>
				<?php
					$automatic_rate_ave = "";
					if (($average < 3 && $average > 0)) {
						$automatic_rate_ave = "rate_red";
					}
					elseif (($average < 4 && $average >= 3)) {
						$automatic_rate_ave = "rate_yellow";
					}
					elseif (($average <= 5 && $average >= 4)) {
						$automatic_rate_ave = "rate_blue";
					}
					if ( $average != 0 ){
						echo '<div class="product-title-has-rate">';
						?>
						<span class="rating-product <?php echo esc_attr($automatic_rate_ave); ?>">
							<?php echo esc_html($average); ?>
							<span><?php esc_html_e('overall ','automatic' ); ?></span>
						</span>
						<?php
						echo '</div>';
					}
				?>
			</div>
			<div class="stars-all-left">

				<div class="stars-custom-all">
					<p class="stars-custom"><span class="star-1" href="#"></span><span class="star-2" href="#"></span><span class="star-3" href="#"></span><span class="star-4" href="#"></span><span class="star-5" href="#"></span></p>
					<p class="stars-custom"><span class="star-1" href="#"></span><span class="star-2" href="#"></span><span class="star-3" href="#"></span><span class="star-4" href="#"></span></p>
					<p class="stars-custom"><span class="star-1" href="#"></span><span class="star-2" href="#"></span><span class="star-3" href="#"></span></p>
					<p class="stars-custom"><span class="star-1" href="#"></span><span class="star-2" href="#"></span></p>
					<p class="stars-custom"><span class="star-1" href="#"></span></p>
				</div>

				<?php

					if ( ! comments_open() ) {
						return;
					}

					$ratings            = array( 5, 4, 3, 2, 1 );
					$total_rating_count = $product->get_rating_count();
					function wc_product_reviews_pro_get_comments_number( $post_id = 0, $types = array() ) {

						// Cast single type to array
						if ( ! is_array( $types ) ) {
							$types = array( $types );
						}

						global $wpdb;
						$select = $wpdb->prepare( "SELECT COUNT(comment_ID) FROM $wpdb->comments WHERE comment_post_ID = %d AND comment_approved = 1", $post_id );

						$where_type = '';
						if ( ! empty( $types ) ) {
							$where_type = $wpdb->prepare( " AND comment_type IN(" . implode( ', ', array_fill( 0, count( $types ), '%s' ) ) . ")", $types );
						}

						return $wpdb->get_var( $select . $where_type );
					}
					?>
					<div id="reviews">
						<?php if ( 'yes' === get_option( 'woocommerce_enable_review_rating' ) && $product->get_rating_count() ) : ?>

							<div class="product-rating">
								<div class="product-rating-details">
									<div>

										<?php
											foreach ( $ratings as $rating ) : ?>
											<?php
												$count1	= $product->get_rating_count( $rating );
												$filter = "comment_type=review&rating={$rating}";
												if($count !=0){
													$auto_count = ( $count1/$count)*100;
												}else{
													$auto_count=0;
												}
											?>
											<div>
												<div class="rating-count">
													<div class="rate-all">
														<div class="rate-per" style="width: <?php echo esc_attr($auto_count); ?>%;">
														</div>
													</div>
													<span><?php echo esc_html($count1); ?></span>

												</div>
											</div>

										<?php endforeach; ?>

									</div>
								</div>
							</div>

						<?php endif; ?>

					</div>
				</div>
		</div>
		<div class="col-md-6 col-sm-12 col-xs-12">
			<div id="comments">
				<span class="woocommerce-Reviews-title"><?php
					if ( get_option( 'woocommerce_enable_review_rating' ) === 'yes' && ( $count = $product->get_review_count() ) )
						printf( _n( 'Based on %s review %s%s%s', 'Based on %s reviews %s%s%s', $count, 'automatic' ), $count, '<span>', '', '</span>' );
					else
						esc_html_e( 'Reviews', 'automatic' );
				?></span>
			</div>
			<?php if ( get_option( 'woocommerce_review_rating_verification_required' ) === 'no' || wc_customer_bought_product( '', get_current_user_id(), $product->get_id() ) ) : ?>
					<div id="review_form_wrapper">
						<div id="review_form">
							<?php
								$commenter = wp_get_current_commenter();

								$comment_form = array(
									'comment_notes_after'  => '',
									'fields'               => array(
										'author' => '<p class="comment-form-author">' . '<label for="author">' . esc_html__( 'Your Name', 'automatic' ) . ' <span class="required">*</span></label> ' .
													'<input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" aria-required="true" required /></p>',
										'email'  => '<p class="comment-form-email"><label for="email">' . esc_html__( 'Your Email', 'automatic' ) . ' <span class="required">*</span></label> ' .
													'<input id="email" name="email" type="email" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30" aria-required="true" required /></p>',
									),
									'label_submit'  => esc_html__( 'Apply', 'automatic' ),
									'logged_in_as'  => '',
									'comment_field' => ''
								);

								if ( $account_page_url = wc_get_page_permalink( 'myaccount' ) ) {
									$comment_form['must_log_in'] = '<p class="must-log-in">' .  sprintf( esc_html__( 'You must be <a href="%s">logged in</a> to post a review.', 'automatic' ), esc_url( $account_page_url ) ) . '</p>';
								}

								if ( get_option( 'woocommerce_enable_review_rating' ) === 'yes' ) {
									$comment_form['comment_field'] = '<p class="comment-form-rating"><label for="rating">' . esc_html__( 'Your Rating', 'automatic' ) .'</label><select name="rating" id="rating" aria-required="true" required>
										<option value="">' . esc_html__( 'Rate&hellip;', 'automatic' ) . '</option>
										<option value="5">' . esc_html__( 'Perfect', 'automatic' ) . '</option>
										<option value="4">' . esc_html__( 'Good', 'automatic' ) . '</option>
										<option value="3">' . esc_html__( 'Average', 'automatic' ) . '</option>
										<option value="2">' . esc_html__( 'Not that bad', 'automatic' ) . '</option>
										<option value="1">' . esc_html__( 'Very Poor', 'automatic' ) . '</option>
									</select></p>';
								}

								$comment_form['comment_field'] .= '<p class="comment-form-comment"><label for="comment">' . esc_html__( 'Your Review', 'automatic' ) . ' <span class="required">*</span></label><textarea id="comment" name="comment" cols="45" rows="8" aria-required="true" required></textarea></p>';

								comment_form( apply_filters( 'woocommerce_product_review_comment_form_args', $comment_form ) );
							?>
						</div>
					</div>

				<?php else : ?>

					<p class="woocommerce-verification-required"><?php esc_html_e( 'Only logged in customers who have purchased this product may leave a review.', 'automatic' ); ?></p>

				<?php endif; ?>
		</div>
	</div>


<?php if ( have_comments() ) : ?>

	<ol class="commentlist">
		<?php wp_list_comments( apply_filters( 'woocommerce_product_review_list_args', array( 'callback' => 'woocommerce_comments' ) ) ); ?>
	</ol>

	<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
		echo '<nav class="woocommerce-pagination">';
		paginate_comments_links( apply_filters( 'woocommerce_comment_pagination_args', array(
			'prev_text' => '&larr;',
			'next_text' => '&rarr;',
			'type'      => 'list',
		) ) );
		echo '</nav>';
	endif; ?>

<?php else : ?>

	<p class="woocommerce-noreviews"><?php esc_html_e( 'There are no reviews yet.', 'automatic' ); ?></p>

<?php endif; ?>

	<div class="clear"></div>
</div>
