<?php 
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $product;
$review_count = $product->get_review_count();
$rating_count = $product->get_rating_count();
?>

<?php
	/**
	 * woocommerce_before_single_product hook.
	 *
	 * @hooked wc_print_notices - 10
	 */
	 do_action( 'woocommerce_before_single_product' );

	 if ( post_password_required() ) {
	 	echo get_the_password_form();
	 	return;
	 }
?>

<div itemscope itemtype="<?php echo woocommerce_get_product_schema(); ?>" id="product-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="automatic-single-product">
		<div class="row">
			<div class="col-md-6">
				<?php
					/**
					 * woocommerce_before_single_product_summary hook.
					 *
					 * @hooked woocommerce_show_product_sale_flash - 10
					 * @hooked woocommerce_show_product_images - 20
					 */
					do_action( 'woocommerce_before_single_product_summary' );
				?>
			</div>
			<div class="col-md-6">
				<div class="automatic-block automatic-border-bt">
					<div class="automatic-block-left">
						<h2><?php the_title(); ?></h2>
						<?php echo woocommerce_template_single_meta($product->get_id()); ?>
					</div>
					<div class="automatic-block-right">
						<?php echo woocommerce_template_single_rating($product->get_id()); ?>
					</div>
					<div class="automatic-block automatic-block-two">
						<div class="automatic-block-left-1">
							<?php echo woocommerce_template_single_price($product->get_id()); ?>
						</div>
						<div class="automatic-block-right-1">
							<?php if ( $rating_count > 0 ) : ?>
								<?php if ( comments_open() ) : ?><a href="#reviews" class="woocommerce-review-link" rel="nofollow"><i class="automaticicon-customer_review"></i><?php printf( _n( '%s customer review', '%s customer reviews', $review_count, 'automatic' ), '<span itemprop="reviewCount" class="count">' . $review_count . '</span>' ); ?></a>
								<?php endif; ?>
							<?php endif; ?>
						</div>  
					</div>
				</div>

				<div class="automatic-short-des automatic-border-bt">
					<div class="brand-product">
						<?php 
						if(class_exists('YITH_WCBR')){
							$terms = get_the_terms( $product->get_id(), YITH_WCBR::$brands_taxonomy );
							if( ! empty( $terms ) ){
									foreach( $terms as $term ){
										$term_link = get_term_link( $term );
											$term_id = $term -> term_id;
										$thumbnail_id = get_woocommerce_term_meta( $term_id , 'thumbnail_id', true);
											$image = wp_get_attachment_url($thumbnail_id);
											if ($image) {
													echo '<img src="' . esc_url($image) . '" alt="" />';
											}
									}
							}
						}
						?>
					</div>
					<span><?php  echo esc_html__('Availablity:', 'automatic');  ?>&nbsp;</span>
					<span class="in-stock">
						<?php if ( ! $product->is_in_stock() ) {
						    echo esc_html__('out stock', 'automatic');
						}else{
							echo esc_html__('in stock', 'automatic');
						}
						?>
					</span>
					<div class="excerpt">
						<?php echo woocommerce_template_single_excerpt($product->get_id());?>
					</div>
				</div>
				<div class="buttons-block">
					<?php echo woocommerce_template_single_add_to_cart($product->get_id()); ?>
					<div class="automatic-yith-all">
						<?php
					        if(class_exists( 'YITH_WOOCOMPARE' ) ) {
					        	printf('<div class="add-to"><a onclick="" data-toggle="tooltip" href="%s" class="%s" data-product_id="%d" title="%s"><i class="fa fa-retweet" aria-hidden="true"></i>'.esc_html__('Compare', 'automatic').'</a></div>', automatic_add_compare_action($product->get_id()), 'add_to_compare compare', $product->get_id(), esc_html__('Compare', 'automatic'));
					        }
					        if (class_exists('YITH_WCWL')) {
					            echo do_shortcode('[yith_wcwl_add_to_wishlist]');
					        }
				        ?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
		/**
		 * woocommerce_after_single_product_summary hook.
		 *
		 * @hooked woocommerce_output_product_data_tabs - 10
		 * @hooked woocommerce_upsell_display - 15
		 * @hooked woocommerce_output_related_products - 20
		 */
		do_action( 'woocommerce_after_single_product_summary' );
	?>

	<meta itemprop="url" content="<?php the_permalink(); ?>" />

</div><!-- #product-<?php the_ID(); ?> -->

<?php //do_action( 'woocommerce_after_single_product' ); ?>
