<?php 

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product;

// Ensure visibility
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>
<div <?php post_class(); ?>>
	<div class="row">
		<div class="col-xs-12 col-sm-4 col-md-4">
			<?php
			$attachment_ids = $product->get_gallery_image_ids();
			if ( $attachment_ids ) {
				?>
				<div class="product-thumbnails">
					<div class="flexslider">
						<ul class="slides">
							<?php
								$i=0;
							foreach ( $attachment_ids as $attachment_id ) {
								$i++;
												$images = wp_get_attachment_image_src( $attachment_id, 'automatic-image-product-list' );
												?>
												<li>
									<img src="<?php echo esc_url($images[0]); ?>" alt="image-product">
								</li>
												<?php
							}
							?>
						</ul>
					</div>
				</div>
				<?php
			}else{
				?>
				<div class="product-thumbnails">
					<?php
						the_post_thumbnail( 'automatic-image-product-list' );
					?>
				</div>
			<?php
			}
			automatic_product_alert($product);
			?>
		</div>
		<div class="col-xs-12 col-sm-4 col-md-4">
			<a href="<?php the_permalink();?>" title="<?php the_title();?>"><?php echo '<h3>'. get_the_title() .'</h3>' ?></a>
			<?php
				automatic_product_term($product);
			?>
				<div class="short-description">
					<?php echo apply_filters( 'woocommerce_short_description', $post->post_excerpt ) ?>
				</div>
		</div>
		<div class="col-xs-12 col-sm-4 col-md-4">
			<?php
				$average = $product->get_average_rating();
				$automatic_rate_ave = "";
				if (($average < 3 && $average > 0)) {
					$automatic_rate_ave = "rate_red";
				}
				elseif (($average < 4 && $average >= 3)) {
					$automatic_rate_ave = "rate_yellow";
				}
				elseif (($average <= 5 && $average >= 4)) {
					$automatic_rate_ave = "rate_blue";
				}
				if ( $average != 0 ){
					echo '<div class="product-title-has-rate">';
					?>
					<span class="rating-product <?php echo esc_attr($automatic_rate_ave); ?>">
						<i class="automaticicon-rate"></i><?php echo esc_html($average); ?>
					</span>
					<?php
					echo '</div>';
				}
			?>
			<div class="format-price-addcart">
				<div class="price-product"><?php echo woocommerce_template_loop_price();?></div>
				<div class="btn-cart"><?php woocommerce_template_loop_add_to_cart();?></div>
			</div>
			<?php 
				automatic_product_share_yith($product);
			?>
		</div>
	</div>
</div>
