<?php
/**
 * The template for displaying search results pages
 *
 * @package WordPress
 * @subpackage Automatic
 * @since Automatic 1.0
 */

get_header();
$automatic_sidebar_position = 'left'; 
$padding_top = '';
$padding_bottom = '';
$automatic_config = automatic_settings();
if(isset($automatic_config['post_sidebar_position'])){
	$automatic_sidebar_position = $automatic_config['post_sidebar_position'];
}
if(isset($automatic_config['post_sidebar'])){
	$automatic_sidebars = $automatic_config['post_sidebar'];
	if(!is_active_sidebar($automatic_sidebars)){
		$automatic_sidebar_position = 'none'; 
	}
}
if ( get_post_meta(get_the_ID(), 'no_padding_top', true) != ''){

	$padding_top = get_post_meta(get_the_ID(), 'no_padding_top', true);
}
if ( get_post_meta(get_the_ID(), 'no_padding_bottom', true) != ''){
	$padding_bottom = get_post_meta(get_the_ID(), 'no_padding_bottom', true);
}

if($automatic_sidebar_position == 'left-sidebar' ){
	$automatic_class_sidebar = "sidebar_left";
	$automatic_wrap_content = 'col-xs-12 col-sm-12 col-md-9 right';
}else if( $automatic_sidebar_position == 'right-sidebar' ){
	$automatic_class_sidebar = "sidebar_right";
	$automatic_wrap_content = 'col-xs-12 col-sm-12 col-md-9';
}else{
	$automatic_wrap_content='col-xs-12 col-sm-12 col-md-12';
}
$blog_show_breadcrum = '';
if( isset( $automatic_config['archive_blog_banner'] )) :
	$blog_show_breadcrum = $automatic_config['archive_blog_banner'];
endif;
?>
<div id="primary" class="content-area">
	<main id="main" class="site-main blog show" role="main">
		<?php if ( $blog_show_breadcrum == 'show' ) : ?>
			<div class="container">
				<div class="bread-crumb">
					<?php echo automatic_breadcrumbs(); ?>
				</div>
			</div>
		<?php endif; ?>
		<div class="container">
			<div class="row">
				<div class="<?php echo ($automatic_wrap_content); ?>">
					<?php if ( have_posts() ) : ?>

						<header class="page-header">
							<h1 class="page-title"><?php printf( esc_html__( 'Search Results for: %s', 'automatic' ), '<span>' . esc_html( get_search_query() ) . '</span>' ); ?></h1>
						</header><!-- .page-header -->

						<?php
						// Start the loop.
						while ( have_posts() ) : the_post();
							get_template_part( 'template-parts/content', get_post_format() );
						// End the loop.
						endwhile;

						// Previous/next page navigation.
						the_posts_pagination( array(
							'prev_text'          => '&lt;',
							'next_text'          => '&gt;',
							'before_page_number' => '<span class="meta-nav screen-reader-text"></span>',
						) );

					// If no content, include the "No posts found" template.
					else :
						get_template_part( 'template-parts/content', 'none' );

					endif;
					?>
					</div>
					<?php
					if( $automatic_sidebar_position != 'none' && $automatic_sidebar_position != '' ){ ?>
						<div class="col-md-3 col-xs-12 col-sm-12 <?php echo ( $automatic_class_sidebar ); ?>">
							<div class="sidebar sidebarArea sidebar-blog">
								<?php dynamic_sidebar($automatic_sidebars ); ?>
							</div>
						</div>
					<?php
						}
					?>
				</div>
			</div>
		</main><!-- .site-main -->
	</div><!-- .content-area -->
<?php get_footer(); ?>
