<?php
/**
 * Social Widget
 */

class WP_Automatic_Widget_Social extends WP_Widget
{

    function __construct()
    {
        $widget_ops = array( 'classname' => 'automatic_widget_social', 'description' => esc_html__( "Automatic social option.", "automatic") );
        parent::__construct( 'automatic-social', esc_html__( '[Automatic] Social', 'automatic' ), $widget_ops );
        $this->alt_option_name = 'automatic_widget_social';
    }
    public function widget( $args, $instance ){
		$automatic_config = automatic_settings();
		global $automatic_social_array;
		$automatic_socials = $automatic_social_array;
		echo $args['before_widget'];
			if ( $instance['title'] ) {
                echo $args['before_title'] . esc_html($instance['title']) . $args['after_title'];
            }
			if (count($automatic_social_array)>0) :
				echo '<div class="social-login-options">';
				foreach( $automatic_socials as $key => $value):
					if($instance['show_'.$key] == 'show' && isset($automatic_config['social_'.$key.'_link']) ){
						echo '<div class="social"> <a href="'.esc_url($automatic_config['social_'.$key.'_link']).'" target="_blank"><i class="fa fa-'.$key.'"></i></a></div>';
					}
				endforeach;
				echo '</div>';
			endif; // End automatic_social_array
		echo $args['after_widget'];
    }
    public function update( $new_instance, $old_instance){
        $instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		global $automatic_social_array;
		$automatic_socials = $automatic_social_array;
		if (count($automatic_social_array)>0) :
			foreach( $automatic_socials as $key => $value):
				$instance['show_'.$key] = $new_instance['show_'.$key];
			endforeach;
		endif; // End automatic_social_array
        return $instance;
    }
    public function form( $instance){
		global $automatic_social_array;
		$automatic_socials = $automatic_social_array;
		$title	 = isset( $instance['title'] ) ? esc_html($instance['title']) : esc_html__('Connect Us','automatic');
		?>
		<p><label for="<?php echo  esc_html($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:','automatic' ); ?></label>
        <input class="widefat" id="<?php echo  esc_html($this->get_field_id( 'title' )); ?>" name="<?php echo  esc_html($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo  esc_html($title); ?>" /></p>
		<?php
		if (count($automatic_social_array)>0) :
			foreach( $automatic_socials as $key => $value):
				$show_social  = isset( $instance['show_'.$key] ) ? esc_attr( $instance['show_'.$key] ) : '';
        ?>
				<p>
					<input type="checkbox" class="widefat" id="<?php echo ($this->get_field_id( 'show_'.$key)); ?>" name="<?php echo ($this->get_field_name( 'show_'.$key)); ?>" value="show" <?php checked( $show_social, 'show' ); ?>/>
					<label for="<?php echo ($this->get_field_id( 'show_'.$key)); ?>"><?php  echo esc_html__( 'Show','automatic' ).' '. esc_html($value); ?></label>
				</p>
        <?php
			endforeach;
		endif; // End automatic_social_array
    }
}