<?php
/**
 * Logo Widget
 */

class WP_Automatic_Widget_Logo extends WP_Widget
{

    function __construct()
    {
        $widget_ops = array( 'classname' => 'automatic_widget_logo', 'description' => esc_html__( "Automatic logo option.", "automatic") );
        parent::__construct( 'automatic-logo', esc_html__( '[Automatic] Logo', 'automatic' ), $widget_ops );
        $this->alt_option_name = 'automatic_widget_logo';
    }
    public function widget( $args, $instance ){
		$config = automatic_settings();
		$automatic_name=get_option('blogname');
		$automatic_description=get_option('blogdescription');
        $des_site = ( ! empty( $instance['des_site'] ) ) ? $instance['des_site'] : '';
        echo $args['before_widget'];
			echo '<div class="footer-logo logo">';
				echo '<a href="'.esc_url( home_url( '/' ) ).'">';
					if($config['logo_type']=='logo_image' && isset($config['logo_image'])){
						echo '<img src="'. esc_url(str_replace(array('http:', 'https:'), '', $config['logo_image']['url'])) . '" alt="' . esc_attr(get_bloginfo('name', 'display')) . '">';
					}else{
						echo '<span class="site-title">'. esc_html($automatic_name) .'</span>';
					}
				echo '</a>';
                if ( $des_site !='' ) {
                    echo '<span class="text">'. esc_html($des_site) .'</span>';
                }else{
                    echo '<span class="text">'. esc_html($automatic_description) .'</span>';
                }
			echo '</div>';
		echo $args['after_widget'];
    }
    public function update( $new_instance, $old_instance){
        $instance = $old_instance;
        $instance['show_logo'] = $new_instance['show_logo'];
        $instance['show_des'] = $new_instance['show_des'];
        $instance['des_site'] = $new_instance['des_site'];
        return $instance;
    }
    public function form( $instance){
        $show_logo  = isset( $instance['show_logo'] ) ? esc_attr( $instance['show_logo'] ) : '';
        $show_des  = isset( $instance['show_des'] ) ? esc_attr( $instance['show_des'] ) : '';
        $des_site  = isset( $instance['des_site'] ) ? esc_attr( $instance['des_site'] ) : '';
        ?>
        <p>
			<input type="checkbox" class="widefat" id="<?php echo ($this->get_field_id( 'show_logo' )); ?>" name="<?php echo ($this->get_field_name( 'show_logo' )); ?>" value="show" <?php checked( $show_logo, 'show' ); ?>/>
			<label for="<?php echo ($this->get_field_id( 'show_logo' )); ?>"><?php  esc_html_e( 'Show Logo','automatic' ); ?></label>
		</p>
        <p>
			<input type="checkbox" class="widefat" id="<?php echo ($this->get_field_id( 'show_des' )); ?>" name="<?php echo ($this->get_field_name( 'show_des' )); ?>" value="show" <?php checked( $show_des, 'show' ); ?>/>
			<label for="<?php echo ($this->get_field_id( 'show_des' )); ?>"><?php  esc_html_e( 'Show Description Site','automatic' ); ?></label>
		</p>
        <p>
            <label for="<?php echo ($this->get_field_id( 'des_site' )); ?>"><?php  esc_html_e( 'Text Description','automatic' ); ?></label>
            <input type="text" class="widefat" id="<?php echo ($this->get_field_id( 'des_site' )); ?>" name="<?php echo ($this->get_field_name( 'des_site' )); ?>" value="<?php echo  esc_attr($des_site); ?>"/>

        </p>
        <?php
    }
}