<?php
/*add filter*/
add_filter( 'loop_shop_per_page', 'automatic_num_product', 20 );

/* add_filter('woocommerce_checkout_fields', 'automatic_override_billing_fields');
add_filter('woocommerce_checkout_fields', 'automatic_override_shipping_fields'); */
add_filter('woocommerce_checkout_fields', 'automatic_custom_override_checkout_fields');
add_filter("woocommerce_checkout_fields", 'automatic_order_billing_fields');
add_filter("woocommerce_checkout_fields", 'automatic_order_shipping_fields');
/*remove  filter*/
/*remove action*/
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
/*add action*/
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 5);
function au_content_product_list_layout() {
	global $product; 
	if ( empty( $product ) || ! $product->is_visible() ) {
		return;
	}
?>
	<div <?php post_class(); ?>>
		<div class="row">
			<div class="col-xs-12 col-sm-4 col-md-4">
				<?php
				$attachment_ids = $product->get_gallery_attachment_ids();
				if ( $attachment_ids ) {
					?>
					<div class="product-thumbnails">
						<div class="flexslider">
							<ul class="slides">
								<?php
									$i=0;
								foreach ( $attachment_ids as $attachment_id ) {
									$i++;
									$images = wp_get_attachment_image_src( $attachment_id, 'automatic-image-product-list' );
								?>
									<li>
										<img src="<?php echo esc_url($images[0]); ?>" alt="image-product">
									</li>
								<?php
								}
								?>
							</ul>
						</div>
					</div>
					<?php
				}else{
					?>
					<div class="product-thumbnails">
						<?php
							the_post_thumbnail( 'automatic-image-product-list' );
						?>
					</div>
				<?php
				}
				automatic_product_alert($product);
				?>
			</div>
			<div class="col-xs-12 col-sm-4 col-md-4">
				<a href="<?php the_permalink();?>" title="<?php the_title();?>"><?php echo '<h3>'. get_the_title() .'</h3>' ?></a>
				<?php
					automatic_product_term($product);
				?>
					<div class="short-description">
						<?php echo apply_filters( 'woocommerce_short_description', $post->post_excerpt ) ?>
					</div>
			</div>
			<div class="col-xs-12 col-sm-4 col-md-4">
				<?php
					automatic_product_title($product);
				?>
				<div class="format-price-addcart">
					<div class="price-product"><?php echo woocommerce_template_loop_price();?></div>
					<div class="btn-cart"><?php woocommerce_template_loop_add_to_cart();?></div>
				</div>
				<?php 
					automatic_product_share_yith($product);
				?>
			</div>
		</div>
	</div>
<?php 
}
function au_content_product_list() {
	global $product;
	if ( empty( $product ) || ! $product->is_visible() ) {
		return;
	}
?>
	<li <?php post_class(); ?>>
	<div class="row">
		<div class="col-md-4">
			<?php
			automatic_product_thumb($product);
			automatic_product_alert($product);
			?>
		</div>
		<div class="col-md-8">
			<div class="ct-product-right">
				<?php
				automatic_product_title($product);
				automatic_product_term($product);
				?>
			</div>
		</div>
		<div class="format-price-addcart col-md-8">
			<div class="price-product"><?php echo woocommerce_template_loop_price();?></div>
			<div class="btn-cart"><?php woocommerce_template_loop_add_to_cart();?></div>
		</div>
	</div>
</li>
<?php
}
function au_content_product() {
	global $product;
	if ( empty( $product ) || ! $product->is_visible() ) {
		return;
	}
	?>
	<li <?php post_class(); ?>>
	<?php
		automatic_product_thumb($product);
		automatic_product_alert($product);
		automatic_product_title($product);
		automatic_product_term($product);
	?>
	<div class="format-price-addcart">
		<div class="price-product"><?php echo woocommerce_template_loop_price();?></div>
		<div class="btn-cart"><?php woocommerce_template_loop_add_to_cart();?></div>
	</div>
	<?php 
		automatic_product_share_yith($product);
	?>
</li>
	<?php
}
function automatic_product_term($product) { 
	$terms = get_the_terms( $product -> get_id(), 'product_cat' );
	if(is_array($terms)){
		echo '<ul class="terms-product">';
		foreach ($terms as $term) {
			$term_link = get_term_link( $term );
			echo '<li><a href="' . esc_url( $term_link ) .'">'.esc_attr( $term->name ).'</a></li>';
		}
		echo '</ul>';
  }
}
function automatic_product_alert($product) { 
	$price = get_post_meta( $product -> get_id() , '_regular_price', true);
    $sale = get_post_meta( $product -> get_id() , '_sale_price', true);
    if ( $sale != '' && $price!='' ) :
    $discount = number_format( 100 - ($sale*100)/$price ,0,",","");
	?>
	<div class="info-alert"><span class="automatic-title">-<?php echo esc_html($discount);?>%</span></div>
	<?php
	elseif ( $product->is_featured() ) :
		echo '<div class="info-alert"><span class="automatic-title">'.esc_html__('Hot','automatic').'</span></div>';
	endif;
}
function automatic_product_thumb($product) { 
	$attachment_ids = $product->get_gallery_image_ids();
	if ( $attachment_ids ) {
	?>
		<div class="product-thumbnails">
			<div class="flexslider">
				<ul class="slides">
					<?php
					$i=0;
					foreach ( $attachment_ids as $attachment_id ) {
						$i++;
						$images = wp_get_attachment_image_src( $attachment_id, 'automatic-image-product' );
						echo '<li>';
							echo '<img src="'. esc_url($images[0]). '" alt="image-product">';
						echo '</li>';
					}
					?>
				</ul>
			</div>
		</div>
	<?php
	}else{
		echo '<div class="product-thumbnails">';
			the_post_thumbnail( 'automatic-image-product' );
		echo '</div>';
	}
}
function automatic_product_share_yith($product) { ?> 
	<div class="share-yith">
		<?php
		if(class_exists( 'YITH_WOOCOMPARE' ) ) {
			echo '<div class="btn-share btn-compare">';
				printf('<div class="add-to"><a onclick="" data-toggle="tooltip" href="%s" class="%s" data-product_id="%d" title="%s"><i class="fa fa-retweet" aria-hidden="true"></i>'.esc_html__('Compare', 'automatic').'</a></div>', automatic_add_compare_action($product->get_id()), 'add_to_compare compare button', $product->get_id(), esc_html__('Compare', 'automatic'));
			echo '</div>';
		}
		if (class_exists('YITH_WCWL')) {
			echo ' <div class="btn-share btn-wishlist">';
				echo do_shortcode('[yith_wcwl_add_to_wishlist]');
				echo '<span class="wishlist-count"> &#40;'. YITH_WCWL()->count_products() .'&#41;</span>';
			echo '</div>';
		}
		?>
	</div>
	<?php 
}
function automatic_product_title($product) {
	$average = $product->get_average_rating();
	$automatic_rate_ave = "";
	if (($average < 3 && $average > 0)) {
		$automatic_rate_ave = "rate_red";
	}
	elseif (($average < 4 && $average >= 3)) {
		$automatic_rate_ave = "rate_yellow";
	}
	elseif (($average <= 5 && $average >= 4)) {
		$automatic_rate_ave = "rate_blue";
	}
	if ( $average != 0 ){
		echo '<div class="product-title-has-rate">';
	}
		echo '<a href='. get_the_permalink() .'><h3>' . get_the_title() . '</h3></a>';
	if ( $average != 0 ){
	?>
		<span class="rating-product <?php echo esc_attr($automatic_rate_ave); ?>">
			<i class="automaticicon-rate"></i><?php echo esc_html($average); ?>
		</span>
		<?php
		echo '</div>';
	}
}
function automatic_product_view() {
	if ( ! is_singular( 'product' ) ) {
		return;
	}
	global $post;
	if ( empty( $_COOKIE['woocommerce_recently_viewed'] ) )
		$viewed_products = array();
	else
		$viewed_products = (array) explode( '|', $_COOKIE['woocommerce_recently_viewed'] );

	if ( ! in_array( $post->ID, $viewed_products ) ) {
		$viewed_products[] = $post->ID;
	} 
	if ( sizeof( $viewed_products ) > 15 ) {
		array_shift( $viewed_products );
	} 
	wc_setcookie( 'woocommerce_recently_viewed', implode( '|', $viewed_products ) );
}
add_action( 'template_redirect', 'automatic_product_view', 20 );
function bittersweet_pagination(){
	global $wp_query;
	if ( $wp_query->max_num_pages <= 1 ) {
		return;
	}
	$paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var('paged');
	echo '<div class="woocommerce-pagination-top">';
	previous_posts_link( '<i class="fa fa-angle-left" aria-hidden="true"></i>' );
	echo '<span class="current">'.$paged.'</span>';
	echo esc_html__('of','automatic') . ' '.$wp_query->max_num_pages;
	next_posts_link( '<i class="fa fa-angle-right" aria-hidden="true"></i>', $wp_query->max_num_pages );
	echo '</div>';
}
function automatic_num_product(){
    global $automatic_settings;
		if(isset($_GET['automatic_perpage'])){
        return (int)$_GET['automatic_perpage'];
    }else{
			if ( isset( $_GET['column']) ){
					$column = $_GET['column'];
			}else{
					$column = $automatic_settings['column'];
			}
			switch ( $column ) {
				case '2':
					return (int)$automatic_settings['archive_product_num_item_2'];
					break;
				case '3':
					return (int)$automatic_settings['archive_product_num_item_3'];
					break;
				case '4':
					return (int)$automatic_settings['archive_product_num_item_4'];
					break;
				case '5':
					return (int)$automatic_settings['archive_product_num_item_5'];
					break;
				default:
					return (int)get_option('posts_per_page');
					# code...
					break;
			}
		}
}
function automatic_header_minicart(){
	if ( ! WC()->cart->is_empty() ) :
		$automatic_cart_num = WC()->cart->get_cart_contents_count();
	else: $automatic_cart_num =0;
	endif;
	?>
	<div class="automatic-cart f_right">
		<div class="dropdown">
			<button class="dropdown-toggle" type="button" data-toggle="dropdown" >
				<i class="automaticicon-cart"></i><span class="cart-num"><?php echo esc_html($automatic_cart_num); ?></span>
				<span class="automatic_total"><?php echo WC()->cart->get_cart_subtotal(); ?></span>
			</button>
			<div class="dropdown-menu"> <?php automatic_minicart() ?> </div>
		</div>
	</div>
<?php
}
function automatic_minicart(){
	ob_start();
	echo '<div class="widget_shopping_cart_content">';
	get_template_part( 'woocommerce/cart/mini-cart' );
	echo '</div>';
	echo ob_get_clean();
}
function automatic_add_compare_action($product_id){
    $action = 'yith-woocompare-add-product';
    $url_args = array('action' => $action, 'id' => $product_id);
    return wp_nonce_url(add_query_arg($url_args), $action);
}
// Remove default WooCommerce breadcrumbs and add Yoast ones instead
remove_action( 'woocommerce_before_main_content','woocommerce_breadcrumb', 20, 0);

function automatic_product_search_form( $form ) {
    $form = '<form role="search" method="get" class="search-form" action="'. esc_url( home_url( '/' ) ) .'">
		<label>
			<input type="search" class="search-field" placeholder="'.esc_html__('Search for products','automatic').'" value="" name="s">
		</label>
		<button type="submit" class="search-submit"><span class="pe-7s-search color_333"></span></button>
		<input type="hidden" name="post_type" value="product">
	</form>';
    return $form;
}
add_filter( 'get_product_search_form', 'automatic_product_search_form' );
function automatic_product_stock( $_product ) {
	$data = $_product-> get_data();
	if($_product->get_stock_quantity() !=''){
		if($data['total_sales']!=0){
			$units_sold = $data['total_sales'];
		}else{
			$units_sold = 0;
		}
		$units_stock = $_product->get_stock_quantity();
		$_atomatic_width = 0;
		if($_product->get_stock_quantity() !=0 ){
			$_atomatic_count_stock = (int)$units_stock + (int)$units_sold;
			$_atomatic_width = ((int)$units_stock / $_atomatic_count_stock) * 100;
		}
		echo '<div class="stock_number"><div class="already_sold">Already Sold: <b>'.$units_sold.'</b></div><div class="available">Avaiable: <b>'.$units_stock.'</b></div></div>';
		echo'<div class="stock_scroll"><div class="avaiable" style="width: '.$_atomatic_width.'%"></div></div>';
	}
}
function automatic_order_billing_fields($fields) {
    $order = array(
        "billing_country",
        "billing_first_name",
        "billing_last_name",
        "billing_company",
        "billing_address_1",
        "billing_address_2",
        "billing_city",
        "billing_state",
        "billing_postcode",
        "billing_email",
        "billing_phone"
    );
    foreach($order as $field)
    {
        $ordered_fields[$field] = $fields["billing"][$field];
    }

    $fields["billing"] = $ordered_fields;
    return $fields;

}
function automatic_order_shipping_fields($fields) {
    $order = array(
        "shipping_country",
        "shipping_first_name",
        "shipping_last_name",
        "shipping_company",
        "shipping_address_1",
        "shipping_address_2",
        "shipping_city",
        "shipping_state",
        "shipping_postcode",
        "shipping_email",
        "shipping_phone"

    );
    foreach($order as $field)
    {
        $ordered_fields[$field] = $fields["shipping"][$field];
    }

    $fields["shipping"] = $ordered_fields;
    return $fields;

}
function automatic_override_billing_fields( $fields ) {
  $fields['billing_first_name'] = array(
        'label' => esc_html__('First Name','automatic'),
        'placeholder' => _x('First Name *', 'placeholder', 'automatic'),
        'required' => true,
    );
    $fields['billing_last_name'] = array(
        'label' => esc_html__('Last Name','automatic'),
        'placeholder' => _x('Last Name *', 'placeholder', 'automatic'),
        'required' => true,
    );
  $fields['billing_company'] = array(
        'label' => esc_html__('Company name','automatic'),
        'placeholder' => _x('Company Name', 'placeholder', 'automatic'),
        'required' => false,
    );
  $fields['billing_email'] = array(
        'label' => 'Email',
        'placeholder' => _x('E-mail *', 'placeholder', 'automatic'),
        'required' => true,
    );
  $fields['billing_phone'] = array(
        'label' => 'Phone',
        'placeholder' => _x('Phone *', 'placeholder', 'automatic'),
        'required' => true,
    );
  $fields['billing_address_1'] = array(
        'label' => 'Address',
        'placeholder' => _x('Street Address *', 'placeholder', 'automatic'),
        'required' => false,
    );
  $fields['billing_address_2'] = array(
        'label' => esc_html__('Apartment, suite, unit etc. (optional)','automatic'),
        'placeholder' => _x('Apartment, suite, unit etc. (optional)', 'placeholder', 'automatic'),
        'required' => false,
    );
  $fields['billing_postcode'] = array(
        'label' => esc_html__('Postcode / Zip','automatic'),
        'placeholder' => _x('Postcode / Zip *', 'placeholder', 'automatic'),
        'required' => true,
    );
  $fields['billing_city'] = array(
        'label' => esc_html__('Town / City','automatic'),
        'placeholder' => _x('Town / City *', 'placeholder', 'automatic'),
        'required' => true,
    );
  $fields['billing_phone'] = array(
        'label' => esc_html__('Phone','automatic'),
        'placeholder' => _x('Phone *', 'placeholder', 'automatic'),
        'required' => true,
    );
  return $fields;
}
function automatic_override_shipping_fields( $fields ) {
  $fields['shipping_first_name'] = array(
        'label' => esc_html__('First Name','automatic'),
        'placeholder' => _x('First Name *', 'placeholder', 'automatic'),
        'required' => true,
    );
    $fields['shipping_last_name'] = array(
        'label' => esc_html__('Last Name','automatic'),
        'placeholder' => _x('Last Name *', 'placeholder', 'automatic'),
        'required' => true,
    );
  $fields['shipping_company'] = array(
        'label' => esc_html__('Company name','automatic'),
        'placeholder' => _x('Company Name', 'placeholder', 'automatic'),
        'required' => false,
    );
  $fields['shipping_email'] = array(
        'label' => 'Email',
        'placeholder' => _x('E-mail *', 'placeholder', 'automatic'),
        'required' => true,
    );
  $fields['shipping_phone'] = array(
        'label' => 'Phone',
        'placeholder' => _x('Phone *', 'placeholder', 'automatic'),
        'required' => true,
    );
  $fields['shipping_address_1'] = array(
        'label' => 'Address',
        'placeholder' => _x('Street Address *', 'placeholder', 'automatic'),
        'required' => true,
    );
  $fields['shipping_address_2'] = array(
        'label' => esc_html__('Apartment, suite, unit etc. (optional)','automatic'),
        'placeholder' => _x('Apartment, suite, unit etc. (optional)', 'placeholder', 'automatic'),
        'required' => false,
    );
  $fields['shipping_postcode'] = array(
        'label' => esc_html__('Postcode / Zip','automatic'),
        'placeholder' => _x('Postcode / Zip *', 'placeholder', 'automatic'),
        'required' => true,
    );
  $fields['shipping_city'] = array(
        'label' => esc_html__('Town / City','automatic'),
        'placeholder' => _x('Town / City *', 'placeholder', 'automatic'),
        'required' => true,
    );
  $fields['shipping_phone'] = array(
        'label' => esc_html__('Phone','automatic'),
        'placeholder' => _x('Phone *', 'placeholder', 'automatic'),
        'required' => true,
    );
  return $fields;
}
function automatic_custom_override_checkout_fields($fields) {
	$fields['billing']['billing_first_name'] = array(
			'label' => esc_html__('First Name','automatic'),
			'placeholder' => _x('First Name *', 'placeholder', 'automatic'),
			'required' => true,
			'class'     => array('form-row-first'),
	);
	$fields['billing']['billing_last_name'] = array(
			'label' => esc_html__('Last Name','automatic'),
			'placeholder' => _x('Last Name *', 'placeholder', 'automatic'),
			'required' => true,
			'class'     => array('form-row-last'),
	);
	$fields['billing']['billing_company'] = array(
			'label' => '',
			'placeholder' => _x('Company Name', 'placeholder', 'automatic'),
			'required' => false,
			'class'     => array('form-row-wide'),
	);
	$fields['billing']['billing_address_1'] = array(
			'label' => '',
			'placeholder' => _x('Street Address', 'placeholder', 'automatic'),
			'required' => false,
			'class'     => array('form-row-wide'),
	);
	$fields['billing']['billing_address_2'] = array(
			'label' => '',
			'placeholder' => _x('Apartment, suite, unit etc. (optional)', 'placeholder', 'automatic'),
			'required' => false,
	);
	$fields['billing']['billing_city'] = array(
			'label' => esc_html__('City','automatic'),
			'placeholder' => _x('City *', 'placeholder', 'automatic'),
			'required' => true,
	);
	$fields['billing']['billing_postcode'] = array(
			'label' => esc_html__('Postcode / Zip','automatic'),
			'placeholder' => _x('Postcode / Zip *', 'placeholder', 'automatic'),
			'required' => true,
			'value' => '',
			'class'     => array('form-row-last'),
	);
	$fields['billing']['billing_email'] = array(
			'label' => esc_html__('Email Address','automatic'),
			'placeholder' => _x('E-mail *', 'placeholder', 'automatic'),
			'required' => true,
			'class'     => array('form-row-first'),
	);
	$fields['billing']['billing_phone'] = array(
			'label' => esc_html__('Phone','automatic'),
			'placeholder' => _x('Phone *', 'placeholder', 'automatic'),
			'required' => true,
			'class'     => array('form-row-last'),
	);
	$fields['billing']['billing_state'] = array(
			'label' => esc_html__('State / County','automatic'),
			'placeholder' => _x('State / County', 'placeholder', 'automatic'),
			'required' => false,
			'class'     => array('form-row-first'),
	);
	$fields['shipping']['shipping_phone'] = array(
			'label' => esc_html__('Phone','automatic'),
			'placeholder'   => _x('Phone Number *', 'placeholder', 'automatic'),
			'required'  => true,
			'class'     => array('form-row-last'),
	 );
	$fields['shipping']['shipping_first_name'] = array(
			'label' => esc_html__('First Name','automatic'),
			'placeholder' => _x('First Name *', 'placeholder', 'automatic'),
			'required' => true,
			'class'     => array('form-row-first'),
	);
	$fields['shipping']['shipping_last_name'] = array(
			'label' => esc_html__('Last Name','automatic'),
			'placeholder' => _x('Last Name *', 'placeholder', 'automatic'),
			'required' => true,
			'class'     => array('form-row-last'),
	);
	$fields['shipping']['shipping_company'] = array(
			'label' => esc_html__('Company Name','automatic'),
			'placeholder' => _x('Company Name', 'placeholder', 'automatic'),
			'required' => false,
			'class'     => array('form-row-wide'),
	);
	$fields['shipping']['shipping_city'] = array(
			'label' => esc_html__('City','automatic'),
			'placeholder' => _x('City *', 'placeholder', 'automatic'),
			'required' => true,
	);
	$fields['shipping']['shipping_state'] = array(
			'label' => esc_html__('Enter State/Country','automatic'),
			'placeholder' => _x('Enter State/Country *', 'placeholder', 'automatic'),
			'required' => false,
			'class'     => array('form-row-first'),
	);
	$fields['shipping']['shipping_email'] = array(
			'label' => esc_html__('Email Address','automatic'),
			'placeholder' => _x('E-mail *', 'placeholder', 'automatic'),
			'required' => true,
			'class'     => array('form-row-first'),
	);
	$fields['shipping']['shipping_postcode'] = array(
			'label' => esc_html__('Postcode / Zip','automatic'),
			'placeholder' => _x('Postal Code *', 'placeholder', 'automatic'),
			'required' => true,
			'class'     => array('form-row-last'),
	);
	$fields['shipping']['shipping_address_1'] = array(
			'label' => esc_html__('Adress','automatic'),
			'placeholder' => _x('Street Address *', 'placeholder', 'automatic'),
			'required' => true,
			'class'     => array('form-row-wide'),
	);
	$fields['order']['order_comments'] = array(
			'label' => esc_html__('Order notes','automatic'),
			'placeholder' => _x('Order Notes', 'placeholder', 'automatic'),
			'required' => false,
			'type' => 'textarea',
			'class'     => array('form-row-wide'),
	);


	return $fields;
}

function automatic_woocommerce_product_subcategories( $args = array(), $column=3 ) {
	global $wp_query;
	switch ( $column ) {
			case '1':
					$column_index = 1;
					$cl_class = 'col-xs-12 col-sm-12 col-md-12';
					break;
			case '2':
					$column_index = 2;
					$cl_class = 'col-xs-12 col-sm-6 col-md-6';
					break;
			case '3':
					$column_index = 3;
					$cl_class = 'col-xs-12 col-sm-4 col-md-4';
					break;
			case '4':
					$column_index = 4;
					$cl_class = 'col-xs-12 col-sm-6 col-md-3';
					break;
			case '5':
					$column_index = 5;
					$cl_class = 'col-xs-12 col-sm-15 col-md-15';
					break;

			default:
					$cl_class = '';
					break;
	}
	$defaults = array(
		'before'        => '',
		'after'         => '',
		'force_display' => false
	);

	$args = wp_parse_args( $args, $defaults );

	extract( $args );

	// Main query only
	if ( ! is_main_query() && ! $force_display ) {
		return;
	}

	// Don't show when filtering, searching or when on page > 1 and ensure we're on a product archive
	if ( is_search() || is_filtered() || is_paged() || ( ! is_product_category() && ! is_shop() ) ) {
		return;
	}

	// Check categories are enabled
	if ( is_shop() && '' === get_option( 'woocommerce_shop_page_display' ) ) {
		return;
	}

	// Find the category + category parent, if applicable
	$term       = get_queried_object();
	$parent_id     = empty( $term->term_id ) ? 0 : $term->term_id;

	if ( is_product_category() ) {
		$display_type = get_woocommerce_term_meta( $term->term_id, 'display_type', true );

		switch ( $display_type ) {
			case 'products' :
				return;
			break;
			case '' :
				if ( '' === get_option( 'woocommerce_category_archive_display' ) ) {
					return;
				}
			break;
		}
	}

	// NOTE: using child_of instead of parent - this is not ideal but due to a WP bug ( https://core.trac.wordpress.org/ticket/15626 ) pad_counts won't work
	$product_categories = get_categories( apply_filters( 'woocommerce_product_subcategories_args', array(
		'parent'       => $parent_id,
		'menu_order'   => 'ASC',
		'hide_empty'   => 0,
		'hierarchical' => 1,
		'taxonomy'     => 'product_cat',
		'pad_counts'   => 1
	) ) );

	if ( ! apply_filters( 'woocommerce_product_subcategories_hide_empty', false ) ) {
		$product_categories = wp_list_filter( $product_categories, array( 'count' => 0 ), 'NOT' );
	}

	if ( $product_categories ) {
		echo $before;

		foreach ( $product_categories as $category ) {
			?>
			<div class="<?php echo esc_attr($cl_class); ?>">
					<ul>
							<?php
							wc_get_template( 'content-product_cat.php', array(
								'category' => $category
							) );
							?>
					</ul>
			</div>
			<?php
		}

		// If we are hiding products disable the loop and pagination
		if ( is_product_category() ) {
			$display_type = get_woocommerce_term_meta( $term->term_id, 'display_type', true );

			switch ( $display_type ) {
				case 'subcategories' :
					$wp_query->post_count    = 0;
					$wp_query->max_num_pages = 0;
				break;
				case '' :
					if ( 'subcategories' === get_option( 'woocommerce_category_archive_display' ) ) {
						$wp_query->post_count    = 0;
						$wp_query->max_num_pages = 0;
					}
				break;
			}
		}

		if ( is_shop() && 'subcategories' === get_option( 'woocommerce_shop_page_display' ) ) {
			$wp_query->post_count    = 0;
			$wp_query->max_num_pages = 0;
		}

		echo $after;

		return true;
	}
}
$wc_admin_report = WC()->plugin_path() . '/includes/admin/reports/class-wc-admin-report.php';
require_once $wc_admin_report;
class WC_Bestseller extends WC_Admin_Report
{
	public function list_product_bestseller(){
		$args_bestseller = array(
			'data'         => array(
					'_product_id' => array(
						'type'            => 'order_item_meta',
						'order_item_type' => 'line_item',
						'function'        => '',
						'name'            => 'product_id'
					),
					'_qty'        => array(
						'type'            => 'order_item_meta',
						'order_item_type' => 'line_item',
						'function'        => 'SUM',
						'name'            => 'order_item_qty'
					)
			),
			'where_meta'   => array(
					array(
						'type'       => 'order_item_meta',
						'meta_key'   => '_line_subtotal',
						'meta_value' => '0',
						'operator'   => '>'
					)
			),
			'order_by'     => 'order_item_qty DESC',
			'group_by'     => 'product_id',
			'limit'        => '',
			'query_type'   => 'get_results',
		);
		$best_sellers = WC_Admin_Report::get_order_report_data( $args_bestseller );
		return $best_sellers;
	}
}

if(get_option('woocommerce_hide_out_of_stock_items')=='yes'){
	add_action( 'pre_get_posts', 'au_custom_pre_get_posts_query' );
	add_action( 'pre_get_posts', 'au_hide_out_of_stock_products' );
}
function au_custom_pre_get_posts_query( $q ) {

if ( ! $q->is_main_query() ) return;
if ( ! $q->is_post_type_archive() ) return;
if ( ! is_admin() ) {
$q->set( 'meta_query', array(array(
    'key'       => '_stock_status',
    'value'     => 'outofstock',
    'compare'   => 'NOT IN'
)));
}
remove_action( 'pre_get_posts', 'au_custom_pre_get_posts_query' );
}
function au_hide_out_of_stock_products( $q ) {
	if ( ! $q->is_main_query() || is_admin() ) {
			return;
	}
	if ( $outofstock_term = get_term_by( 'name', 'outofstock', 'product_visibility' ) ) {
			$tax_query = (array) $q->get('tax_query');
			$tax_query[] = array(
					'taxonomy' => 'product_visibility',
					'field' => 'term_taxonomy_id',
					'terms' => array( $outofstock_term->term_taxonomy_id ),
					'operator' => 'NOT IN'
			);
			$q->set( 'tax_query', $tax_query );
	}
	remove_action( 'pre_get_posts', 'au_hide_out_of_stock_products' );
}