<?php
function automatic_show_post_option() {
    global $post;
?>
    <div class="automatic_option_post" id="post-metabox">
		<label><strong><?php esc_html_e( 'Post option', 'automatic');?></strong></label>
        <!-- Add link -->
		<div class="post-metabox-child post-metabox-link" data-post-format="link">
			<p><label for="post_link_title"><strong><?php esc_html_e( 'Add title', 'automatic' ); ?></strong></label></p>
			<p><input type="text" name="post_link_title" class="widefat" value="<?php echo esc_attr( get_post_meta($post->ID, 'post_link_title', true )); ?>"/>
			</p>
			<p><label for="post_link_url"><strong><?php esc_html_e( 'Add url', 'automatic' ); ?></strong></label></p>
			<p><input type="text" name="post_link_url" class="widefat" value="<?php echo esc_url(get_post_meta($post->ID, 'post_link_url', true )); ?>"/></p>
			<p class="howto"><?php esc_html_e( 'Add a link to this post, it will show up at the top of the post', 'automatic' ); ?></p>
		</div>
        <!-- Add Image -->
		<div class="post-metabox-child post-metabox-image" data-post-format="image">
		</div>
        <!-- Add gallery -->
		<div class="post-metabox-child post-metabox-gallery" data-post-format="gallery">
			<a href="#" class="button add-images" title="<?php esc_html_e( 'Add image(s)','automatic'); ?>" data-uploader-tittle="<?php esc_html_e( 'Add image (s)','automatic'); ?>" data-uploader-button-text="<?php esc_html_e( 'Add image(s)','automatic'); ?>"><?php esc_html_e( 'Add image (s)','automatic'); ?></a>
            <ul class="images-list">
                <?php
                $post_gallery_id = get_post_meta($post->ID, 'post_gallery_id', true);
                $post_gallery_id = explode (',',$post_gallery_id);
                if ( is_array($post_gallery_id) && count($post_gallery_id) > 0 ):
                    foreach( $post_gallery_id as $key => $value ) :

                        $image = wp_get_attachment_image_src( (int)$value ); ?>
                    <li>
                        <input type="hidden" name="post_gallery_id[<?php echo esc_attr($key); ?>]" value="<?php echo esc_attr( $value ); ?>"/>
                        <img class="image-preview" src="<?php echo esc_url( $image[0] ); ?>"/>
                        <a href="#" class="change-image"
                            title="<?php esc_html_e( 'Change image', 'automatic' ); ?>"
                            data-uploader-title="<?php esc_html_e( 'Change image', 'automatic' ); ?>"
                            data-uploader-button-text="<?php esc_html_e( 'Change image', 'automatic' ); ?>"><i class="dashicons dashicons-edit"></i></a>
                        <a href="#" class="remove-image" title="<?php esc_html_e( 'Remove Image', 'automatic' ); ?>"><i class="dashicons dashicons-no"></i></a>
                    </li>
                <?php
                    endforeach;
                endif; ?>
            </ul>
		</div>
        <!-- Add Quote -->
       <div class="post-metabox-child post-metabox-quote" data-post-format="quote">
            <p><label for="post_quote_content"><strong><?php esc_html_e( 'Quote content', 'automatic' ); ?></strong></label></p>
            <p><textarea class="widefat" name="post_quote_content" id="post_quote_content" cols="30" rows="10"><?php echo esc_attr( get_post_meta($post->ID, 'post_quote_content', true ) ); ?></textarea></p>
            <p><label for="post_quote_by"><strong><?php esc_html_e( 'Quote by', 'automatic' ); ?></strong></label></p>
            <p><input type="text" name="post_quote_by" class="widefat" value="<?php echo esc_attr( get_post_meta($post->ID, 'post_quote_by', true ) ); ?>"/></p>
        </div>
        <!-- Add Video -->
        <div class="post-metabox-child post-metabox-video" data-post-format="video">
            <p><label for="post_video_url"><strong><?php esc_html_e( 'Add video url or upload', 'automatic' ); ?></strong></label></p> 
            <p><textarea class="widefat" name="post_video_url" id="post_video_url" cols="30" rows="10"><?php echo esc_attr( get_post_meta($post->ID, 'post_video_url', true ) ); ?></textarea></p>

        </div>
        <!-- Add audio -->
        <div class="post-metabox-child post-metabox-audio" data-post-format="audio">
            <p><label for="post_audio_url"><strong><?php esc_html_e( 'Add audio url or upload', 'automatic' ); ?></strong></label></p>
            <p><input type="text" name="post_audio_url" class="widefat" value="<?php echo esc_attr( get_post_meta($post->ID, 'post_audio_url', true ) ); ?>"/></p>
            <p><a href="#" class="button add-audio"
                title="<?php esc_html_e( 'Upload audio', 'automatic' ) ?>"
                data-uploader-title="<?php esc_html_e( 'Add audio', 'automatic'); ?>"
                data-uploader-button-text="<?php esc_html_e( 'Add audio', 'automatic'); ?>"><?php esc_html_e( 'Upload', 'automatic' ); ?></a></p>
            <p class="howto"><?php esc_html_e( 'Supports: soundcloud and self hosted audios', 'automatic' ); ?></p>
        </div>
	</div>
    <?php
}
function automatic_save_post_meta_option($post_id) {
    $automatic_post_meta_data = automatic_post_meta_data();
    return automatic_save_meta_data($post_id, $automatic_post_meta_data);
}
function automatic_add_post_metaboxes() {
    if (function_exists('add_meta_box')) {
        add_meta_box('view-post_meta', esc_html__('Post Option', 'automatic'), 'automatic_show_post_option', 'post', 'normal', 'low');
    }
}
function automatic_meta_post_assets(){
	if ( isset( $GLOBALS['post_type'] ) && in_array( $GLOBALS['post_type'], array('post') ) ) {
		wp_enqueue_script( 'automatic-metabox', get_template_directory_uri() . '/inc/functions/metaboxes/js/metabox.js', array( 'jquery' ), '1.0');
		wp_enqueue_script( 'automatic-post-metabox', get_template_directory_uri() . '/inc/functions/metaboxes/js/post.metabox.js', array( 'jquery' ), '1.0');
		wp_enqueue_script( 'jquery-ui-core', get_template_directory_uri() . '/inc/functions/metaboxes/js/jquery-ui.min.js', array( 'jquery' ), '', true );
		wp_enqueue_style("automatic-page-metabox-style",get_template_directory_uri().'/inc/functions/metaboxes/css/metabox.css', array(), '1.0');
		wp_enqueue_style("automatic-post-metabox-style",get_template_directory_uri().'/inc/functions/metaboxes/css/post.metabox.css', array(), '1.0');
	}
}
add_action('add_meta_boxes', 'automatic_add_post_metaboxes');
add_action('save_post', 'automatic_save_post_meta_option');
add_action('admin_enqueue_scripts', 'automatic_meta_post_assets' );

