<?php

add_action('redux/options/automatic_settings/saved', 'automatic_save_theme_settings', 10, 2);
add_action('redux/options/automatic_settings/import', 'automatic_save_theme_settings', 10, 2);
add_action('redux/options/automatic_settings/reset', 'automatic_save_theme_settings');
add_action('redux/options/automatic_settings/section/reset', 'automatic_save_theme_settings');
add_action('redux/options/automatic_settings/compiler/advanced', 'automatic_save_theme_advanced');

function automatic_config_value($value) {
    return isset($value) ? $value : 0;
}

//complie scss
function automatic_save_theme_advanced() { 
	return;
}
function automatic_save_theme_settings() {
	global $automatic_settings;
    global $automaticReduxSettings;

    $reduxFramework = $automaticReduxSettings->ReduxFramework;
    $template_dir = get_template_directory() .'/assets';

    // Compile SCSS Files
    if (!class_exists('scssc')) {
        include( automatic_admin . '/sassphp/scss.inc.php' );
    }

    // config skin file
    ob_start();
    include (automatic_admin . '/sassphp/config_skin_scss.php');
    $_config_css = ob_get_clean();

    $filename = $template_dir . '/scss/config/_config_skin.scss';
 

    if (file_exists($filename)) { 
        @unlink($filename);
    }
    $reduxFramework->filesystem->execute('put_contents', $filename, array('content' => $_config_css));

    $fileMaps = array('config-color','config-fonts','automatic_custom');

    foreach($fileMaps as $value) {
        ob_start(); 
        if($value == 'automatic_custom') {
            if (isset($automatic_settings['custom-css-code']))
                echo ($automatic_settings['custom-css-code']);
        }else{
			$scss = new scssc();
			$scss->setImportPaths($template_dir . '/scss');
			$scss->setFormatter('scss_formatter');
			echo ($scss->compile('@import "'.$value.'.scss"'));
		}

        $_config_css = ob_get_clean();

        $filename = $template_dir . '/css/'.$value.'.css';
 

        if (file_exists($filename)) { 
            @unlink($filename);
        }
        $reduxFramework->filesystem->execute('put_contents', $filename, array('content' => $_config_css));
    }
	$automatic_text_translates =array('topbar_welcome','topbar_help','menu_quickly_text','topbar_location_text','topbar_shop_text','topbar_myaccount_text','header_1_stick1','header_1_stick2','header_1_menu_department_text','header_2_menu_department_text','header_3_menu_department_text','404_title','404_txt','seach_text','seach_product_text');
	foreach($automatic_text_translates as $automatic_text_translate){
		if(isset($automatic_settings[$automatic_text_translate]) && $automatic_settings[$automatic_text_translate] !=''){
			if(get_option($automatic_text_translate)){
				update_option($automatic_text_translate,esc_html($automatic_settings[$automatic_text_translate]));
			}else{
				add_option( $automatic_text_translate, esc_html($automatic_settings[$automatic_text_translate]), '', 'yes' );
			}
		}else{
			delete_option( $automatic_text_translate);
		}
	}
}